/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

import com.vmware.dr.ui.tools.utilities.ContextApplier;
import org.apache.commons.lang.Validate;

public final class ContextApplierImpl<STATE_TYPE>
implements ContextApplier {
    private final ThreadLocal<STATE_TYPE> _threadState;
    private final STATE_TYPE _ownState;
    private final String _label;

    public ContextApplierImpl(ThreadLocal<STATE_TYPE> threadState, STATE_TYPE ownState) {
        Validate.notNull(threadState, (String)"state");
        this._threadState = threadState;
        this._ownState = ownState;
        this._label = "ContextApplierImpl{_ownState='" + ownState + "'}";
    }

    @Override
    public Object apply() {
        STATE_TYPE prev = this._threadState.get();
        if (this._ownState == null) {
            this._threadState.remove();
        } else {
            this._threadState.set(this._ownState);
        }
        return prev;
    }

    @Override
    public void undo(Object prev) {
        if (prev == null) {
            this._threadState.remove();
        } else {
            this._threadState.set(prev);
        }
    }

    @Override
    public boolean isApplied() {
        return this._threadState.get() == this._ownState;
    }

    public String toString() {
        return this._label;
    }
}

