/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

import java.security.SecureRandom;

public final class ExpBackOffCalculator {
    private static final int MIN_INCREMENTS = 11;
    private static final int MAX_INCREMENTS = 17;
    private static final long MIN_INTERVAL = (long)Math.pow(2.0, 11.0);
    private static final long MAX_INTERVAL = (long)Math.pow(2.0, 17.0);
    private long _minInterval = MIN_INTERVAL;
    private long _maxInterval = (long)Math.pow(2.0, 13.0);
    private final SecureRandom _rand = new SecureRandom();

    public synchronized long nextBackOffInterval() {
        if (this._maxInterval >= MAX_INTERVAL || this._minInterval >= this._maxInterval) {
            return MAX_INTERVAL;
        }
        long currentMin = this._minInterval;
        long currentMax = this._maxInterval;
        int delta = (int)(currentMax - currentMin);
        int random = this._rand.nextInt(delta);
        this.increment();
        return currentMin + (long)random;
    }

    private void increment() {
        this._maxInterval *= 2L;
        this._minInterval += 2L * MIN_INTERVAL;
    }
}

