/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.common;

import com.vmware.srm.client.topology.impl.utils.Exceptions;
import java.util.HashMap;
import java.util.Map;

public class Registry<T> {
    private final Map<String, T> _valueById = new HashMap<String, T>();
    private volatile boolean _isRefreshing = false;

    public synchronized <S extends T> S get(String id) {
        T value;
        while ((value = this._valueById.get(id)) == null && this._isRefreshing) {
            try {
                this.wait();
            }
            catch (Exception e) {
                throw Exceptions.getRuntimeException(e);
            }
        }
        return (S)value;
    }

    public synchronized <S extends T> void add(String id, S val) {
        if (this._valueById.put(id, val) == null && this._isRefreshing) {
            this.notifyAll();
        }
    }

    public synchronized void beginRefresh() {
        if (this._isRefreshing) {
            throw new IllegalStateException("Already running.");
        }
        this._isRefreshing = true;
    }

    public synchronized void endRefresh() {
        if (!this._isRefreshing) {
            throw new IllegalStateException("Not running.");
        }
        this._isRefreshing = false;
        this.notifyAll();
    }

    public boolean getIsRefreshing() {
        return this._isRefreshing;
    }
}

