/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes.utils;

import com.vmware.srm.client.topology.impl.view.availability.ExtensionServerImpl;
import com.vmware.srm.client.topology.impl.view.availability.PairSetupImpl;
import java.util.concurrent.atomic.AtomicInteger;

public class PairSetupPublisher<T extends PairSetupImpl<?>> {
    private final ExtensionServerImpl<?, ?, ?, T> _extServer;
    private final AtomicInteger _unpublished;

    public PairSetupPublisher(ExtensionServerImpl<?, ?, ?, T> extServer, int count) {
        this._extServer = extServer;
        this._unpublished = new AtomicInteger(count);
        if (count == 0) {
            this._extServer.complete();
        }
    }

    public void complete(Exception err) {
        this._extServer.complete(err);
    }

    public void complete(T pair) {
        if (pair == null) {
            throw new IllegalArgumentException("pair");
        }
        int unpublished = this._unpublished.decrementAndGet();
        if (unpublished < 0) {
            throw new IllegalStateException("Too many publishers.");
        }
        this._extServer.add(pair);
        if (unpublished == 0) {
            this._extServer.complete();
        }
    }
}

