/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.sso;

import com.vmware.srm.client.topology.impl.utils.Exceptions;
import com.vmware.srm.client.topology.impl.utils.L10N;
import com.vmware.srm.client.topology.impl.utils.RefreshManager;
import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.SsoException;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;

public class TokenManager
extends RefreshManager<SecurityTokenService, SamlToken> {
    private static final long DEFAULT_EXP_TIME = 28800L;
    private static final long DEFAULT_MIN_EXP_TIME = 600L;
    private static final long DELEGATED_TOKEN_LIFETIME = 3600L;
    private final long _defaultExpireTime;

    public static TokenSpec createSpec(long tokenLifetime) {
        TokenSpec.Builder builder = new TokenSpec.Builder(tokenLifetime);
        builder.delegationSpec(new TokenSpec.DelegationSpec(true));
        builder.renewable(true);
        return builder.createTokenSpec();
    }

    public static TokenSpec createSpec(long tokenLifetime, SamlToken actAsToken) {
        TokenSpec.Builder builder = new TokenSpec.Builder(tokenLifetime);
        builder.delegationSpec(new TokenSpec.DelegationSpec(actAsToken, true));
        builder.renewable(true);
        return builder.createTokenSpec();
    }

    public static long getTokenLifetimeSecs(SamlToken t) {
        Date startDate = t.getStartTime();
        Date expirationDate = t.getExpirationTime();
        long tokenLifetimeMillis = expirationDate.getTime() - startDate.getTime();
        return TimeUnit.MILLISECONDS.toSeconds(tokenLifetimeMillis);
    }

    public static SamlToken acquireDelegatedToken(SecurityTokenService sts, SamlToken token, String delegateTo) throws SsoException {
        Validate.notNull((Object)sts, (String)"sts");
        Validate.notNull((Object)token, (String)"token");
        Validate.notEmpty((String)delegateTo, (String)"delegateTo");
        TokenSpec.Builder builder = new TokenSpec.Builder(3600L).renewable(true);
        builder.delegationSpec(new TokenSpec.DelegationSpec(true, delegateTo));
        return sts.acquireTokenByToken(token, builder.createTokenSpec());
    }

    public static SamlToken acquireBearerToken(SecurityTokenService sts, SamlToken hokToken) throws SsoException {
        Validate.notNull((Object)sts, (String)"sts");
        Validate.notNull((Object)hokToken, (String)"token");
        Validate.isTrue((hokToken.getConfirmationType() == ConfirmationType.HOLDER_OF_KEY ? 1 : 0) != 0);
        TokenSpec.Builder builder = new TokenSpec.Builder(3600L).confirmation(TokenSpec.Confirmation.NONE).delegationSpec(new TokenSpec.DelegationSpec(true)).renewable(true);
        return sts.acquireTokenByToken(hokToken, builder.createTokenSpec());
    }

    public TokenManager() {
        super(600L);
        this._defaultExpireTime = 28800L;
    }

    @Override
    protected void onRequestExists(CompletableFuture<SamlToken> result) {
        result.completeExceptionally(new TokenRequestExists());
    }

    @Override
    protected void refreshProduct(SecurityTokenService sts, SamlToken currentProduct, CompletableFuture<SamlToken> newProductFuture) {
        try {
            SamlToken newToken = sts.renewToken(currentProduct, TokenManager.getTokenLifetimeSecs(currentProduct));
            newProductFuture.complete(newToken);
        }
        catch (SsoException e) {
            newProductFuture.completeExceptionally(e);
        }
    }

    @Override
    protected Date getExpirationTime(SamlToken samlToken) {
        return samlToken.getExpirationTime();
    }

    public SamlToken acquireToken(SecurityTokenService sts, String user, String password) throws SsoException, TokenRequestExists {
        CompletableFuture<SamlToken> tokenFuture = this.getProduct(sts, (client, future) -> {
            try {
                SamlToken token = client.acquireToken(user, password, TokenManager.createSpec(this._defaultExpireTime));
                future.complete(token);
            }
            catch (SsoException e) {
                future.completeExceptionally(e);
            }
        });
        return this.getToken(tokenFuture);
    }

    public SamlToken acquireTokenByCertificate(SecurityTokenService sts) throws SsoException, TokenRequestExists {
        CompletableFuture<SamlToken> tokenFuture = this.getProduct(sts, (client, future) -> {
            try {
                SamlToken token = client.acquireTokenByCertificate(TokenManager.createSpec(this._defaultExpireTime));
                future.complete(token);
            }
            catch (SsoException e) {
                future.completeExceptionally(e);
            }
        });
        return this.getToken(tokenFuture);
    }

    public SamlToken acquireImpersonatingToken(SecurityTokenService sts, SamlToken suToken, SamlToken actAsToken) throws SsoException, TokenRequestExists {
        CompletableFuture<SamlToken> tokenFuture = this.getProduct(sts, (client, future) -> {
            try {
                SamlToken token = client.acquireTokenByToken(suToken, TokenManager.createSpec(this._defaultExpireTime, actAsToken));
                token = client.renewToken(token, this._defaultExpireTime);
                future.complete(token);
            }
            catch (SsoException e) {
                future.completeExceptionally(e);
            }
        });
        return this.getToken(tokenFuture);
    }

    public SamlToken acquireDelegatedToken(SecurityTokenService sts, String delegateTo) throws SsoException {
        SamlToken token = this.getCurrentTokenFor(sts);
        if (token == null) {
            throw new RuntimeException(L10N.localize("tokenManager.noTokenAvailable", new Object[0]));
        }
        return TokenManager.acquireDelegatedToken(sts, token, delegateTo);
    }

    public SamlToken acquireBearerToken(SecurityTokenService sts) throws SsoException {
        SamlToken token = this.getCurrentTokenFor(sts);
        if (token == null) {
            throw new RuntimeException(L10N.localize("tokenManager.noTokenAvailable", new Object[0]));
        }
        return TokenManager.acquireBearerToken(sts, token);
    }

    public void releaseToken(SecurityTokenService sts) {
        this.releaseClient(sts);
    }

    public SamlToken getCurrentTokenFor(SecurityTokenService sts) {
        CompletableFuture<SamlToken> future = this.getCurrentRequestFor(sts);
        if (future == null || future.isCompletedExceptionally()) {
            return null;
        }
        try {
            return this.getToken(future);
        }
        catch (Exception exc) {
            return null;
        }
    }

    private SamlToken getToken(CompletableFuture<SamlToken> tokenFuture) throws SsoException {
        try {
            return tokenFuture.join();
        }
        catch (CompletionException ce) {
            Throwable cause = ce.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof SsoException) {
                throw (SsoException)cause;
            }
            if (cause instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Exceptions.getRuntimeException(cause);
        }
    }

    public static class TokenRequestExists
    extends RuntimeException {
        private static final long serialVersionUID = 4659085900698244169L;

        public TokenRequestExists() {
            super(L10N.localize("tokenManager.requestExists", new Object[0]));
        }
    }
}

