/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.utils;

import com.vmware.srm.client.topology.client.Topology;
import java.util.Arrays;

public class Exceptions {
    public static RuntimeException getRuntimeException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof Exception) {
            return Exceptions.fixStackTrace(new Topology.TopologyException((Exception)e));
        }
        RuntimeException wrapper = new RuntimeException(e.getLocalizedMessage(), e);
        Topology.TopologyException te = new Topology.TopologyException(Exceptions.fixStackTrace(wrapper));
        te.setStackTrace(wrapper.getStackTrace());
        return te;
    }

    public static <E extends RuntimeException> E fixStackTrace(E e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        int length = stackTrace.length;
        if (length > 0) {
            StackTraceElement[] newTrace = Arrays.copyOfRange(stackTrace, 1, length);
            e.setStackTrace(newTrace);
        }
        return e;
    }
}

