/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.PromiseResult;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.impl.utils.L10N;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.net.URI;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;

public interface TokenProvider {
    default public Promise<Boolean> isLoggedIn() {
        return this.getToken().materialize().thenApply(PromiseResult::isSuccessful);
    }

    public Promise<SamlToken> getToken();

    default public Promise<SamlToken> loginWith(String username, String password) {
        return Promises.reject((Exception)new UnsupportedOperationException("login"));
    }

    default public Promise<SamlToken> loginWith(SamlToken suToken, SamlToken actAsToken) {
        return Promises.reject((Exception)new UnsupportedOperationException("login"));
    }

    default public Promise<SamlToken> loginWith(X509Certificate certificate, PrivateKey key) {
        return Promises.reject((Exception)new UnsupportedOperationException("login"));
    }

    default public Promise<SamlToken> loginWith(SamlToken bearerToken, RefreshData refreshData) {
        return Promises.reject((Exception)new UnsupportedOperationException());
    }

    default public Promise<SamlToken> acquireDelegatedToken(String delegateTo) {
        return Promises.reject((Exception)new UnsupportedOperationException());
    }

    default public Promise<SamlToken> acquireBearerToken() {
        return Promises.reject((Exception)new UnsupportedOperationException());
    }

    public <T extends ManagedObject> Promise<T> createLoginStub(T var1);

    public Promise<ExecutionContext.SecurityContext> createSecurityContext();

    public static interface RefreshData {
        public URI getUrl();

        public ThumbprintVerifier getVerifier();

        public KeyStore getTrustStore();

        public Date getGetExpiresAt();

        public String getRefreshToken();
    }

    public static class InvalidCredentialsException
    extends AcquireTokenFailed {
        private static final long serialVersionUID = -532589343408308674L;

        public InvalidCredentialsException(Throwable cause) {
            super(L10N.localize("tokenProvider.invalidCreds", new Object[0]), cause);
        }
    }

    public static class TokenExists
    extends Topology.TopologyException {
        private static final long serialVersionUID = -1566643920555789484L;

        public TokenExists(URI url) {
            super(L10N.localize("tokenProvider.tokenExists", url));
        }
    }

    public static class AcquireTokenFailed
    extends Topology.TopologyException {
        private static final long serialVersionUID = -8667341029510876027L;

        public AcquireTokenFailed(URI url, Throwable cause) {
            this(L10N.localize("tokenProvider.acquireFailed", url), cause);
        }

        public AcquireTokenFailed(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class AuthenticationTokenNotAvailable
    extends Topology.TopologyException {
        private static final long serialVersionUID = -7241424952567416689L;

        public AuthenticationTokenNotAvailable(URI url) {
            super(L10N.localize("tokenProvider.tokenUnavail", url));
        }
    }
}

