/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.updates;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Publisher;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.Subscriber;
import com.vmware.dr.ui.tools.reactive.Subscription;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.StreamImpl;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.availability.PcUpdatesService;
import com.vmware.srm.client.topology.client.vmomi.updates.FilterUpdatesHandler;
import com.vmware.srm.client.topology.client.vmomi.updates.PcUpdateResult;
import com.vmware.srm.client.topology.client.vmomi.updates.UpdatesManager;
import com.vmware.srm.client.topology.impl.utils.IndexUtils;
import com.vmware.srm.client.topology.impl.utils.Utils;
import com.vmware.srm.client.topology.impl.vmomi.updates.FilterManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.Future;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatesManagerImpl
implements UpdatesManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdatesManagerImpl.class);
    private final int MAX_WFU_SECS = 20;
    private final PropertyCollector.WaitOptions _waitOptions;
    private final AtomicBoolean _disposed;
    private final PcUpdatesService<?, ?> _service;
    private FilterManager _filterManager;
    private PropertyCollector _propertyCollector;
    private final Set<UpdatesStream> _filters;

    private synchronized Promise<FilterManager> getFilterManager() {
        return this._filterManager != null && this._propertyCollector != null ? Promises.resolve((Object)this._filterManager) : this.createFilterManager();
    }

    public UpdatesManagerImpl(PcUpdatesService<?, ?> service, int maxObjectUpdates, int maxWaitSeconds) {
        Validate.notNull(service, (String)"service");
        Validate.isTrue((maxObjectUpdates > 0 ? 1 : 0) != 0, (String)"maxObjectUpdates must be > 0.");
        Validate.isTrue((maxWaitSeconds > 0 ? 1 : 0) != 0, (String)"maxWaitSeconds must be > 0.");
        this._service = service;
        this._waitOptions = new PropertyCollector.WaitOptions();
        this._waitOptions.maxObjectUpdates = maxObjectUpdates;
        this._waitOptions.maxWaitSeconds = Math.min(maxWaitSeconds, 20);
        this._filters = new HashSet<UpdatesStream>();
        this._disposed = new AtomicBoolean();
    }

    @Override
    public Stream<PcUpdateResult> createUpdatesStream(PropertyCollector.FilterSpec filterSpec, boolean partialUpdates) {
        if (this._disposed.get()) {
            LOGGER.warn("createUpdatesStream: Trying to use disposed UpdatesManager!");
            return Streams.empty();
        }
        Validate.notNull((Object)filterSpec, (String)"filterSpec can not be null!");
        Validate.notEmpty((Object[])filterSpec.objectSet, (String)"objectSet can not be null or empty!");
        Map<String, List<PropertyCollector.ObjectSpec>> serverToObjSpecs = IndexUtils.indexBy(Arrays.asList(filterSpec.objectSet), value -> value.obj.getServerGuid());
        Validate.isTrue((serverToObjSpecs.size() == 1 ? 1 : 0) != 0, (String)"FilterSpec contains moRefs from more than 1 server!");
        return new UpdatesStream(filterSpec, partialUpdates);
    }

    private synchronized void removeFilter(UpdatesStream updatesStream) {
        this._filters.remove(updatesStream);
        if (this._filterManager != null) {
            this._filterManager.removeFilter(updatesStream);
        }
    }

    public void dispose() {
        LOGGER.info("Dispose called for UpdatesManager for server {}.", (Object)this._service.getServerUrl());
        if (this._disposed.compareAndSet(false, true)) {
            this._filters.clear();
            if (this._filterManager != null) {
                this._filterManager.dispose();
                this._filterManager = null;
            }
            if (this._propertyCollector != null) {
                this._propertyCollector.destroy((Future)new FuturePromise());
                this._propertyCollector = null;
            }
        }
    }

    private Promise<FilterManager> createFilterManager() {
        return Utils.getPropertyCollectorForService(this._service).thenCompose(pcRef -> {
            FuturePromise pcPromise = new FuturePromise();
            ((PropertyCollector)this._service.createStub((ManagedObjectReference)pcRef)).createPropertyCollector((Future)pcPromise);
            return pcPromise;
        }).thenApply(newPcMoRef -> {
            PropertyCollector newPc = (PropertyCollector)this._service.createStub((ManagedObjectReference)newPcMoRef);
            LOGGER.info("Created PropertyCollector for server {}: {}.", (Object)this._service.getServerUrl(), (Object)newPc);
            if (this._disposed.get()) {
                throw new IllegalStateException("UpdatesManager for server " + this._service.getServerUrl() + " is disposed.");
            }
            UpdatesManagerImpl updatesManagerImpl = this;
            synchronized (updatesManagerImpl) {
                if (this._propertyCollector == null) {
                    this._propertyCollector = newPc;
                    if (this._filterManager != null) {
                        LOGGER.warn("Illegal state - FilterManager (for PC {}) and PropertyCollector are not in sync!", (Object)this._filterManager.getPropertyCollector());
                    }
                    this._filterManager = new FilterManager(newPc, this._service, this::handleMONF, this._waitOptions);
                    LOGGER.info("Created FilterManager for PC {}.", (Object)newPc);
                }
            }
            return this._filterManager;
        }).onError(error -> LOGGER.error("Failed to create PropertyCollector for server {}: {}.", (Object)this._service.getServerUrl(), (Object)error.getMessage()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMONF(ManagedObjectNotFound monf) {
        LOGGER.info("MONF thrown for {}.", (Object)monf.getObj());
        UpdatesManagerImpl updatesManagerImpl = this;
        synchronized (updatesManagerImpl) {
            if (this._propertyCollector != null && this._propertyCollector._getRef().equals((Object)monf.getObj())) {
                LOGGER.info("MONF thrown for the current PC. PC reset.");
                this._propertyCollector = null;
                if (this._filterManager != null) {
                    this._filterManager.dispose();
                    this._filterManager = null;
                }
                LOGGER.info("Recreating {} filters.", (Object)this._filters.size());
                this._filters.forEach(rec$ -> ((UpdatesStream)rec$).createFilter());
            }
        }
    }

    class UpdatesStream
    extends StreamImpl<PcUpdateResult>
    implements FilterUpdatesHandler {
        final UpdatesStream _this = this;
        final PropertyCollector.FilterSpec _filterSpec;
        final boolean _partialUpdates;
        Subscriber<? super PcUpdateResult> _subscriber;
        private final AtomicBoolean _isSubscribed;
        private volatile boolean _markForDelete;

        private UpdatesStream(PropertyCollector.FilterSpec spec, boolean partialUpdates) {
            this._filterSpec = spec;
            this._partialUpdates = partialUpdates;
            this._isSubscribed = new AtomicBoolean(false);
            this._markForDelete = false;
        }

        public Subscription<PcUpdateResult> subscribe(final Subscriber<? super PcUpdateResult> subscriber) {
            if (!this._isSubscribed.compareAndSet(false, true)) {
                LOGGER.error("Incorrect usage of UpdatesStream - the stream is already subscribed!");
                subscriber.onError((Exception)new RuntimeException("Incorrect usage of UpdatesStream - the stream is already subscribed!"));
                return new Subscription<PcUpdateResult>(){

                    public Publisher<PcUpdateResult> getPublisher() {
                        return UpdatesStream.this._this;
                    }

                    public Subscriber<? super PcUpdateResult> getSubscriber() {
                        return subscriber;
                    }

                    public void cancel() {
                    }
                };
            }
            this._subscriber = subscriber;
            final Subscription subscription = super.subscribe(subscriber);
            this.createFilter();
            return new Subscription<PcUpdateResult>(){

                public Publisher<PcUpdateResult> getPublisher() {
                    return UpdatesStream.this._this;
                }

                public Subscriber<? super PcUpdateResult> getSubscriber() {
                    return subscriber;
                }

                public void cancel() {
                    LOGGER.info("Cancel subscription for {}.", (Object)UpdatesStream.this._this);
                    if (UpdatesManagerImpl.this._disposed.get()) {
                        LOGGER.info("UpdatesManager is disposed. Ignoring cancel request.");
                        return;
                    }
                    subscription.cancel();
                    UpdatesStream.this._markForDelete = true;
                    UpdatesManagerImpl.this.removeFilter(UpdatesStream.this._this);
                }
            };
        }

        @Override
        public PropertyCollector.FilterSpec getSpec() {
            return this._filterSpec;
        }

        @Override
        public boolean isPartialUpdates() {
            return this._partialUpdates;
        }

        @Override
        public void handleUpdate(PcUpdateResult updates) {
            if (this._markForDelete) {
                LOGGER.info("Stream {} is marked for deletion. Ignoring updates.", (Object)this._this);
                return;
            }
            this.publishNext(updates);
        }

        @Override
        public void handleError(Exception error) {
            LOGGER.trace("handleError called for {}: {}.", (Object)this, (Object)error.getMessage());
            if (this._markForDelete) {
                LOGGER.info("Stream {} is marked for deletion. Ignoring error.", (Object)this._this);
                return;
            }
            if (error instanceof ManagedObjectNotFound) {
                UpdatesManagerImpl.this.handleMONF((ManagedObjectNotFound)error);
            } else {
                this.publishError(error);
            }
        }

        private void createFilter() {
            UpdatesManagerImpl.this.getFilterManager().onSuccess(filterManager -> {
                LOGGER.info("CreateFilter on {}.", (Object)filterManager.getPropertyCollector());
                UpdatesManagerImpl updatesManagerImpl = UpdatesManagerImpl.this;
                synchronized (updatesManagerImpl) {
                    UpdatesManagerImpl.this._filters.add(this);
                }
                if (filterManager != UpdatesManagerImpl.this._filterManager) {
                    LOGGER.info("FilterManager has changed. Getting the new one!");
                    this.createFilter();
                    return;
                }
                filterManager.addFilter(this);
            }).onError(error -> {
                LOGGER.error("CreateFilter failed for {}: {}.", (Object)this, (Object)error.getMessage());
                this._subscriber.onError(error);
            });
        }

        @Override
        public boolean isMarkForDelete() {
            return this._markForDelete;
        }
    }
}

