/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.ExecuteOnceOpWrapper;
import com.vmware.dr.ui.tools.utilities.OperationWaiter;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

abstract class LoginHelper {
    private final AtomicReference<ExecuteOnceOpWrapper<Promise<Long>>> _loginOp = new AtomicReference();
    private final AtomicLong _currentLoginStamp = new AtomicLong(0L);

    LoginHelper() {
    }

    final long getCurrentStamp() {
        return this._currentLoginStamp.get();
    }

    Promise<Void> retryLogin(long loginStamp) {
        if (loginStamp > this._currentLoginStamp.get()) {
            return Promises.reject((Exception)new IllegalArgumentException("loginStamp"));
        }
        return this.doRetry(loginStamp);
    }

    abstract Promise<Void> login();

    private Promise<Void> loginInternal() {
        try {
            return this.login();
        }
        catch (Exception exc) {
            return Promises.reject((Exception)exc);
        }
    }

    private Promise<Void> doRetry(long loginStamp) {
        ExecuteOnceOpWrapper<Promise<Long>> myLoginOp = this.createLoginOp(loginStamp);
        while (loginStamp == this._currentLoginStamp.get()) {
            if (this._loginOp.compareAndSet(null, myLoginOp)) {
                OperationWaiter opWaiter = myLoginOp.invoke();
                Exception exc = opWaiter.getError();
                if (exc != null) {
                    return Promises.reject((Exception)exc);
                }
                return ((Promise)opWaiter.get()).thenApply(unused -> null);
            }
            ExecuteOnceOpWrapper<Promise<Long>> otherLoginOp = this._loginOp.get();
            if (otherLoginOp == null) continue;
            OperationWaiter opWaiter = otherLoginOp.invoke();
            Exception exc = opWaiter.getError();
            if (exc != null) {
                return Promises.reject((Exception)exc);
            }
            return ((Promise)opWaiter.get()).thenCompose(otherStamp -> {
                if (otherStamp == loginStamp) {
                    return this.doRetry(loginStamp);
                }
                return Promises.resolve(null);
            });
        }
        return Promises.resolve(null);
    }

    private ExecuteOnceOpWrapper<Promise<Long>> createLoginOp(long loginStamp) {
        return new ExecuteOnceOpWrapper(() -> {
            long current = this._currentLoginStamp.get();
            if (current == loginStamp) {
                return this.loginInternal().thenApply(unused -> {
                    long result = this._currentLoginStamp.incrementAndGet();
                    this._loginOp.set(null);
                    return result;
                }).onError(exc -> this._loginOp.set(null));
            }
            this._loginOp.set(null);
            return Promises.resolve((Object)current);
        });
    }
}

