/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.lookup;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.lookup.fault.EntryExistsFault;
import com.vmware.vim.binding.lookup.fault.EntryNotFoundFault;
import com.vmware.vim.binding.lookup.version.version2;
import com.vmware.vim.binding.lookup.version.version3_0;
import com.vmware.vim.binding.lookup.version.version4_0;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;
import java.net.URI;

@fullyQualifiedVmodlName(value="lookup.ServiceRegistration")
@managed
@versionClass(value=version2.class)
@wsdlName(value="LookupServiceRegistration")
public interface ServiceRegistration
extends ManagedObject {
    @versionClass(value=version2.class)
    @wsdlName(value="Create")
    @privilege(value="LookupService.Owner")
    @faults(value={"LookupFaultEntryExistsFault", "InvalidArgument", "SecurityError"})
    public void create(@name(value="serviceId") @versionClass(value=version2.class) String var1, @name(value="createSpec") @versionClass(value=version2.class) CreateSpec var2, Future<Void> var3);

    @wsdlName(value="Create")
    public void create(String var1, CreateSpec var2) throws EntryExistsFault, InvalidArgument, SecurityError;

    @versionClass(value=version2.class)
    @wsdlName(value="Delete")
    @privilege(value="LookupService.Owner")
    @faults(value={"LookupFaultEntryNotFoundFault", "SecurityError"})
    public void delete(@name(value="serviceId") @versionClass(value=version2.class) String var1, Future<Void> var2);

    @wsdlName(value="Delete")
    public void delete(String var1) throws EntryNotFoundFault, SecurityError;

    @versionClass(value=version2.class)
    @wsdlName(value="Set")
    @privilege(value="LookupService.Owner")
    @faults(value={"LookupFaultEntryNotFoundFault", "InvalidArgument", "SecurityError"})
    public void set(@name(value="serviceId") @versionClass(value=version2.class) String var1, @name(value="serviceSpec") @versionClass(value=version2.class) SetSpec var2, Future<Void> var3);

    @wsdlName(value="Set")
    public void set(String var1, SetSpec var2) throws EntryNotFoundFault, InvalidArgument, SecurityError;

    @versionClass(value=version3_0.class)
    @wsdlName(value="SetTrustAnchor")
    @privilege(value="LookupService.Owner")
    @faults(value={"InvalidArgument", "SecurityError"})
    public void setTrustAnchor(@name(value="filter") @versionClass(value=version3_0.class) Filter var1, @name(value="trustAnchors") @versionClass(value=version3_0.class) @map String[] var2, @optional Future<Integer> var3);

    @wsdlName(value="SetTrustAnchor")
    @optional
    public Integer setTrustAnchor(Filter var1, String[] var2) throws InvalidArgument, SecurityError;

    @versionClass(value=version2.class)
    @wsdlName(value="Get")
    @privilege(value="System.Anonymous")
    @faults(value={"LookupFaultEntryNotFoundFault"})
    public void get(@name(value="serviceId") @versionClass(value=version2.class) String var1, Future<Info> var2);

    @wsdlName(value="Get")
    public Info get(String var1) throws EntryNotFoundFault;

    @versionClass(value=version2.class)
    @wsdlName(value="List")
    @privilege(value="System.Anonymous")
    @list
    public void list(@name(value="filterCriteria") @versionClass(value=version2.class) @optional Filter var1, @optional @list Future<Info[]> var2);

    @wsdlName(value="List")
    @optional
    public Info[] list(Filter var1);

    @versionClass(value=version2.class)
    @wsdlName(value="GetSiteId")
    @privilege(value="System.Anonymous")
    public void getSiteId(Future<String> var1);

    @wsdlName(value="GetSiteId")
    public String getSiteId();

    @versionClass(value=version2.class)
    @wsdlName(value="LookupServiceRegistrationFilter")
    @data
    @propertyOrder(value={"siteId", "nodeId", "serviceType", "endpointType", "endpointTrustAnchor", "searchAllSsoDomains"})
    public static class Filter
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String siteId;
        public String nodeId;
        public ServiceType serviceType;
        public EndpointType endpointType;
        public String endpointTrustAnchor;
        public Boolean searchAllSsoDomains;

        public Filter() {
        }

        public Filter(String siteId, String nodeId, ServiceType serviceType, EndpointType endpointType, String endpointTrustAnchor, Boolean searchAllSsoDomains) {
            this.siteId = siteId;
            this.nodeId = nodeId;
            this.serviceType = serviceType;
            this.endpointType = endpointType;
            this.endpointTrustAnchor = endpointTrustAnchor;
            this.searchAllSsoDomains = searchAllSsoDomains;
        }

        public Filter(String siteId, String nodeId, ServiceType serviceType, EndpointType endpointType) {
            this.siteId = siteId;
            this.nodeId = nodeId;
            this.serviceType = serviceType;
            this.endpointType = endpointType;
        }

        public Filter(String siteId, String nodeId, ServiceType serviceType, EndpointType endpointType, String endpointTrustAnchor) {
            this.siteId = siteId;
            this.nodeId = nodeId;
            this.serviceType = serviceType;
            this.endpointType = endpointType;
            this.endpointTrustAnchor = endpointTrustAnchor;
        }

        @optional
        @versionClass(value=version2.class)
        public String getSiteId() {
            return this.siteId;
        }

        @optional
        @versionClass(value=version2.class)
        public void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @optional
        @versionClass(value=version2.class)
        public String getNodeId() {
            return this.nodeId;
        }

        @optional
        @versionClass(value=version2.class)
        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @optional
        @versionClass(value=version2.class)
        public ServiceType getServiceType() {
            return this.serviceType;
        }

        @optional
        @versionClass(value=version2.class)
        public void setServiceType(ServiceType serviceType) {
            this.serviceType = serviceType;
        }

        @optional
        @versionClass(value=version2.class)
        public EndpointType getEndpointType() {
            return this.endpointType;
        }

        @optional
        @versionClass(value=version2.class)
        public void setEndpointType(EndpointType endpointType) {
            this.endpointType = endpointType;
        }

        @optional
        @versionClass(value=version3_0.class)
        public String getEndpointTrustAnchor() {
            return this.endpointTrustAnchor;
        }

        @optional
        @versionClass(value=version3_0.class)
        public void setEndpointTrustAnchor(String endpointTrustAnchor) {
            this.endpointTrustAnchor = endpointTrustAnchor;
        }

        @optional
        @versionClass(value=version4_0.class)
        @Deprecated
        public Boolean isSearchAllSsoDomains() {
            return this.searchAllSsoDomains;
        }

        @optional
        @versionClass(value=version4_0.class)
        public Boolean getSearchAllSsoDomains() {
            return this.searchAllSsoDomains;
        }

        @optional
        @versionClass(value=version4_0.class)
        public void setSearchAllSsoDomains(Boolean searchAllSsoDomains) {
            this.searchAllSsoDomains = searchAllSsoDomains;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(320);
            objString.append("(lookup.Filter) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("siteId = ");
            objString.append(this.getSiteId());
            objString.append(",\n");
            objString.append("   ");
            objString.append("nodeId = ");
            objString.append(this.getNodeId());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceType = ");
            if (this.getServiceType() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getServiceType())), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("endpointType = ");
            if (this.getEndpointType() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getEndpointType())), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("endpointTrustAnchor = ");
            objString.append(this.getEndpointTrustAnchor());
            objString.append(",\n");
            objString.append("   ");
            objString.append("searchAllSsoDomains = ");
            objString.append(this.isSearchAllSsoDomains());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LookupServiceRegistrationAttribute")
    @data
    @propertyOrder(value={"key", "value"})
    public static class Attribute
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String key;
        public String value;

        public Attribute() {
        }

        public Attribute(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @versionClass(value=version2.class)
        public String getKey() {
            return this.key;
        }

        @versionClass(value=version2.class)
        public void setKey(String key) {
            this.key = key;
        }

        @versionClass(value=version2.class)
        public String getValue() {
            return this.value;
        }

        @versionClass(value=version2.class)
        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(160);
            objString.append("(lookup.Attribute) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("key = ");
            objString.append(this.getKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("value = ");
            objString.append(this.getValue());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LookupServiceRegistrationEndpointType")
    @data
    @propertyOrder(value={"protocol", "type"})
    public static class EndpointType
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String protocol;
        public String type;

        public EndpointType() {
        }

        public EndpointType(String protocol, String type) {
            this.protocol = protocol;
            this.type = type;
        }

        @optional
        @versionClass(value=version2.class)
        public String getProtocol() {
            return this.protocol;
        }

        @optional
        @versionClass(value=version2.class)
        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @optional
        @versionClass(value=version2.class)
        public String getType() {
            return this.type;
        }

        @optional
        @versionClass(value=version2.class)
        public void setType(String type) {
            this.type = type;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(160);
            objString.append("(lookup.EndpointType) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("protocol = ");
            objString.append(this.getProtocol());
            objString.append(",\n");
            objString.append("   ");
            objString.append("type = ");
            objString.append(this.getType());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LookupServiceRegistrationEndpoint")
    @data
    @propertyOrder(value={"url", "endpointType", "sslTrust", "endpointAttributes"})
    public static class Endpoint
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public URI url;
        public EndpointType endpointType;
        public String[] sslTrust;
        public Attribute[] endpointAttributes;

        public Endpoint() {
        }

        public Endpoint(URI url, EndpointType endpointType, String[] sslTrust, Attribute[] endpointAttributes) {
            this.url = url;
            this.endpointType = endpointType;
            this.sslTrust = sslTrust;
            this.endpointAttributes = endpointAttributes;
        }

        @versionClass(value=version2.class)
        public URI getUrl() {
            return this.url;
        }

        @versionClass(value=version2.class)
        public void setUrl(URI url) {
            this.url = url;
        }

        @versionClass(value=version2.class)
        public EndpointType getEndpointType() {
            return this.endpointType;
        }

        @versionClass(value=version2.class)
        public void setEndpointType(EndpointType endpointType) {
            this.endpointType = endpointType;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        public String[] getSslTrust() {
            return this.sslTrust;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        public void setSslTrust(String[] sslTrust) {
            this.sslTrust = sslTrust;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        public Attribute[] getEndpointAttributes() {
            return this.endpointAttributes;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        public void setEndpointAttributes(Attribute[] endpointAttributes) {
            this.endpointAttributes = endpointAttributes;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(240);
            objString.append("(lookup.Endpoint) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("url = ");
            objString.append(this.getUrl());
            objString.append(",\n");
            objString.append("   ");
            objString.append("endpointType = ");
            if (this.getEndpointType() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getEndpointType())), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("sslTrust = ");
            if (this.getSslTrust() == null) {
                objString.append("null");
            } else {
                objString.append("(STRING) [\n");
                for (i = 0; i < this.getSslTrust().length; ++i) {
                    objString.append("      ");
                    objString.append(this.getSslTrust()[i]);
                    if (i < this.getSslTrust().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("endpointAttributes = ");
            if (this.getEndpointAttributes() == null) {
                objString.append("null");
            } else {
                objString.append("(lookup.Attribute) [\n");
                for (i = 0; i < this.getEndpointAttributes().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getEndpointAttributes()[i])), (boolean)true));
                    if (i < this.getEndpointAttributes().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LookupServiceRegistrationServiceType")
    @data
    @propertyOrder(value={"product", "type"})
    public static class ServiceType
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String product;
        public String type;

        public ServiceType() {
        }

        public ServiceType(String product, String type) {
            this.product = product;
            this.type = type;
        }

        @versionClass(value=version2.class)
        public String getProduct() {
            return this.product;
        }

        @versionClass(value=version2.class)
        public void setProduct(String product) {
            this.product = product;
        }

        @versionClass(value=version2.class)
        public String getType() {
            return this.type;
        }

        @versionClass(value=version2.class)
        public void setType(String type) {
            this.type = type;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(160);
            objString.append("(lookup.ServiceType) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("product = ");
            objString.append(this.getProduct());
            objString.append(",\n");
            objString.append("   ");
            objString.append("type = ");
            objString.append(this.getType());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LookupServiceRegistrationInfo")
    @data
    @propertyOrder(value={"serviceId", "siteId"})
    public static class Info
    extends CommonServiceInfo {
        private static final long serialVersionUID = 1L;
        public String serviceId;
        public String siteId;

        public Info() {
        }

        public Info(String serviceVersion, String vendorNameResourceKey, String vendorNameDefault, String vendorProductInfoResourceKey, String vendorProductInfoDefault, Endpoint[] serviceEndpoints, Attribute[] serviceAttributes, String serviceNameResourceKey, String serviceNameDefault, String serviceDescriptionResourceKey, String serviceDescriptionDefault, String ownerId, ServiceType serviceType, String nodeId, String serviceId, String siteId) {
            super(serviceVersion, vendorNameResourceKey, vendorNameDefault, vendorProductInfoResourceKey, vendorProductInfoDefault, serviceEndpoints, serviceAttributes, serviceNameResourceKey, serviceNameDefault, serviceDescriptionResourceKey, serviceDescriptionDefault, ownerId, serviceType, nodeId);
            this.serviceId = serviceId;
            this.siteId = siteId;
        }

        @versionClass(value=version2.class)
        public String getServiceId() {
            return this.serviceId;
        }

        @versionClass(value=version2.class)
        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @versionClass(value=version2.class)
        public String getSiteId() {
            return this.siteId;
        }

        @versionClass(value=version2.class)
        public void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(720);
            objString.append("(lookup.Info) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceVersion = ");
            objString.append(this.getServiceVersion());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorNameResourceKey = ");
            objString.append(this.getVendorNameResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorNameDefault = ");
            objString.append(this.getVendorNameDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorProductInfoResourceKey = ");
            objString.append(this.getVendorProductInfoResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorProductInfoDefault = ");
            objString.append(this.getVendorProductInfoDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceEndpoints = ");
            if (this.getServiceEndpoints() == null) {
                objString.append("null");
            } else {
                objString.append("(lookup.Endpoint) [\n");
                for (i = 0; i < this.getServiceEndpoints().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getServiceEndpoints()[i])), (boolean)true));
                    if (i < this.getServiceEndpoints().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceAttributes = ");
            if (this.getServiceAttributes() == null) {
                objString.append("null");
            } else {
                objString.append("(lookup.Attribute) [\n");
                for (i = 0; i < this.getServiceAttributes().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getServiceAttributes()[i])), (boolean)true));
                    if (i < this.getServiceAttributes().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceNameResourceKey = ");
            objString.append(this.getServiceNameResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceNameDefault = ");
            objString.append(this.getServiceNameDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceDescriptionResourceKey = ");
            objString.append(this.getServiceDescriptionResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceDescriptionDefault = ");
            objString.append(this.getServiceDescriptionDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("ownerId = ");
            objString.append(this.getOwnerId());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceType = ");
            if (this.getServiceType() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getServiceType())), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("nodeId = ");
            objString.append(this.getNodeId());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceId = ");
            objString.append(this.getServiceId());
            objString.append(",\n");
            objString.append("   ");
            objString.append("siteId = ");
            objString.append(this.getSiteId());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LookupServiceRegistrationSetSpec")
    @data
    public static class SetSpec
    extends MutableServiceInfo {
        private static final long serialVersionUID = 1L;

        public SetSpec() {
        }

        public SetSpec(String serviceVersion, String vendorNameResourceKey, String vendorNameDefault, String vendorProductInfoResourceKey, String vendorProductInfoDefault, Endpoint[] serviceEndpoints, Attribute[] serviceAttributes, String serviceNameResourceKey, String serviceNameDefault, String serviceDescriptionResourceKey, String serviceDescriptionDefault) {
            super(serviceVersion, vendorNameResourceKey, vendorNameDefault, vendorProductInfoResourceKey, vendorProductInfoDefault, serviceEndpoints, serviceAttributes, serviceNameResourceKey, serviceNameDefault, serviceDescriptionResourceKey, serviceDescriptionDefault);
        }

        @Override
        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(520);
            objString.append("(lookup.SetSpec) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceVersion = ");
            objString.append(this.getServiceVersion());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorNameResourceKey = ");
            objString.append(this.getVendorNameResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorNameDefault = ");
            objString.append(this.getVendorNameDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorProductInfoResourceKey = ");
            objString.append(this.getVendorProductInfoResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorProductInfoDefault = ");
            objString.append(this.getVendorProductInfoDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceEndpoints = ");
            if (this.getServiceEndpoints() == null) {
                objString.append("null");
            } else {
                objString.append("(lookup.Endpoint) [\n");
                for (i = 0; i < this.getServiceEndpoints().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getServiceEndpoints()[i])), (boolean)true));
                    if (i < this.getServiceEndpoints().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceAttributes = ");
            if (this.getServiceAttributes() == null) {
                objString.append("null");
            } else {
                objString.append("(lookup.Attribute) [\n");
                for (i = 0; i < this.getServiceAttributes().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getServiceAttributes()[i])), (boolean)true));
                    if (i < this.getServiceAttributes().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceNameResourceKey = ");
            objString.append(this.getServiceNameResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceNameDefault = ");
            objString.append(this.getServiceNameDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceDescriptionResourceKey = ");
            objString.append(this.getServiceDescriptionResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceDescriptionDefault = ");
            objString.append(this.getServiceDescriptionDefault());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LookupServiceRegistrationCreateSpec")
    @data
    public static class CreateSpec
    extends CommonServiceInfo {
        private static final long serialVersionUID = 1L;

        public CreateSpec() {
        }

        public CreateSpec(String serviceVersion, String vendorNameResourceKey, String vendorNameDefault, String vendorProductInfoResourceKey, String vendorProductInfoDefault, Endpoint[] serviceEndpoints, Attribute[] serviceAttributes, String serviceNameResourceKey, String serviceNameDefault, String serviceDescriptionResourceKey, String serviceDescriptionDefault, String ownerId, ServiceType serviceType, String nodeId) {
            super(serviceVersion, vendorNameResourceKey, vendorNameDefault, vendorProductInfoResourceKey, vendorProductInfoDefault, serviceEndpoints, serviceAttributes, serviceNameResourceKey, serviceNameDefault, serviceDescriptionResourceKey, serviceDescriptionDefault, ownerId, serviceType, nodeId);
        }

        @Override
        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(640);
            objString.append("(lookup.CreateSpec) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceVersion = ");
            objString.append(this.getServiceVersion());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorNameResourceKey = ");
            objString.append(this.getVendorNameResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorNameDefault = ");
            objString.append(this.getVendorNameDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorProductInfoResourceKey = ");
            objString.append(this.getVendorProductInfoResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorProductInfoDefault = ");
            objString.append(this.getVendorProductInfoDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceEndpoints = ");
            if (this.getServiceEndpoints() == null) {
                objString.append("null");
            } else {
                objString.append("(lookup.Endpoint) [\n");
                for (i = 0; i < this.getServiceEndpoints().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getServiceEndpoints()[i])), (boolean)true));
                    if (i < this.getServiceEndpoints().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceAttributes = ");
            if (this.getServiceAttributes() == null) {
                objString.append("null");
            } else {
                objString.append("(lookup.Attribute) [\n");
                for (i = 0; i < this.getServiceAttributes().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getServiceAttributes()[i])), (boolean)true));
                    if (i < this.getServiceAttributes().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceNameResourceKey = ");
            objString.append(this.getServiceNameResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceNameDefault = ");
            objString.append(this.getServiceNameDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceDescriptionResourceKey = ");
            objString.append(this.getServiceDescriptionResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceDescriptionDefault = ");
            objString.append(this.getServiceDescriptionDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("ownerId = ");
            objString.append(this.getOwnerId());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceType = ");
            if (this.getServiceType() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getServiceType())), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("nodeId = ");
            objString.append(this.getNodeId());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LookupServiceRegistrationCommonServiceInfo")
    @data
    @propertyOrder(value={"ownerId", "serviceType", "nodeId"})
    public static class CommonServiceInfo
    extends MutableServiceInfo {
        private static final long serialVersionUID = 1L;
        public String ownerId;
        public ServiceType serviceType;
        public String nodeId;

        public CommonServiceInfo() {
        }

        public CommonServiceInfo(String serviceVersion, String vendorNameResourceKey, String vendorNameDefault, String vendorProductInfoResourceKey, String vendorProductInfoDefault, Endpoint[] serviceEndpoints, Attribute[] serviceAttributes, String serviceNameResourceKey, String serviceNameDefault, String serviceDescriptionResourceKey, String serviceDescriptionDefault, String ownerId, ServiceType serviceType, String nodeId) {
            super(serviceVersion, vendorNameResourceKey, vendorNameDefault, vendorProductInfoResourceKey, vendorProductInfoDefault, serviceEndpoints, serviceAttributes, serviceNameResourceKey, serviceNameDefault, serviceDescriptionResourceKey, serviceDescriptionDefault);
            this.ownerId = ownerId;
            this.serviceType = serviceType;
            this.nodeId = nodeId;
        }

        @versionClass(value=version2.class)
        public String getOwnerId() {
            return this.ownerId;
        }

        @versionClass(value=version2.class)
        public void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @versionClass(value=version2.class)
        public ServiceType getServiceType() {
            return this.serviceType;
        }

        @versionClass(value=version2.class)
        public void setServiceType(ServiceType serviceType) {
            this.serviceType = serviceType;
        }

        @optional
        @versionClass(value=version2.class)
        public String getNodeId() {
            return this.nodeId;
        }

        @optional
        @versionClass(value=version2.class)
        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(640);
            objString.append("(lookup.CommonServiceInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceVersion = ");
            objString.append(this.getServiceVersion());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorNameResourceKey = ");
            objString.append(this.getVendorNameResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorNameDefault = ");
            objString.append(this.getVendorNameDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorProductInfoResourceKey = ");
            objString.append(this.getVendorProductInfoResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorProductInfoDefault = ");
            objString.append(this.getVendorProductInfoDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceEndpoints = ");
            if (this.getServiceEndpoints() == null) {
                objString.append("null");
            } else {
                objString.append("(lookup.Endpoint) [\n");
                for (i = 0; i < this.getServiceEndpoints().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getServiceEndpoints()[i])), (boolean)true));
                    if (i < this.getServiceEndpoints().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceAttributes = ");
            if (this.getServiceAttributes() == null) {
                objString.append("null");
            } else {
                objString.append("(lookup.Attribute) [\n");
                for (i = 0; i < this.getServiceAttributes().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getServiceAttributes()[i])), (boolean)true));
                    if (i < this.getServiceAttributes().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceNameResourceKey = ");
            objString.append(this.getServiceNameResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceNameDefault = ");
            objString.append(this.getServiceNameDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceDescriptionResourceKey = ");
            objString.append(this.getServiceDescriptionResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceDescriptionDefault = ");
            objString.append(this.getServiceDescriptionDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("ownerId = ");
            objString.append(this.getOwnerId());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceType = ");
            if (this.getServiceType() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getServiceType())), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("nodeId = ");
            objString.append(this.getNodeId());
            objString.append("\n}");
            return objString.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LookupServiceRegistrationMutableServiceInfo")
    @data
    @propertyOrder(value={"serviceVersion", "vendorNameResourceKey", "vendorNameDefault", "vendorProductInfoResourceKey", "vendorProductInfoDefault", "serviceEndpoints", "serviceAttributes", "serviceNameResourceKey", "serviceNameDefault", "serviceDescriptionResourceKey", "serviceDescriptionDefault"})
    public static class MutableServiceInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String serviceVersion;
        public String vendorNameResourceKey;
        public String vendorNameDefault;
        public String vendorProductInfoResourceKey;
        public String vendorProductInfoDefault;
        public Endpoint[] serviceEndpoints;
        public Attribute[] serviceAttributes;
        public String serviceNameResourceKey;
        public String serviceNameDefault;
        public String serviceDescriptionResourceKey;
        public String serviceDescriptionDefault;

        public MutableServiceInfo() {
        }

        public MutableServiceInfo(String serviceVersion, String vendorNameResourceKey, String vendorNameDefault, String vendorProductInfoResourceKey, String vendorProductInfoDefault, Endpoint[] serviceEndpoints, Attribute[] serviceAttributes, String serviceNameResourceKey, String serviceNameDefault, String serviceDescriptionResourceKey, String serviceDescriptionDefault) {
            this.serviceVersion = serviceVersion;
            this.vendorNameResourceKey = vendorNameResourceKey;
            this.vendorNameDefault = vendorNameDefault;
            this.vendorProductInfoResourceKey = vendorProductInfoResourceKey;
            this.vendorProductInfoDefault = vendorProductInfoDefault;
            this.serviceEndpoints = serviceEndpoints;
            this.serviceAttributes = serviceAttributes;
            this.serviceNameResourceKey = serviceNameResourceKey;
            this.serviceNameDefault = serviceNameDefault;
            this.serviceDescriptionResourceKey = serviceDescriptionResourceKey;
            this.serviceDescriptionDefault = serviceDescriptionDefault;
        }

        @versionClass(value=version2.class)
        public String getServiceVersion() {
            return this.serviceVersion;
        }

        @versionClass(value=version2.class)
        public void setServiceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
        }

        @optional
        @versionClass(value=version2.class)
        public String getVendorNameResourceKey() {
            return this.vendorNameResourceKey;
        }

        @optional
        @versionClass(value=version2.class)
        public void setVendorNameResourceKey(String vendorNameResourceKey) {
            this.vendorNameResourceKey = vendorNameResourceKey;
        }

        @optional
        @versionClass(value=version2.class)
        public String getVendorNameDefault() {
            return this.vendorNameDefault;
        }

        @optional
        @versionClass(value=version2.class)
        public void setVendorNameDefault(String vendorNameDefault) {
            this.vendorNameDefault = vendorNameDefault;
        }

        @optional
        @versionClass(value=version2.class)
        public String getVendorProductInfoResourceKey() {
            return this.vendorProductInfoResourceKey;
        }

        @optional
        @versionClass(value=version2.class)
        public void setVendorProductInfoResourceKey(String vendorProductInfoResourceKey) {
            this.vendorProductInfoResourceKey = vendorProductInfoResourceKey;
        }

        @optional
        @versionClass(value=version2.class)
        public String getVendorProductInfoDefault() {
            return this.vendorProductInfoDefault;
        }

        @optional
        @versionClass(value=version2.class)
        public void setVendorProductInfoDefault(String vendorProductInfoDefault) {
            this.vendorProductInfoDefault = vendorProductInfoDefault;
        }

        @list
        @optional
        @versionClass(value=version2.class)
        public Endpoint[] getServiceEndpoints() {
            return this.serviceEndpoints;
        }

        @list
        @optional
        @versionClass(value=version2.class)
        public void setServiceEndpoints(Endpoint[] serviceEndpoints) {
            this.serviceEndpoints = serviceEndpoints;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        public Attribute[] getServiceAttributes() {
            return this.serviceAttributes;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        public void setServiceAttributes(Attribute[] serviceAttributes) {
            this.serviceAttributes = serviceAttributes;
        }

        @optional
        @versionClass(value=version2.class)
        public String getServiceNameResourceKey() {
            return this.serviceNameResourceKey;
        }

        @optional
        @versionClass(value=version2.class)
        public void setServiceNameResourceKey(String serviceNameResourceKey) {
            this.serviceNameResourceKey = serviceNameResourceKey;
        }

        @optional
        @versionClass(value=version2.class)
        public String getServiceNameDefault() {
            return this.serviceNameDefault;
        }

        @optional
        @versionClass(value=version2.class)
        public void setServiceNameDefault(String serviceNameDefault) {
            this.serviceNameDefault = serviceNameDefault;
        }

        @optional
        @versionClass(value=version2.class)
        public String getServiceDescriptionResourceKey() {
            return this.serviceDescriptionResourceKey;
        }

        @optional
        @versionClass(value=version2.class)
        public void setServiceDescriptionResourceKey(String serviceDescriptionResourceKey) {
            this.serviceDescriptionResourceKey = serviceDescriptionResourceKey;
        }

        @optional
        @versionClass(value=version2.class)
        public String getServiceDescriptionDefault() {
            return this.serviceDescriptionDefault;
        }

        @optional
        @versionClass(value=version2.class)
        public void setServiceDescriptionDefault(String serviceDescriptionDefault) {
            this.serviceDescriptionDefault = serviceDescriptionDefault;
        }

        public String toString() {
            int i;
            StringBuilder objString = new StringBuilder(520);
            objString.append("(lookup.MutableServiceInfo) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceVersion = ");
            objString.append(this.getServiceVersion());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorNameResourceKey = ");
            objString.append(this.getVendorNameResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorNameDefault = ");
            objString.append(this.getVendorNameDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorProductInfoResourceKey = ");
            objString.append(this.getVendorProductInfoResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("vendorProductInfoDefault = ");
            objString.append(this.getVendorProductInfoDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceEndpoints = ");
            if (this.getServiceEndpoints() == null) {
                objString.append("null");
            } else {
                objString.append("(lookup.Endpoint) [\n");
                for (i = 0; i < this.getServiceEndpoints().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getServiceEndpoints()[i])), (boolean)true));
                    if (i < this.getServiceEndpoints().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceAttributes = ");
            if (this.getServiceAttributes() == null) {
                objString.append("null");
            } else {
                objString.append("(lookup.Attribute) [\n");
                for (i = 0; i < this.getServiceAttributes().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)("" + (Object)((Object)this.getServiceAttributes()[i])), (boolean)true));
                    if (i < this.getServiceAttributes().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceNameResourceKey = ");
            objString.append(this.getServiceNameResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceNameDefault = ");
            objString.append(this.getServiceNameDefault());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceDescriptionResourceKey = ");
            objString.append(this.getServiceDescriptionResourceKey());
            objString.append(",\n");
            objString.append("   ");
            objString.append("serviceDescriptionDefault = ");
            objString.append(this.getServiceDescriptionDefault());
            objString.append("\n}");
            return objString.toString();
        }
    }
}

