/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import com.sun.source.doctree.DocTree;
import com.sun.source.util.DocTreePath;
import emitters.Utils;
import emitters.doc.JavadocElements;
import emitters.doc.JavadocLinkResolver;
import emitters.doc.LinkResolver;
import emitters.model.Enum;
import emitters.model.ManagedProperty;
import emitters.model.Method;
import emitters.model.Property;
import emitters.model.VmodlApi;
import emitters.model.VmodlObject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;

abstract class OpenAPILinkResolver
implements LinkResolver,
JavadocLinkResolver {
    OpenAPILinkResolver() {
    }

    @Override
    public String getLabel(DocTreePath link, JavadocLinkResolver.LinkContext context) {
        Element e = JavadocElements.getElement(link);
        if (e == null) {
            return null;
        }
        if (e.getKind() == ElementKind.ENUM_CONSTANT) {
            return e.getSimpleName().toString();
        }
        VmodlApi vmodlElement = JavadocElements.getVmodlElement(e);
        return vmodlElement == null ? null : this.getLabel(vmodlElement, context);
    }

    @Override
    public String getDestination(DocTreePath reference, JavadocLinkResolver.LinkContext context) {
        if (reference.getLeaf().getKind() != DocTree.Kind.REFERENCE) {
            throw new IllegalArgumentException();
        }
        Element e = JavadocElements.getElement(reference);
        if (e == null) {
            return null;
        }
        return this.getDestination(e, context);
    }

    @Override
    public String getLink(VmodlApi element, JavadocLinkResolver.LinkContext context) {
        return "[" + this.getLabel(element, context) + "](" + this.getDestination(element, context) + ")";
    }

    @Override
    public boolean enabled(JavadocLinkResolver.LinkContext context) {
        return context != JavadocLinkResolver.LinkContext.DISABLED;
    }

    protected String getLabel(VmodlApi element, JavadocLinkResolver.LinkContext context) {
        String label = this.getId(element);
        if (!this.enabled(context) && (element instanceof Property || element instanceof Method)) {
            label = this.getLabel(this.getContainer(element), context) + "." + label;
        }
        return label;
    }

    public String getId(VmodlApi element) {
        if (element instanceof Property) {
            return this.getPropertyId((Property)element);
        }
        if (element instanceof Enum) {
            return this.getEnumId((Enum)element);
        }
        return this.getWireId(element);
    }

    protected String getPropertyId(Property element) {
        return element.getName();
    }

    protected String getEnumId(Enum element) {
        return this.getWireId(element) + "_enum";
    }

    protected String getWireId(VmodlApi element) {
        return element instanceof VmodlObject ? ((VmodlObject)element).getJsonName() : element.getWsdlName();
    }

    public String getOperationId(VmodlApi container, VmodlApi element) {
        if (element instanceof Method) {
            return this.getId(container) + "_" + this.getId(element);
        }
        if (element instanceof Property) {
            return this.getId(container) + "_get" + Utils.capitalize(this.getPropertyId((Property)element));
        }
        throw new IllegalArgumentException();
    }

    protected String getDestination(Element element, JavadocLinkResolver.LinkContext context) {
        VmodlApi vmodlElement = JavadocElements.getVmodlElement(element);
        if (element.getKind() == ElementKind.METHOD) {
            VmodlApi container = JavadocElements.getVmodlElement(element.getEnclosingElement());
            return this.getOperationDestination(container, vmodlElement, context);
        }
        return this.getNonOperationDestination(vmodlElement, context);
    }

    protected String getDestination(VmodlApi element, JavadocLinkResolver.LinkContext context) {
        if (element instanceof Method || element instanceof ManagedProperty) {
            return this.getOperationDestination(this.getContainer(element), element, context);
        }
        return this.getNonOperationDestination(element, context);
    }

    protected abstract String getNonOperationDestination(VmodlApi var1, JavadocLinkResolver.LinkContext var2);

    protected abstract String getOperationDestination(VmodlApi var1, VmodlApi var2, JavadocLinkResolver.LinkContext var3);

    protected VmodlObject getContainer(VmodlApi element) {
        if (element instanceof Method) {
            return ((Method)element).getContainer();
        }
        if (element instanceof Property) {
            return ((Property)element).getContainer();
        }
        throw new IllegalArgumentException();
    }

    public String getHttpMethod(VmodlApi element) {
        if (element instanceof Method) {
            return "post";
        }
        if (element instanceof Property) {
            return "get";
        }
        throw new IllegalArgumentException();
    }
}

