/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.xml;

import emitters.VmodlEmitter;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Property;
import emitters.model.VmodlObject;
import java.util.List;

public class ListInternalApiEmitter
extends VmodlEmitter {
    private final String _fileName;
    private static final String XML_DOCUMENT_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public ListInternalApiEmitter(String fileName) {
        this._fileName = fileName;
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.beginFile(this._fileName);
        this.emitLine(XML_DOCUMENT_HEADER);
        this.emitLine("<vmodlObjects>");
        this.indent();
        for (VmodlObject obj : objects) {
            this.emitObject(obj);
        }
        this.unindent();
        this.emitLine("</vmodlObjects>");
        this.endFile();
    }

    private void emitObject(VmodlObject obj) {
        switch (obj.getKind()) {
            case ManagedObject: {
                this.emitManagedObject((ManagedObject)obj);
                break;
            }
            case DataObject: {
                this.emitDataObject((DataObject)obj);
                break;
            }
            case Enum: {
                this.emitEnum((Enum)obj);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected object type");
            }
        }
        for (VmodlObject nestedObj : obj.getNestedList()) {
            this.emitObject(nestedObj);
        }
    }

    private void emitManagedObject(ManagedObject obj) {
        int methodsToEmit = 0;
        int propertiesToEmit = 0;
        for (Method meth : obj.getMethodList()) {
            if (!this.shouldEmit(meth)) continue;
            ++methodsToEmit;
            break;
        }
        for (Property property : obj.getPropertyList()) {
            if (!this.shouldEmit(property)) continue;
            ++propertiesToEmit;
            break;
        }
        if (methodsToEmit != 0 || propertiesToEmit != 0) {
            this.emitLine("<managed_object>");
            this.indent();
            this.emitLine("<name>", obj.getQualifiedVmodlType(), "</name>");
        }
        if (methodsToEmit != 0) {
            this.emitLine("<methods>");
            for (Method meth : obj.getMethodList()) {
                if (!this.shouldEmit(meth)) continue;
                this.indent();
                this.emitLine("<method>", meth.getWsdlName(), "</method>");
                this.unindent();
            }
            this.emitLine("</methods>");
        }
        if (propertiesToEmit != 0) {
            this.emitLine("<properties>");
            for (Property property : obj.getPropertyList()) {
                if (!this.shouldEmit(property)) continue;
                this.indent();
                this.emitLine("<property>", property.getWsdlName(), "</property>");
                this.unindent();
            }
            this.emitLine("</properties>");
        }
        if (methodsToEmit != 0 || propertiesToEmit != 0) {
            this.unindent();
            this.emitLine("</managed_object>");
        }
    }

    private void emitDataObject(DataObject obj) {
        int propertiestToEmit = 0;
        for (Property property : obj.getPropertyList()) {
            if (!this.shouldEmit(property)) continue;
            ++propertiestToEmit;
            break;
        }
        if (propertiestToEmit != 0) {
            this.emitLine("<data_object>");
            this.indent();
            this.emitLine("<name>", obj.getQualifiedVmodlType(), "</name>");
            this.emitLine("<properties>");
            for (Property property : obj.getPropertyList()) {
                if (!this.shouldEmit(property)) continue;
                this.indent();
                this.emitLine("<property>", property.getWsdlName(), "</property>");
                this.unindent();
            }
            this.emitLine("</properties>");
            this.unindent();
            this.emitLine("</data_object>");
        }
    }

    private void emitEnum(Enum obj) {
    }

    public boolean shouldEmit(Method meth) {
        return meth.isInternal();
    }

    public boolean shouldEmit(Property prop) {
        return prop.isInternal();
    }
}

