/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import com.sun.source.doctree.DocTree;
import com.sun.source.util.DocTreePath;
import emitters.model.Entity;
import emitters.model.SourcePos;
import emitters.model.Version;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class EntityBase
implements Entity {
    private final String _name;
    private final Version _version;
    private final String _comment;
    private final Supplier<DocTreePath> _docSupplier;
    private SourcePos _sourcePos;

    public EntityBase(String name, Version version, String comment, Supplier<DocTreePath> docSupplier) {
        this._name = name;
        this._version = version;
        this._comment = comment;
        this._docSupplier = docSupplier;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Version getVersion() {
        return this._version;
    }

    @Override
    public SourcePos getSourcePos() {
        return this._sourcePos;
    }

    @Override
    public String getComment() {
        return this._comment;
    }

    @Override
    public DocTreePath getDoc() {
        return this._docSupplier == null ? null : this._docSupplier.get();
    }

    public Supplier<DocTreePath> getDocSupplier() {
        return this._docSupplier;
    }

    public DocTreePath getReturnDoc() {
        return this.getBlockTag(t -> t.getKind() == DocTree.Kind.RETURN);
    }

    protected DocTreePath getBlockTag(Predicate<? super DocTree> filter) {
        DocTreePath doc = this.getDoc();
        if (doc == null) {
            return null;
        }
        Optional<? super DocTree> p = doc.getDocComment().getBlockTags().stream().filter(filter).findAny();
        if (!p.isPresent()) {
            return null;
        }
        return new DocTreePath(doc, p.get());
    }

    @Override
    public void setSourcePos(SourcePos sourcePos) {
        this._sourcePos = sourcePos;
    }
}

