/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.model.MetaVersion;
import emitters.model.Product;
import emitters.model.ReleaseVersions;
import emitters.model.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import vmodl.nsDescription;
import vmodl.releaseVersions;
import vmodl.releaseVersionsList;

public class Namespace {
    private final String _name;
    private final Product _product;
    private boolean _supportsViJson;
    private final Map<String, ReleaseVersions> _releaseVersions;
    private MetaVersion _metaVersion;

    public Namespace(String name, nsDescription nsDescription2, Product product) {
        this._name = name;
        this._product = product;
        this._releaseVersions = this.initReleaseVersions(nsDescription2.releases());
    }

    private Map<String, ReleaseVersions> initReleaseVersions(releaseVersionsList versionList) {
        LinkedHashSet<String> viJsonReleases2 = this._product.getViJsonReleases();
        boolean supportsViJson = false;
        LinkedHashMap<String, ReleaseVersions> rvMap = new LinkedHashMap<String, ReleaseVersions>(versionList.value().length);
        for (releaseVersions rv : versionList.value()) {
            String viJsonRelease;
            String ltsVersion;
            String id = rv.id();
            if (rv.ltsVersion().isEmpty()) {
                ltsVersion = this._name + ".version.v" + id.replace(".", "_");
                viJsonRelease = id;
            } else {
                ltsVersion = rv.ltsVersion();
                viJsonRelease = rv.viJsonRelease();
            }
            if (viJsonRelease.isEmpty()) {
                viJsonRelease = null;
            } else {
                if (!viJsonReleases2.contains(viJsonRelease)) {
                    throw new RuntimeException(String.format("Unknown VI/JSON release in '%s' namespace: (%s, %s, %s)", this._name, id, ltsVersion, viJsonRelease));
                }
                supportsViJson = true;
            }
            rvMap.put(id, new ReleaseVersions(id, ltsVersion, viJsonRelease));
        }
        this._supportsViJson = supportsViJson;
        return rvMap;
    }

    public Collection<ReleaseVersions> getReleaseVersions() {
        return this._releaseVersions.values();
    }

    public List<ReleaseVersions> getReleaseVersionsList() {
        ArrayList<ReleaseVersions> list2 = new ArrayList<ReleaseVersions>(this._releaseVersions.size());
        for (Map.Entry<String, ReleaseVersions> entry : this._releaseVersions.entrySet()) {
            list2.add(entry.getValue());
        }
        return list2;
    }

    public Map<String, ReleaseVersions> getReleaseVersionsMap() {
        return this._releaseVersions;
    }

    public Version lookupRelease(String release) {
        ReleaseVersions releaseVersions2 = this._releaseVersions.get(release);
        return releaseVersions2 != null ? releaseVersions2.ltsVersion() : null;
    }

    public Version getLtsVersion(String releaseName) {
        ReleaseVersions releaseVersions2 = this._releaseVersions.get(releaseName);
        return releaseVersions2 != null ? releaseVersions2.ltsVersion() : null;
    }

    public void setMetaVersion(MetaVersion metaVersion2) {
        assert (this._metaVersion == null);
        this._metaVersion = metaVersion2;
    }

    public MetaVersion getMetaVersion() {
        return this._metaVersion;
    }

    public String getName() {
        return this._name;
    }

    public Product getProduct() {
        return this._product;
    }

    public boolean supportsViJson() {
        return this._supportsViJson;
    }
}

