/*
 * Decompiled with CFR 0.152.
 */
package emitters.model.raw;

import emitters.Versions;
import emitters.core.SyntaxException;
import emitters.model.Namespace;
import emitters.model.Version;
import emitters.model.raw.RawElement;

public class ReleaseInNamespace {
    private final String _releaseName;
    private final String _namespace;
    private final RawElement _rawElement;

    public ReleaseInNamespace(String releaseName, String namespace, RawElement rawElement) {
        this._releaseName = releaseName;
        this._namespace = namespace;
        this._rawElement = rawElement;
    }

    Version getVersion() {
        Namespace ns = Versions.getNamespaceCaching(this._namespace);
        if (ns == null) {
            throw SyntaxException.at(this._rawElement.getSourcePos(), "Namespace %s has no @nsDescription", this._namespace);
        }
        Version version = ns.lookupRelease(this._releaseName);
        if (version == null) {
            throw SyntaxException.at(this._rawElement.getSourcePos(), "Release %s is undefined in namespace %s", this._releaseName, this._namespace);
        }
        return version;
    }
}

