/*
 * Decompiled with CFR 0.152.
 */
package emitters.wsdl;

import emitters.Utils;
import emitters.VmodlEmitter;
import emitters.backend.Platform;
import emitters.model.ManagedObject;
import emitters.model.Property;
import emitters.model.VmodlObject;
import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLTypeInfoEmitter
extends VmodlEmitter {
    private final String _filename;
    private Document _doc;
    private Stack<Node> _nodeStack;
    private Node _curNode;
    private int _indent = 0;

    public XMLTypeInfoEmitter(String filename) {
        this._filename = filename;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this._doc = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("Parse configuration error: " + pce.getMessage());
        }
        this._curNode = this._doc.createElement("vmodl");
        this._doc.appendChild(this._curNode);
        this._nodeStack = new Stack();
        this.appendNewline();
        ++this._indent;
    }

    private void appendIndent() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._indent * 3; ++i) {
            sb.append(" ");
        }
        Text textNode = this._doc.createTextNode(sb.toString());
        this._curNode.appendChild(textNode);
    }

    private void appendNewline() {
        Text textNode = this._doc.createTextNode("\n");
        this._curNode.appendChild(textNode);
    }

    private void beginTag(String name) {
        this.appendIndent();
        Element elemNode = this._doc.createElement(name);
        this._curNode.appendChild(elemNode);
        this._nodeStack.push(this._curNode);
        this._curNode = elemNode;
        this.appendNewline();
        ++this._indent;
    }

    private void endTag() {
        --this._indent;
        this.appendIndent();
        this._curNode = this._nodeStack.pop();
        this.appendNewline();
    }

    private void valueTag(String tagName, String value) {
        Element elemNode = this._doc.createElement(tagName);
        Text textNode = this._doc.createTextNode(value);
        elemNode.appendChild(textNode);
        this.appendIndent();
        this._curNode.appendChild(elemNode);
        this.appendNewline();
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        for (VmodlObject obj : objects) {
            this.processObject(obj);
        }
        try {
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer aTransformer = tranFactory.newTransformer();
            DOMSource src = new DOMSource(this._doc);
            File file = new File(this._filename);
            PrintWriter writer = Platform.createTextFile(file);
            StreamResult dest = new StreamResult(writer);
            aTransformer.transform(src, dest);
        }
        catch (Exception e) {
            throw new RuntimeException("XML transform error: " + e.getMessage());
        }
    }

    private void processObject(VmodlObject obj) {
        for (VmodlObject nestedObj : obj.getNestedList()) {
            this.processObject(nestedObj);
        }
        if (obj instanceof ManagedObject) {
            this.processManagedObject((ManagedObject)obj);
        }
    }

    private void processManagedObject(ManagedObject mobj) {
        this.beginTag("managedObject");
        this.valueTag("name", mobj.getQualifiedVmodlType());
        this.valueTag("wsdlName", mobj.getWsdlName());
        ManagedObject base = (ManagedObject)mobj.getBaseObject();
        if (base != null && !base.getQualifiedVmodlType().equals(Utils.ManagedObjectClassName)) {
            this.valueTag("base", base.getQualifiedVmodlType());
        }
        for (Property prop : mobj.getPropertyList()) {
            this.beginTag("property");
            this.valueTag("name", prop.getName());
            this.valueTag("wsdlName", prop.getWsdlName());
            String privId = prop.getPrivilegeId();
            if (null == privId) {
                privId = "System.Read";
            }
            this.valueTag("privilege", privId);
            this.endTag();
        }
        this.endTag();
    }
}

