/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl;

import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrFault;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrResponse;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl.DrFaultImpl;

public class DrResponseImpl
implements DrResponse {
    private boolean _isSuccessful;
    private DrData _data;
    private DrFault _fault;

    public static DrResponseImpl create(DrData data) {
        if (data == null) {
            throw new IllegalArgumentException("No data.");
        }
        DrResponseImpl result = new DrResponseImpl();
        result.setData(data);
        result.setIsSuccessful(true);
        return result;
    }

    public static DrResponseImpl create(Exception ex) {
        DrResponseImpl result = new DrResponseImpl();
        result.setIsSuccessful(false);
        DrFaultImpl fault = DrFaultImpl.from(ex);
        result.setFault(fault);
        return result;
    }

    public static DrResponseImpl create(String faultMsg, String faultDetail) {
        DrResponseImpl result = new DrResponseImpl();
        result.setIsSuccessful(false);
        DrFaultImpl fault = new DrFaultImpl();
        fault.setMessage(faultMsg);
        fault.setDetail(faultDetail);
        result.setFault(fault);
        return result;
    }

    @Override
    public boolean isSuccessful() {
        return this._isSuccessful;
    }

    public void setIsSuccessful(boolean isSuccessful) {
        this._isSuccessful = isSuccessful;
    }

    @Override
    public DrData getData() {
        return this._data;
    }

    public void setData(DrData data) {
        this._data = data;
    }

    @Override
    public DrFault getFault() {
        return this._fault;
    }

    public void setFault(DrFault fault) {
        this._fault = fault;
    }
}

