/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.builder;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.impl.core.engine.Graph;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BootstrapNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.LsppConsistencyWatcher;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.NodeContext;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.TokenProviderImpl;
import com.vmware.srm.client.topology.impl.sso.DrSecurityTokenService;
import com.vmware.srm.client.topology.impl.sso.SsoFacade;
import com.vmware.srm.client.topology.impl.utils.L10N;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.vim.sso.client.SamlToken;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewBuilder
implements LsppConsistencyWatcher.LsppConsistencyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewBuilder.class);
    private final Object _lock = new Object();
    private final URI _lsppUrl;
    private final String _lsppThumbprint;
    private final X509Certificate _certificate;
    private final PrivateKey _privateKey;
    private volatile boolean _federationChanged = false;
    private volatile Graph<NodeContext> _engineGraph;
    private volatile LsppConsistencyWatcher _consistencyWatcher;
    private volatile NodeContext _context = null;
    private volatile BaseRequest _nextRequest;
    private volatile boolean _authenticated = false;
    private volatile boolean _shutdown = false;

    public ViewBuilder(URI lsppUrl, String lsppThumbprint, X509Certificate certificate, PrivateKey privateKey) {
        this._lsppUrl = lsppUrl;
        this._lsppThumbprint = lsppThumbprint;
        this._certificate = certificate;
        this._privateKey = privateKey;
        this._engineGraph = this.createEntityGraph(lsppUrl, this._lsppThumbprint);
        this._consistencyWatcher = new LsppConsistencyWatcher(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServersView startBuildView() {
        NodeContext context;
        RefreshRequest request = new RefreshRequest(new ServersViewImpl());
        Object object = this._lock;
        synchronized (object) {
            if (this._shutdown) {
                request.reject(new ShutdownException());
                return request.getView();
            }
            if (this._context != null) {
                if (this._nextRequest == null) {
                    this._nextRequest = request;
                }
                return this._nextRequest.getView();
            }
            this._context = context = request.getContext(this._consistencyWatcher);
        }
        this.startRefresh(request, context);
        return request.getView();
    }

    public Promise<ServersView> startBuildView(String username, String password) {
        return this.startBuildView(view -> new CredentialsLoginRequest((ServersViewImpl)view, username, password));
    }

    public Promise<ServersView> startBuildView(SamlToken suToken, SamlToken actAsToken) {
        return this.startBuildView(view -> new TokenLoginRequest((ServersViewImpl)view, suToken, actAsToken));
    }

    public Promise<ServersView> startBuildViewWithSolutionUser() {
        return this.startBuildView(x$0 -> new SolutionUserLoginRequest((ServersViewImpl)x$0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Promise<ServersView> startBuildView(Function<ServersViewImpl, LoginRequest> producer) {
        NodeContext context;
        LoginRequest request = producer.apply(new ServersViewImpl());
        Object object = this._lock;
        synchronized (object) {
            if (this._shutdown) {
                request.reject(new ShutdownException());
                return request.getPromise();
            }
            if (this._context != null) {
                if (this._nextRequest == null) {
                    this._nextRequest = request;
                    return request.getPromise();
                }
                if (this._nextRequest instanceof LoginRequest) {
                    request.reject(new IllegalStateException("Duplicate login request."));
                    return request.getPromise();
                }
                request = producer.apply(this._nextRequest.getView());
                this._nextRequest = request;
                return request.getPromise();
            }
            this._context = context = request.getContext(this._consistencyWatcher);
        }
        this.startRefresh(request, context);
        return request.getPromise();
    }

    public boolean isAuthenticated() {
        return this._authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Graph<NodeContext> toDispose = null;
        Object object = this._lock;
        synchronized (object) {
            if (this._shutdown) {
                return;
            }
            this._shutdown = true;
            if (this._context == null) {
                toDispose = this._engineGraph;
            }
        }
        if (this._nextRequest != null) {
            this._nextRequest.reject(new ShutdownException());
            this._nextRequest = null;
        }
        if (toDispose != null) {
            toDispose.dispose();
        }
    }

    @Override
    public void federationChanged(LsppConsistencyWatcher watcher, URI lsppUrl) {
        this._federationChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleContextComplete(NodeContext prevContext, Exception graphError) {
        prevContext.getView().close();
        if (this._federationChanged || graphError != null) {
            this._federationChanged = false;
            this._authenticated = false;
            this._consistencyWatcher = new LsppConsistencyWatcher(this);
            this._engineGraph.dispose();
            this._engineGraph = this.createEntityGraph(this._lsppUrl, this._lsppThumbprint);
        }
        Graph<NodeContext> toDispose = null;
        BaseRequest request = null;
        NodeContext context = null;
        Object object = this._lock;
        synchronized (object) {
            this._context = null;
            if (this._shutdown) {
                toDispose = this._engineGraph;
            } else if (this._nextRequest != null) {
                request = this._nextRequest;
                this._nextRequest = null;
                this._context = context = request.getContext(this._consistencyWatcher);
            }
        }
        if (request != null) {
            this.startRefresh(request, context);
        }
        if (toDispose != null) {
            toDispose.dispose();
        }
    }

    private void startRefresh(BaseRequest request, NodeContext context) {
        this._engineGraph.refresh(context).materialize().onSuccess(pr -> this.handleContextComplete(context, pr.getError()));
    }

    private Graph<NodeContext> createEntityGraph(URI lsppUrl, String lsppThumbprint) {
        return new Graph<NodeContext>(new BootstrapNode(lsppUrl, lsppThumbprint, this._certificate, this._privateKey));
    }

    private final class RefreshRequest
    extends BaseRequest {
        RefreshRequest(ServersViewImpl view) {
            super(view);
        }

        @Override
        protected NodeContext createContext(ServersViewImpl view, LsppConsistencyWatcher watcher) {
            return new NodeContext(view, watcher){

                @Override
                public Promise<Void> initLocalTokenProvider(TokenProvider provider, Exception exc) {
                    Promise result;
                    Promise promise = result = exc == null ? Promises.resolve(null) : Promises.reject((Exception)exc);
                    if (provider == null) {
                        return result;
                    }
                    return provider.isLoggedIn().thenCompose(loggedIn -> {
                        ViewBuilder.this._authenticated = loggedIn != false && !(exc instanceof LsppConsistencyWatcher.LsppFederationChangedException);
                        return result;
                    });
                }
            };
        }
    }

    public static class ShutdownException
    extends Topology.TopologyException {
        ShutdownException() {
            super("Builder is shutdown.");
        }
    }

    private static abstract class BaseRequest {
        private final ServersViewImpl _view;

        BaseRequest(ServersViewImpl view) {
            this._view = view;
        }

        void reject(Exception err) {
            this._view.getLocalPublisher().complete(err);
            this._view.close();
        }

        final ServersViewImpl getView() {
            return this._view;
        }

        final NodeContext getContext(LsppConsistencyWatcher watcher) {
            return this.createContext(this._view, watcher);
        }

        protected abstract NodeContext createContext(ServersViewImpl var1, LsppConsistencyWatcher var2);
    }

    private abstract class LoginRequest
    extends BaseRequest {
        private final PromiseImpl<ServersView> _loginPromise;

        LoginRequest(ServersViewImpl view) {
            super(view);
            this._loginPromise = new PromiseImpl();
        }

        Promise<ServersView> getPromise() {
            return this._loginPromise;
        }

        @Override
        void reject(Exception err) {
            super.reject(err);
            this._loginPromise.setError(err);
        }

        protected abstract Promise<Void> doLogin(TokenProvider var1);

        @Override
        protected final NodeContext createContext(final ServersViewImpl view, LsppConsistencyWatcher watcher) {
            return new NodeContext(view, watcher){

                @Override
                public Promise<Void> initLocalTokenProvider(TokenProvider provider, Exception exc) {
                    if (exc != null) {
                        ViewBuilder.this._authenticated = false;
                        LoginRequest.this._loginPromise.setError(exc);
                        return Promises.reject((Exception)exc);
                    }
                    return provider.isLoggedIn().thenCompose(isLoggedIn -> {
                        if (isLoggedIn.booleanValue()) {
                            RuntimeException cause = new RuntimeException(L10N.localize("viewBuilder.alreadyAuthenticated", new Object[0]));
                            LoginRequest.this._loginPromise.setError((Exception)cause);
                            return Promises.reject((Exception)cause);
                        }
                        return LoginRequest.this.doLogin(provider).onSuccess(unused -> {
                            ViewBuilder.this._authenticated = true;
                            LoginRequest.this._loginPromise.setResult((Object)view);
                        }).onError(err -> {
                            LOGGER.warn("Login request failed.", (Throwable)err);
                            ViewBuilder.this._authenticated = false;
                            LoginRequest.this._loginPromise.setError(err);
                        });
                    });
                }
            };
        }
    }

    private final class SolutionUserLoginRequest
    extends LoginRequest {
        SolutionUserLoginRequest(ServersViewImpl view) {
            super(view);
        }

        @Override
        protected Promise<Void> doLogin(TokenProvider provider) {
            TokenProviderImpl impl = (TokenProviderImpl)provider;
            DrSecurityTokenService sts = impl.getSts();
            try {
                SsoFacade.getTokenManager().acquireTokenByCertificate(impl.getSts());
                return Promises.resolve(null);
            }
            catch (Exception e) {
                return Promises.reject((Exception)new TokenProvider.AcquireTokenFailed(sts.getUrl(), (Throwable)e));
            }
        }
    }

    private final class TokenLoginRequest
    extends LoginRequest {
        private final SamlToken _suToken;
        private final SamlToken _actAsToken;

        TokenLoginRequest(ServersViewImpl view, SamlToken suToken, SamlToken actAsToken) {
            super(view);
            Validate.notNull((Object)suToken, (String)"suToken");
            Validate.notNull((Object)actAsToken, (String)"actAsToken");
            this._suToken = suToken;
            this._actAsToken = actAsToken;
        }

        @Override
        protected Promise<Void> doLogin(TokenProvider provider) {
            return provider.loginWith(this._suToken, this._actAsToken).thenApply(unused -> null);
        }
    }

    private final class CredentialsLoginRequest
    extends LoginRequest {
        private final String _username;
        private final String _password;

        CredentialsLoginRequest(ServersViewImpl view, String username, String password) {
            super(view);
            Validate.notEmpty((String)username, (String)"username");
            Validate.notEmpty((String)password, (String)"password");
            this._username = username;
            this._password = password;
        }

        @Override
        protected Promise<Void> doLogin(TokenProvider provider) {
            return provider.loginWith(this._username, this._password).thenApply(unused -> null);
        }
    }
}

