/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.HashUtils;
import com.vmware.dr.ui.tools.utilities.StringUtils;
import com.vmware.srm.client.topology.impl.core.engine.Node;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BaseLsppNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BaseNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.LsppConsistencyWatcher;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.NodeContext;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.RemoteLsppNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.LsppHelper;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.PairSetupPublisher;
import com.vmware.srm.client.topology.impl.core.operations.faults.ProviderNotAuthenticatedException;
import com.vmware.srm.client.topology.impl.lspp.LsppNegotiator;
import com.vmware.srm.client.topology.impl.lspp.Types;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.view.availability.ExtensionServerImpl;
import com.vmware.srm.client.topology.impl.view.availability.PairSetupImpl;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePairNode<T extends ExtensionServerImpl, S extends PairSetupImpl<?>, P>
extends BaseNode
implements LsppConsistencyWatcher.LsppSupplier {
    private static final String PAIR_SETUP_KEY = "BasePairNode.PairSetup";
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePairNode.class);
    private final URI _pairLsppUrl;
    private final String _pairLsppThumbprint;
    private final String _serverGuid;
    private final String _pairServerGuid;
    private final int _hashCode;
    private volatile LsppNegotiator _lsppNegotiator;
    private volatile T _server;
    private volatile P _pairInfo;
    private volatile PairSetupPublisher<S> _publisher;

    BasePairNode(URI pairLsppUrl, String pairLsppThumbprint, String serverGuid, String pairServerGuid, T server, P pairInfo, PairSetupPublisher<S> publisher) {
        this._pairLsppUrl = pairLsppUrl;
        this._pairLsppThumbprint = pairLsppThumbprint;
        this._serverGuid = serverGuid;
        this._pairServerGuid = pairServerGuid;
        this._hashCode = HashUtils.getHashCode((Object[])new Object[]{this._pairLsppUrl, this._pairLsppThumbprint, this._server, this._pairServerGuid});
        this._server = server;
        this._pairInfo = pairInfo;
        this._publisher = publisher;
    }

    @Override
    public int hashCode() {
        return this._hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BasePairNode)) {
            return false;
        }
        BasePairNode other = (BasePairNode)obj;
        return HashUtils.areEqual((Object)this._pairLsppUrl, (Object)other._pairLsppUrl) && HashUtils.areEqual((Object)this._pairLsppThumbprint, (Object)other._pairLsppThumbprint) && HashUtils.areEqual((Object)this._serverGuid, (Object)other._serverGuid) && HashUtils.areEqual((Object)this._pairServerGuid, (Object)other._pairServerGuid);
    }

    @Override
    public String toString() {
        HashMap<String, Object> members = new HashMap<String, Object>();
        members.put("_pairLsppUrl", this._pairLsppUrl);
        members.put("_pairLsppThumbprint", this._pairLsppThumbprint);
        members.put("_serverGuid", this._serverGuid);
        members.put("_pairServerGuid", this._pairServerGuid);
        String instanceName = this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this));
        return StringUtils.getToStringValue((String)instanceName, members);
    }

    @Override
    public final void added(NodeContext context) {
        this.addPairSetup(this, context);
    }

    protected abstract S createPairSetup(NodeContext var1, ServersViewImpl var2, T var3, P var4);

    @Override
    public void update(Node<NodeContext> suggested, NodeContext context) {
        BasePairNode suggestedPair = (BasePairNode)suggested;
        this.addPairSetup(suggestedPair, context);
    }

    private void addPairSetup(BasePairNode<T, S, P> pairNode, NodeContext context) {
        S ps;
        NodeContext.NestedContext nodeContext = context.getNodeContext(this);
        if (nodeContext.putIfAbsent(PAIR_SETUP_KEY, ps = this.createPairSetup(context, context.getView(), pairNode._server, pairNode._pairInfo)) == null) {
            pairNode._publisher.complete(ps);
        } else {
            LOGGER.error("Failed to add PairSetup for {}", (Object)this);
            pairNode._publisher.complete(new RuntimeException("PairSetup for " + String.valueOf(this) + " already added"));
        }
        pairNode._server = null;
        pairNode._pairInfo = null;
        pairNode._publisher = null;
    }

    @Override
    public Promise<Set<? extends Node<NodeContext>>> discoverNeighbours(NodeContext context) {
        Promise<Set<Node<NodeContext>>> result;
        PairSetupImpl ps = (PairSetupImpl)context.getNodeContext(this).get(PAIR_SETUP_KEY);
        if (ps == null) {
            return Promises.resolve(Collections.emptySet());
        }
        LsppConsistencyWatcher watcher = context.getLsppConsistencyWatcher();
        if (this._lsppNegotiator == null) {
            this._lsppNegotiator = new LsppNegotiator(this._pairLsppUrl, this._pairLsppThumbprint, null);
        }
        try {
            result = this.discoverNeighbours(this._lsppNegotiator, watcher);
        }
        catch (Exception exc2) {
            LOGGER.warn("Failed to discover neighbours for {}", (Object)this, (Object)exc2);
            ps.complete((Promise<PairSetupImpl.RemoteLoginSupplier>)Promises.reject((Exception)exc2));
            return Promises.reject((Exception)exc2);
        }
        result.onError(exc -> ps.complete((Promise<PairSetupImpl.RemoteLoginSupplier>)Promises.reject((Exception)exc)));
        return result;
    }

    private Promise<Set<? extends Node<NodeContext>>> discoverNeighbours(LsppNegotiator ln, LsppConsistencyWatcher watcher) {
        return LsppHelper.listServers(ln, Types.LsppType.Sso).thenApply(ssoMap -> {
            Set<LsppService> ssos = ssoMap.getOrDefault((Object)Types.LsppType.Sso, Collections.emptySet());
            if (watcher.tryAdd(ssos, this)) {
                return Collections.singleton(new RemoteLsppNode(ssos));
            }
            throw new LsppConsistencyWatcher.LsppFederationChangedException(this.getLsppUrl());
        });
    }

    @Override
    public final void neighbourAdded(Node<NodeContext> neighbour, NodeContext context) {
        this.processNeighbour(neighbour, context);
    }

    @Override
    public final void neighbourUpdated(Node<NodeContext> neighbour, NodeContext context) {
        this.processNeighbour(neighbour, context);
    }

    private void processNeighbour(Node<NodeContext> neighbour, NodeContext context) {
        PairSetupImpl ps = (PairSetupImpl)context.getNodeContext(this).get(PAIR_SETUP_KEY);
        if (ps == null) {
            LOGGER.error("No PairSetup for {}", (Object)this);
            return;
        }
        BaseLsppNode lsppNode = (BaseLsppNode)neighbour;
        TokenProvider tp = lsppNode.getTokenProvider();
        Promise rlsPromise = tp.isLoggedIn().thenCompose(isLoggedIn -> {
            if (!isLoggedIn.booleanValue()) {
                return Promises.reject((Exception)((Object)new ProviderNotAuthenticatedException(tp)));
            }
            return Promises.resolve((Object)this.getRemoteLoginSupplier(ps, tp));
        });
        ps.complete((Promise<PairSetupImpl.RemoteLoginSupplier>)rlsPromise);
    }

    protected abstract PairSetupImpl.RemoteLoginSupplier getRemoteLoginSupplier(S var1, TokenProvider var2);

    @Override
    public void neighbourRemoved(Node<NodeContext> neighbour, NodeContext context) {
    }

    @Override
    public void removed() {
    }

    @Override
    public void dispose() {
        LsppNegotiator ln = this._lsppNegotiator;
        this._lsppNegotiator = null;
        if (ln != null) {
            ln.close();
        }
    }

    @Override
    public URI getLsppUrl() {
        return this._pairLsppUrl;
    }
}

