/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsPairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmPairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.impl.core.engine.Context;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BaseNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.LsppConsistencyWatcher;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.ServersViewRecorder;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.ServersViewRecorderImpl;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.record.VmomiCallRecorder;
import java.util.concurrent.ConcurrentHashMap;

public abstract class NodeContext
implements Context {
    private static final ServersViewRecorder RECORDER = VmomiCallRecorder.isEnabled() ? new ServersViewRecorderImpl() : new NoOpRecorder();
    private final ConcurrentHashMap<BaseNode, NestedContext> _contexts = new ConcurrentHashMap();
    private final ServersViewImpl _view;
    private final LsppConsistencyWatcher _watcher;

    public NodeContext(ServersViewImpl view, LsppConsistencyWatcher watcher) {
        this._view = view;
        this._watcher = watcher;
    }

    public abstract Promise<Void> initLocalTokenProvider(TokenProvider var1, Exception var2);

    public ServersViewImpl getView() {
        return this._view;
    }

    public LsppConsistencyWatcher getLsppConsistencyWatcher() {
        return this._watcher;
    }

    public NestedContext getNodeContext(BaseNode node) {
        return this._contexts.computeIfAbsent(node, ignored -> new NestedContext());
    }

    public ServersViewRecorder getRecorder() {
        return RECORDER;
    }

    public final class NestedContext
    extends ConcurrentHashMap<String, Object> {
        private NestedContext() {
        }
    }

    private static final class NoOpRecorder
    implements ServersViewRecorder {
        private NoOpRecorder() {
        }

        @Override
        public void recordVc(VcServer vcServer) {
        }

        @Override
        public void recordSrm(SrmServer srm) {
        }

        @Override
        public void recordSrmPair(SrmPairSetup ps) {
        }

        @Override
        public void recordHms(HmsServer hms) {
        }

        @Override
        public void recordHmsPair(HmsPairSetup ps) {
        }
    }
}

