/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vc;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.updates.UpdatesManager;
import com.vmware.srm.client.topology.client.vmomi.vc.VcService;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.osgi.VmodlContextInitializer;
import com.vmware.srm.client.topology.impl.vmomi.updates.UpdatesManagerImpl;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.HttpConfigurationManager;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VersionsXmlServiceImpl;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.version.internal.version11;
import com.vmware.vim.binding.vim.version.internal.versions;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.KeyStore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcServiceImpl
extends VersionsXmlServiceImpl<ServiceInstance, ServiceInstanceContent>
implements VcService {
    private static final String VERSIONS_PATH = "/sdk/vimServiceVersions.xml";
    private static final Class<? extends Annotation> MIN_SUPPORTED_VERSION = version11.class;
    public static final Class<? extends Annotation> VERSION = versions.VIM_VERSION_LTS;
    public static final ManagedObjectReference SERVICE_INSTANCE;
    public static final VmodlContextInitializer VMODL_INIT;
    private static final VcHttpConfigurationManager MANAGER;
    private final AtomicReference<UpdatesManagerImpl> _updatesManager = new AtomicReference();
    private final AtomicBoolean _disposed = new AtomicBoolean(false);
    private static final Logger LOGGER;

    public VcServiceImpl(URI server, KeyStore store, TokenProvider tokenProvider) {
        super(server, MANAGER.getConfiguration(), VMODL_INIT, MIN_SUPPORTED_VERSION, tokenProvider, SERVICE_INSTANCE, "vCenter Server", VERSIONS_PATH, MANAGER.getHttpClient());
        MANAGER.addThumbprints(store);
    }

    @Override
    protected String getServerGuid(ServiceInstanceContent content) {
        return content.getAbout().getInstanceUuid();
    }

    @Override
    protected Promise<ServiceInstanceContent> retrieveContent(ServiceInstance serviceInstance) {
        FuturePromise result = new FuturePromise();
        serviceInstance.retrieveContent((Future)result);
        return result;
    }

    @Override
    protected Promise<Void> login(ServiceInstanceContent content, String locale) {
        return this.createLoginStub(content.getSessionManager()).thenCompose(sm -> {
            FuturePromise result = new FuturePromise();
            sm.loginByToken(locale, (Future)result);
            return result;
        }).thenApply(unused -> null);
    }

    @Override
    protected Promise<Void> logout(ServiceInstanceContent content) {
        return this.createFreeStub(content.getSessionManager()).thenCompose(sm -> {
            FuturePromise result = new FuturePromise();
            sm.logout((Future)result);
            return result;
        });
    }

    @Override
    public UpdatesManager getUpdatesManager() {
        if (this._updatesManager.compareAndSet(null, new UpdatesManagerImpl(this, 100, 20))) {
            LOGGER.info("Created UpdatesManager for VC server {}.", (Object)this.getServerUrl());
        }
        if (this._disposed.get()) {
            UpdatesManagerImpl mngr = this._updatesManager.get();
            if (mngr != null) {
                mngr.dispose();
                this._updatesManager.set(null);
            }
            throw new IllegalStateException("VcService for server " + String.valueOf(this.getServerUrl()) + " already disposed.");
        }
        return this._updatesManager.get();
    }

    @Override
    public void dispose() {
        if (this._disposed.getAndSet(true)) {
            LOGGER.info("VcService for server {} already disposed. Ignoring dispose request.", (Object)this.getServerUrl());
            return;
        }
        super.dispose();
        UpdatesManagerImpl mngr = this._updatesManager.get();
        if (mngr != null) {
            mngr.dispose();
            this._updatesManager.set(null);
        }
    }

    static {
        MANAGER = new VcHttpConfigurationManager();
        LOGGER = LoggerFactory.getLogger(VcServiceImpl.class);
        VmodlContext context = VmodlContext.initContext((String[])new String[0], (boolean)false);
        VMODL_INIT = new VmodlContextInitializer(context, VERSION);
        SERVICE_INSTANCE = ClientUtils.createMoRef("ServiceInstance", "ServiceInstance", null);
    }

    private static final class VcHttpConfigurationManager
    extends HttpConfigurationManager {
        private VcHttpConfigurationManager() {
        }

        private HttpConfiguration getConfiguration() {
            return this._httpConfiguration;
        }

        @Override
        protected CloseableHttpAsyncClient getHttpClient() {
            return super.getHttpClient();
        }
    }
}

