/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi;

import com.ctc.wstx.stax.WstxInputFactory;
import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.srm.client.topology.impl.utils.Exceptions;
import com.vmware.srm.client.topology.impl.utils.L10N;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.osgi.VmodlContextInitializer;
import com.vmware.srm.client.topology.impl.vmomi.version.VersionUtils;
import com.vmware.srm.client.topology.impl.vmomi.version.VmomiNamespace;
import com.vmware.srm.client.topology.impl.vmomi.version.VmomiNamespaces;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VmomiServiceImpl;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VersionsXmlServiceImpl<S extends ManagedObject, D extends DataObject>
extends VmomiServiceImpl<S, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionsXmlServiceImpl.class);
    private static final JAXBContext JAXB_CONTEXT;
    private static final XMLInputFactory XML_INPUT_FACTORY;
    private final URI _versionsXmlUrl;
    private final VmodlVersion _maxSupportedVersion;
    private final List<VmodlVersion> _supportedVersions;
    private final CloseableHttpAsyncClient _httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VmomiNamespaces parseEntity(HttpEntity entity) throws JAXBException, IOException, XMLStreamException {
        try (InputStream is = entity.getContent();){
            VmomiNamespaces vmomiNamespaces;
            XMLStreamReader reader = XML_INPUT_FACTORY.createXMLStreamReader(is);
            try {
                Unmarshaller jaxbUnmarshaller = JAXB_CONTEXT.createUnmarshaller();
                vmomiNamespaces = (VmomiNamespaces)jaxbUnmarshaller.unmarshal(reader);
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
            reader.close();
            return vmomiNamespaces;
        }
    }

    public VersionsXmlServiceImpl(URI server, HttpConfiguration httpConfiguration, VmodlContextInitializer vmodlInitializer, Class<? extends Annotation> minSupportedVersionClass, TokenProvider provider, ManagedObjectReference siRef, String serverDescription, String versionsXmlPath, CloseableHttpAsyncClient httpClient) {
        super(server, httpConfiguration, vmodlInitializer, provider, siRef, serverDescription);
        Validate.notEmpty((String)versionsXmlPath, (String)"versionsXmlPath");
        try {
            this._versionsXmlUrl = new URI(server.getScheme(), null, server.getHost(), server.getPort(), versionsXmlPath, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to create xml versions URI.", e);
        }
        VmodlVersionMap versionMap = this.getVersionMap();
        Class<? extends Annotation> maxSupportedVersionClass = vmodlInitializer.getVersionClass();
        this._maxSupportedVersion = versionMap.getVersion(maxSupportedVersionClass);
        this._supportedVersions = VersionUtils.getSupportedVersionsChain(maxSupportedVersionClass, minSupportedVersionClass, versionMap);
        this._httpClient = httpClient;
    }

    @Override
    protected Promise<VmodlVersion> negotiateVersion() {
        return this.doGet().thenApply(response -> {
            VmomiNamespaces namespaces;
            int code = response.getStatusLine().getStatusCode();
            if (code != 200) {
                String msg = L10N.localize("versionsXmlServiceImpl.unableToDownload", this, response.getStatusLine());
                throw new TransportProtocolException(msg);
            }
            try {
                namespaces = VersionsXmlServiceImpl.parseEntity(response.getEntity());
            }
            catch (IOException | JAXBException | XMLStreamException e) {
                throw Exceptions.getRuntimeException(e);
            }
            return this.pickVersion(namespaces);
        });
    }

    private Promise<HttpResponse> doGet() {
        HttpGet request = new HttpGet(this._versionsXmlUrl);
        HttpResponsePromise result = new HttpResponsePromise();
        this._httpClient.execute((HttpUriRequest)request, (FutureCallback)result);
        return result;
    }

    private VmodlVersion pickVersion(VmomiNamespaces namespaces) {
        List<VmomiNamespace> nsList = namespaces.namespaces;
        for (int i = 0; nsList != null && i < nsList.size(); ++i) {
            String currentVersion;
            String ns;
            VmomiNamespace namespace = nsList.get(i);
            VmodlVersionMap supportedVersions = this.getVersionMap();
            VmodlVersion result = supportedVersions.findVersion(ns = namespace.name.replaceFirst("urn:", ""), currentVersion = namespace.version, false);
            if (result != null && this._supportedVersions.indexOf(result) != -1) {
                if (this._maxSupportedVersion.isInternal()) {
                    result = supportedVersions.findVersion(ns, currentVersion, true);
                }
                LOGGER.info("Using version '{}' for '{}'", (Object)result.getVersionClass(), (Object)this);
                return result;
            }
            List<String> priorVersions = namespace.priorVersions;
            if (priorVersions == null || priorVersions.isEmpty()) continue;
            for (String pv : priorVersions) {
                int index;
                result = supportedVersions.findVersion(ns, pv, false);
                if (result == null || (index = this._supportedVersions.indexOf(result)) == -1) continue;
                if (this._maxSupportedVersion.isInternal()) {
                    result = supportedVersions.findVersion(ns, pv, true);
                }
                LOGGER.info("Using version '{}' for '{}'", (Object)result.getVersionClass(), (Object)this);
                return result;
            }
        }
        LOGGER.warn("No supported vmodl version found for '{}'", (Object)this);
        throw new RuntimeException("No supported vmodl version found for " + String.valueOf(this));
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{VmomiNamespaces.class});
        }
        catch (JAXBException e) {
            throw Exceptions.getRuntimeException(e);
        }
        XML_INPUT_FACTORY = new WstxInputFactory();
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }

    private static final class HttpResponsePromise
    extends PromiseImpl<HttpResponse>
    implements FutureCallback<HttpResponse> {
        private HttpResponsePromise() {
        }

        public void cancelled() {
            this.setError(new CancellationException());
        }

        public void completed(HttpResponse result) {
            this.setResult(result);
        }

        public void failed(Exception exc) {
            this.setError(exc);
        }
    }
}

