/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi.pc;

import com.vmware.dr.ui.tools.utilities.HashUtils;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.DynamicProperty;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;

class PropertyCollectorUtils {
    private static final String SERVER_CLOCK = "serverClock";

    PropertyCollectorUtils() {
    }

    private static PropertyCollector.FilterSpec createServerClockSpec(ManagedObjectReference siRef) {
        PropertyCollector.ObjectSpec os = new PropertyCollector.ObjectSpec(siRef, Boolean.valueOf(false), null);
        PropertyCollector.PropertySpec ps = new PropertyCollector.PropertySpec(ClientUtils.getTypeName(siRef.getType()), Boolean.valueOf(false), new String[]{SERVER_CLOCK});
        return new PropertyCollector.FilterSpec(new PropertyCollector.PropertySpec[]{ps}, new PropertyCollector.ObjectSpec[]{os}, Boolean.valueOf(false));
    }

    static boolean areSrvInstancePropsRequested(PropertyCollector.FilterSpec[] specs, ManagedObjectReference siRef) {
        if (ArrayUtils.isEmpty((Object[])specs)) {
            return false;
        }
        TypeName type = ClientUtils.getTypeName(siRef.getType());
        Validate.notNull((Object)type, (String)"type");
        for (PropertyCollector.FilterSpec fs : specs) {
            if (ArrayUtils.isEmpty((Object[])fs.getObjectSet())) continue;
            for (PropertyCollector.ObjectSpec objectSpec : fs.getObjectSet()) {
                ManagedObjectReference osRef = objectSpec.getObj();
                if (!PropertyCollectorUtils.equalsSiRef(siRef, osRef) || objectSpec.getSkip() == null || !objectSpec.getSkip().booleanValue()) continue;
                return false;
            }
            if (ArrayUtils.isEmpty((Object[])fs.getPropSet())) continue;
            for (PropertyCollector.ObjectSpec objectSpec : fs.getPropSet()) {
                if (!type.equals((Object)objectSpec.getType())) continue;
                return true;
            }
        }
        return false;
    }

    static PropertyCollector.FilterSpec[] addServiceInstanceSpec(PropertyCollector.FilterSpec[] specs, ManagedObjectReference siRef) {
        Validate.notEmpty((Object[])specs, (String)"filterSpecs");
        specs = Arrays.copyOf(specs, specs.length + 1);
        specs[specs.length - 1] = PropertyCollectorUtils.createServerClockSpec(siRef);
        return specs;
    }

    private static void checkForNotAuthFault(PropertyCollector.ObjectContent oc) {
        Validate.notNull((Object)oc, (String)"ObjectContent");
        Object[] missingProps = oc.getMissingSet();
        if (ArrayUtils.isEmpty((Object[])missingProps)) {
            return;
        }
        for (Object mp : missingProps) {
            if (!(mp.getFault() instanceof NotAuthenticated)) continue;
            throw (NotAuthenticated)mp.getFault();
        }
    }

    private static <T> T[] remove(T[] source, int index) {
        Validate.notNull(source, (String)"source");
        if (index < 0 || index >= source.length) {
            throw new IndexOutOfBoundsException();
        }
        T[] newArr = Arrays.copyOf(source, source.length - 1);
        if (index == source.length - 1) {
            return newArr;
        }
        System.arraycopy(source, 0, newArr, 0, index);
        System.arraycopy(source, index + 1, newArr, index, source.length - index - 1);
        return newArr;
    }

    static PropertyCollector.ObjectContent[] checkForAuthErrorAndFixResults(PropertyCollector.ObjectContent[] contents, ManagedObjectReference siRef, boolean removeEmptySrvInstanceResult) throws NotAuthenticated {
        Validate.notEmpty((Object[])contents, (String)"objectContents");
        LinkedList<PropertyCollector.ObjectContent> list = new LinkedList<PropertyCollector.ObjectContent>(Arrays.asList(contents));
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            int propsCount;
            PropertyCollector.MissingProperty[] fixed;
            int i;
            PropertyCollector.ObjectContent oc = (PropertyCollector.ObjectContent)iter.next();
            PropertyCollectorUtils.checkForNotAuthFault(oc);
            if (!PropertyCollectorUtils.equalsSiRef(oc.getObj(), siRef)) continue;
            if (ArrayUtils.isNotEmpty((Object[])oc.getMissingSet())) {
                PropertyCollector.MissingProperty mp;
                for (i = 0; i < oc.getMissingSet().length && !(mp = oc.getMissingSet()[i]).getPath().equals(SERVER_CLOCK); ++i) {
                }
                if (i < oc.getMissingSet().length) {
                    fixed = PropertyCollectorUtils.remove(oc.getMissingSet(), i);
                    oc.setMissingSet(fixed);
                }
            }
            if (ArrayUtils.isNotEmpty((Object[])oc.getPropSet())) {
                DynamicProperty dp;
                for (i = 0; i < oc.getPropSet().length && !(dp = oc.getPropSet()[i]).getName().equals(SERVER_CLOCK); ++i) {
                }
                if (i < oc.getPropSet().length) {
                    fixed = PropertyCollectorUtils.remove(oc.getPropSet(), i);
                    oc.setPropSet((DynamicProperty[])fixed);
                }
            }
            Object[] missing = oc.getMissingSet();
            Object[] props = oc.getPropSet();
            int missingCount = ArrayUtils.isEmpty((Object[])missing) ? 0 : missing.length;
            int n = propsCount = ArrayUtils.isEmpty((Object[])props) ? 0 : props.length;
            if (propsCount + missingCount != 0 || !removeEmptySrvInstanceResult) break;
            iter.remove();
            break;
        }
        return list.toArray(new PropertyCollector.ObjectContent[list.size()]);
    }

    private static boolean equalsSiRef(ManagedObjectReference first, ManagedObjectReference second) {
        if (first == null) {
            return second == null;
        }
        if (first == second) {
            return true;
        }
        if (second == null) {
            return false;
        }
        return HashUtils.areEqual((Object)first.getType(), (Object)second.getType()) && HashUtils.areEqual((Object)first.getValue(), (Object)second.getValue());
    }
}

