/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi.record;

import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.utilities.AsyncConsumer;
import com.vmware.dr.ui.tools.utilities.OpIdAccessor;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.record.CallRecord;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmomiCallRecorder {
    private static final Logger LOGGER = LoggerFactory.getLogger(VmomiCallRecorder.class);
    private static final String RECORD_PATH_KEY = "com.vmware.dr.client.recordpath";
    private static final AtomicLong REQ_ID = new AtomicLong(0L);
    private static final File RECORD_PATH;
    public static final String REQUEST_FILE_PREFIX = "request-";
    public static final String VERSION_FILE = "vmomi-version";
    private static final AsyncConsumer<Runnable> ASYNC_RECORDER;
    private volatile VmodlVersion _version;
    private final PromiseImpl<String> _setGuid = new PromiseImpl();
    private final VmodlContext _vmodlContext;

    public static boolean isEnabled() {
        return RECORD_PATH != null;
    }

    public static File getRecordPath() {
        return RECORD_PATH;
    }

    public VmomiCallRecorder(VmodlContext vmodlContext) {
        this._vmodlContext = vmodlContext;
    }

    public void setVersion(VmodlVersion version) {
        this._version = version;
    }

    public void setGuid(String guid) {
        this._setGuid.setResult((Object)(guid == null ? "no-guid" : guid));
    }

    public void methodInvoked(ManagedObjectReference targetRef, Method method, Object[] args, Object result, Exception fault, Date startTime) {
        if (!VmomiCallRecorder.isEnabled()) {
            return;
        }
        String opId = OpIdAccessor.get();
        if (StringUtils.isEmpty((String)opId)) {
            LOGGER.warn("No opId defined for invocation '{}' for '{}' with '{}'", new Object[]{method, targetRef, args});
            return;
        }
        this._setGuid.onSuccess(guid -> {
            ManagedObjectReference finalRef = targetRef.getServerGuid() == null ? new ManagedObjectReference(targetRef.getType(), targetRef.getValue(), guid) : targetRef;
            RecordTask task = new RecordTask(RECORD_PATH, opId, (String)guid, method, finalRef, Arrays.copyOf(args, args.length - 1), result, fault, startTime);
            ASYNC_RECORDER.accept((Object)task);
        });
    }

    static {
        String recordPathVal = System.getProperty(RECORD_PATH_KEY);
        if (StringUtils.isNotEmpty((String)recordPathVal)) {
            File recordPath = new File(recordPathVal);
            if (!recordPath.exists()) {
                LOGGER.warn("Record path '{}' does not exist.", (Object)recordPath);
                RECORD_PATH = null;
            } else if (!recordPath.isDirectory()) {
                LOGGER.warn("Record path '{}' is not a directory.", (Object)recordPath);
                RECORD_PATH = null;
            } else if (!recordPath.canWrite()) {
                LOGGER.warn("Record path '{}' cannot be written to.", (Object)recordPath);
                RECORD_PATH = null;
            } else {
                RECORD_PATH = recordPath;
            }
        } else {
            RECORD_PATH = null;
        }
        ASYNC_RECORDER = new AsyncConsumer<Runnable>(Runnable::run){

            protected void handleError(Throwable t, Runnable item) {
                LOGGER.warn("'{}' failed with: ", (Object)item, (Object)t);
            }
        };
    }

    private class RecordTask
    implements Runnable {
        private final File _guidDir;
        private final String _opId;
        private final CallRecord _record;

        private RecordTask(File recordRootDir, String opId, String guid, Method method, ManagedObjectReference thisRef, Object[] args, Object response, Exception fault, Date instant) {
            File opIdDir = new File(recordRootDir, opId);
            this._guidDir = new File(opIdDir, guid);
            this._opId = opId;
            this._record = new CallRecord(method, thisRef, args, response, fault, instant, VmomiCallRecorder.this._vmodlContext);
        }

        @Override
        public void run() {
            this._guidDir.mkdirs();
            File versionFile = new File(this._guidDir, VmomiCallRecorder.VERSION_FILE);
            String versionToString = VmomiCallRecorder.this._version.getNamespace() + "/" + VmomiCallRecorder.this._version.getVersionId();
            try {
                Files.createFile(versionFile.toPath(), new FileAttribute[0]);
                FileUtils.writeStringToFile((File)versionFile, (String)versionToString, (Charset)StandardCharsets.UTF_8);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            CallRecord.serializeToFile(this._record, new File(this._guidDir, VmomiCallRecorder.REQUEST_FILE_PREFIX + REQ_ID.getAndIncrement()), VmomiCallRecorder.this._version);
        }

        public String toString() {
            return "RecordTask{_guidDir=" + String.valueOf(this._guidDir) + ", _opId='" + this._opId + "', _record=" + String.valueOf(this._record) + "}";
        }
    }
}

