/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.dr;

import com.vmware.vim.binding.dr.ManagedEntity;
import com.vmware.vim.binding.dr.version.version0;
import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.task;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;

@fullyQualifiedVmodlName(value="dr.Folder")
@managed
@versionClass(value=version0.class)
@wsdlName(value="DrFolder")
public interface Folder
extends ManagedEntity {
    @readonly
    @name(value="name")
    @privilege(value="System.View")
    @versionClass(value=version0.class)
    public void getName(Future<String> var1);

    @readonly
    @name(value="childEntity")
    @privilege(value="System.View")
    @versionClass(value=version0.class)
    @optional
    @managedObjectType(value="com.vmware.vim.binding.dr.ManagedEntity")
    @map
    public void getChildEntity(@optional @managedObjectType(value="com.vmware.vim.binding.dr.ManagedEntity") Future<ManagedObjectReference[]> var1);

    @readonly
    @name(value="childType")
    @privilege(value="System.View")
    @versionClass(value=version0.class)
    @optional
    @list
    public void getChildType(@optional Future<TypeName[]> var1);

    @readonly
    @name(value="peer")
    @privilege(value="System.View")
    @versionClass(value=version0.class)
    @optional
    public void getPeer(@optional Future<Peer> var1);

    @readonly
    @name(value="totalFoldersCount")
    @privilege(value="System.View")
    @versionClass(value=version0.class)
    public void getTotalFoldersCount(Future<Integer> var1);

    @readonly
    @name(value="totalItemsCount")
    @privilege(value="System.View")
    @versionClass(value=version0.class)
    public void getTotalItemsCount(Future<Integer> var1);

    @readonly
    @name(value="totalAlertedItemsCount")
    @privilege(value="System.View")
    @versionClass(value=version0.class)
    public void getTotalAlertedItemsCount(Future<Integer> var1);

    @versionClass(value=version0.class)
    @wsdlName(value="DrCreateFolder_Task")
    @privilege(value="dynamic")
    @task
    @faults(value={"DrFaultDuplicateName", "InvalidName"})
    public void createFolder(@name(value="name") @versionClass(value=version0.class) String var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="DrMoveFolder_Task")
    @privilege(value="dynamic")
    @task
    @faults(value={"DrFaultDuplicateName", "DrFaultInvalidFolder"})
    public void move(@name(value="destination") @versionClass(value=version0.class) @managedObjectType(value="com.vmware.vim.binding.dr.Folder") ManagedObjectReference var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="DestroyFolder_Task")
    @privilege(value="dynamic")
    @task
    @faults(value={"DrFaultNotEmpty"})
    public void destroy(@managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var1);

    @versionClass(value=version0.class)
    @wsdlName(value="RenameFolder_Task")
    @privilege(value="dynamic")
    @task
    @faults(value={"DrFaultStringArgumentTooLong"})
    public void rename(@name(value="newName") @versionClass(value=version0.class) String var1, @managedObjectType(value="com.vmware.vim.binding.vim.Task") Future<ManagedObjectReference> var2);

    @versionClass(value=version0.class)
    @wsdlName(value="DrFolderPeer")
    @data
    @propertyOrder(value={"site", "folder"})
    public static class Peer
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public ManagedObjectReference site;
        public ManagedObjectReference folder;

        public Peer() {
        }

        public Peer(ManagedObjectReference site, ManagedObjectReference folder) {
            this.site = site;
            this.folder = folder;
        }

        @managedObjectType(value="com.vmware.vim.binding.dr.site.RemoteSite")
        @versionClass(value=version0.class)
        public ManagedObjectReference getSite() {
            return this.site;
        }

        @managedObjectType(value="com.vmware.vim.binding.dr.site.RemoteSite")
        @versionClass(value=version0.class)
        public void setSite(ManagedObjectReference site) {
            this.site = site;
        }

        @managedObjectType(value="com.vmware.vim.binding.dr.Folder")
        @versionClass(value=version0.class)
        public ManagedObjectReference getFolder() {
            return this.folder;
        }

        @managedObjectType(value="com.vmware.vim.binding.dr.Folder")
        @versionClass(value=version0.class)
        public void setFolder(ManagedObjectReference folder) {
            this.folder = folder;
        }

        public String toString() {
            StringBuilder objString = new StringBuilder(160);
            objString.append("(dr.Peer) {\n");
            objString.append("   ");
            objString.append("dynamicType = ");
            objString.append(this.getDynamicType());
            objString.append(",\n");
            objString.append("   ");
            objString.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                objString.append("null");
            } else {
                objString.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    objString.append("      ");
                    objString.append(StringUtil.indent((String)String.valueOf(this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        objString.append(",");
                    }
                    objString.append("\n");
                }
                objString.append("   ");
                objString.append("]");
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("site = ");
            if (this.getSite() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)String.valueOf(this.getSite()), (boolean)false));
            }
            objString.append(",\n");
            objString.append("   ");
            objString.append("folder = ");
            if (this.getFolder() == null) {
                objString.append("null");
            } else {
                objString.append(StringUtil.indent((String)String.valueOf(this.getFolder()), (boolean)false));
            }
            objString.append("\n}");
            return objString.toString();
        }
    }
}

