/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.tracing;

import com.vmware.vim.sso.client.tracer.GlobalTracer;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TracingFilter
implements Filter {
    private static final String THREAD_TAG_KEY = "Thread";
    private static final String SERVER_SPAN_CONTEXT = TracingFilter.class.getName() + ".activeSpanContext";
    private static final String GENERIC_OPERATION_NAME = "genericOperation";
    private static final String SSO_PATH = "/websso/saml2/sso/";
    private static final String SLO_PATH = "/websso/saml2/slo/";
    private static final String SSO_ID = "sso.websso.login";
    private static final String SLO_ID = "sso.websso.logout";
    private static boolean TRACE_ENABLED = false;
    private static final Log _logger = LogFactory.getLog(TracingFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (!TRACE_ENABLED || request.getAttribute(SERVER_SPAN_CONTEXT) != null) {
            chain.doFilter(request, response);
            return;
        }
        Tracer tracer = GlobalTracer.get();
        String uri = httpRequest.getRequestURI();
        String spanId = this.getSpanId(uri);
        SpanContext parentSpan = tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new HttpServletRequestExtractAdapter(httpRequest));
        if (_logger.isDebugEnabled()) {
            if (parentSpan == null) {
                _logger.debug((Object)("Parent span for " + uri + " request is null."));
            } else {
                _logger.debug((Object)("Creating span with parent SpanId: " + parentSpan.toSpanId() + " and parent TraceId: " + parentSpan.toTraceId() + " for request " + uri));
            }
        }
        Span span = tracer.buildSpan(spanId).asChildOf(parentSpan).withTag(Tags.SPAN_KIND.getKey(), "server").withTag(THREAD_TAG_KEY, Thread.currentThread().getName()).withTag(Tags.HTTP_METHOD.getKey(), httpRequest.getMethod()).withTag(Tags.HTTP_URL.getKey(), uri).start();
        httpRequest.setAttribute(SERVER_SPAN_CONTEXT, (Object)span.context());
        int scopeHashCode = 0;
        try (Scope scope = tracer.activateSpan(span);){
            if (_logger.isTraceEnabled()) {
                scopeHashCode = scope.hashCode();
                _logger.trace((Object)("Activating scope: " + scopeHashCode + " with span: " + span.hashCode() + " in thread: " + Thread.currentThread().getName()));
            }
            chain.doFilter(request, response);
            span.setTag(Tags.HTTP_STATUS.getKey(), (Number)((HttpServletResponse)response).getStatus());
        }
        catch (Throwable ex) {
            this.logError(span, ex);
            throw ex;
        }
        finally {
            span.finish();
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)("Closing scope: " + scopeHashCode + " and finish span: " + span.hashCode() + " in thread: " + Thread.currentThread().getName()));
            }
        }
    }

    public void init(FilterConfig filterConfig) {
        if (_logger.isInfoEnabled()) {
            try {
                Tracer tracer = GlobalTracer.get();
                _logger.info((Object)("OpenTracing feature is enabled:" + tracer));
                TRACE_ENABLED = true;
            }
            catch (Exception | NoClassDefFoundError e) {
                _logger.info((Object)"OpenTracing feature is disabled");
                _logger.debug((Object)"Failed to initialize tracing", e);
            }
        } else {
            _logger.warn((Object)"OpenTracing feature is disabled");
        }
    }

    public void destroy() {
    }

    private String getSpanId(String uri) {
        String spanId = GENERIC_OPERATION_NAME;
        if (uri.toLowerCase().startsWith(SSO_PATH)) {
            spanId = SSO_ID;
        } else if (uri.toLowerCase().startsWith(SLO_PATH)) {
            spanId = SLO_ID;
        }
        return spanId;
    }

    private void logError(Span span, Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>();
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.object", throwable);
        span.log(errorLogs).setTag(Tags.ERROR.getKey(), true);
    }

    protected static class HttpServletRequestExtractAdapter
    implements TextMap {
        private Map<String, List<String>> headers;

        public HttpServletRequestExtractAdapter(HttpServletRequest httpServletRequest) {
            this.headers = this.servletHeadersToMultiMap(httpServletRequest);
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            return new MultivaluedMapFlatIterator<String, String>(this.headers.entrySet());
        }

        public void put(String key, String value) {
            throw new UnsupportedOperationException("This class should be used only with Tracer.inject()!");
        }

        protected Map<String, List<String>> servletHeadersToMultiMap(HttpServletRequest httpServletRequest) {
            HashMap<String, List<String>> headersResult = new HashMap<String, List<String>>();
            Enumeration headerNamesIt = httpServletRequest.getHeaderNames();
            while (headerNamesIt.hasMoreElements()) {
                String headerName = (String)headerNamesIt.nextElement();
                Enumeration valuesIt = httpServletRequest.getHeaders(headerName);
                ArrayList<String> valuesList = new ArrayList<String>(1);
                while (valuesIt.hasMoreElements()) {
                    valuesList.add((String)valuesIt.nextElement());
                }
                headersResult.put(headerName, valuesList);
            }
            return headersResult;
        }

        public static final class MultivaluedMapFlatIterator<K, V>
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<K, List<V>>> mapIterator;
            private Map.Entry<K, List<V>> mapEntry;
            private Iterator<V> listIterator;

            public MultivaluedMapFlatIterator(Set<Map.Entry<K, List<V>>> multiValuesEntrySet) {
                this.mapIterator = multiValuesEntrySet.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.listIterator != null && this.listIterator.hasNext()) {
                    return true;
                }
                return this.mapIterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.mapEntry == null || !this.listIterator.hasNext() && this.mapIterator.hasNext()) {
                    this.mapEntry = this.mapIterator.next();
                    this.listIterator = this.mapEntry.getValue().iterator();
                }
                if (this.listIterator.hasNext()) {
                    return new AbstractMap.SimpleImmutableEntry<K, V>(this.mapEntry.getKey(), this.listIterator.next());
                }
                return new AbstractMap.SimpleImmutableEntry<K, Object>(this.mapEntry.getKey(), null);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

