/*
 * Decompiled with CFR 0.152.
 */
package emitters;

import emitters.Versions;
import emitters.model.Version;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class NsVersionAliases
implements Iterable<Entry> {
    public final Version newestVersion;
    public final Version ltsVersion;
    public final Version oldestVersion;
    public final int newestVersionIndex;
    public final int ltsVersionIndex;
    public final int oldestVersionIndex;
    private final List<Entry> _list = new ArrayList<Entry>(5);

    NsVersionAliases() {
        List<Version> versionsList = Versions.enumerateVersions();
        ListIterator<Version> it = versionsList.listIterator();
        Version version = it.next();
        int index = 0;
        this.newestVersion = version;
        this.newestVersionIndex = index;
        if (version.getWireNs().equals("vsan") && Versions.getMetaVersion("vsan") == null) {
            String id;
            while ((id = version.getWireId()).equals("dev.version") || id.equals("reserved")) {
                version = it.next();
            }
        }
        while (version.getKind() != Version.Kind.LTS) {
            version = it.next();
            ++index;
        }
        this.ltsVersion = version;
        this.ltsVersionIndex = index;
        it = versionsList.listIterator(versionsList.size());
        this.oldestVersion = it.previous();
        this.oldestVersionIndex = versionsList.size() - 1;
        this._list.add(new Entry("NEWEST", this.newestVersion, this.newestVersionIndex));
        this._list.add(new Entry("LTS", this.ltsVersion, this.ltsVersionIndex));
        this._list.add(new Entry("OLDEST", this.oldestVersion, this.oldestVersionIndex));
    }

    @Override
    public Iterator<Entry> iterator() {
        return this._list.iterator();
    }

    public static class Entry {
        public final String label;
        public final Version version;
        public final int index;

        public Entry(String label, Version version, int index) {
            this.label = label;
            this.version = version;
            this.index = index;
        }
    }
}

