/*
 * Decompiled with CFR 0.152.
 */
package emitters;

import com.sun.source.util.DocTreePath;
import emitters.NsVersionAliases;
import emitters.ObjectRegistry;
import emitters.Services;
import emitters.backend.VersionsLoader;
import emitters.javac.Platform;
import emitters.model.MetaVersion;
import emitters.model.Namespace;
import emitters.model.Product;
import emitters.model.ReleaseVersions;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import vmodl.breakingChangesList;
import vmodl.metaVersion;
import vmodl.nsConfig;
import vmodl.nsDescription;
import vmodl.service;
import vmodl.supportsManagedObjectsOf;

public class Versions {
    private static boolean _twoOperationsForTaskMethod = false;
    public static final Comparator<Version> _comparator = new VersionsComparator();
    private static final Map<String, Version> _versions;
    private static final Map<String, Namespace> _namespaces;
    private static final Map<String, MetaVersion> _metaVersions;
    public static final Set<String> _legacyVersionNames;
    private static final Set<String> _legacyWireNs;
    private static final Map<Version, Iterable<String>> _parentsUnresolved;
    private static final Map<MetaVersion, String[]> _metaParentsUnresolved;
    public static final Map<String, String> _onUnspecifiedVersion;
    private static final Map<String, Version> _onUnspecifiedRelease;
    private static String _vmodlNamespace;
    private static MetaVersion _metaVersion;
    private static Version _targetVersion;
    private static Version _oldestSupportedVersion;
    private static List<Version> _versionsList;
    private static NsVersionAliases _nsVersionAliases;
    private static VersionsLoader _versionsLoader;
    private static boolean _allowVisibilityViolations;
    public static final String VMODL_OPTION = "vmodl";
    public static final String COMPAT_FILENAME_OPTION = "compat.filename";

    public static void setBackend(VersionsLoader loader) {
        _versionsLoader = loader;
    }

    public static void init(Map<String, String> options, String verTarget) {
        _versionsLoader.loadClassBasedVersions();
        _versionsLoader.loadNamespaces();
        Version.initRoot();
        Version.setInitialViJsonRelease(Versions.getInitialViJsonRelease());
        Versions.resolveReleasedParents();
        Versions.initMetaVersions();
        Versions.resolveMetaParents();
        Versions.processOptions(options);
        Versions.bridgeVSanDevModel();
        Versions.resolveHeritage();
        Versions.setOldestSupportedVersion();
        Versions.setMetaLegacyVersion();
        Versions.setTargetVersion(verTarget);
        Versions.resolveOnUnspecifiedTagConfig();
        Versions.setReleaseDisplayNames();
    }

    private static String getInitialViJsonRelease() {
        String release2 = null;
        if (Product.products.size() == 1) {
            Product p = Product.products.values().iterator().next();
            for (String release2 : p.getViJsonReleases()) {
            }
        }
        return release2;
    }

    private static void initMetaVersions() {
        for (Namespace ns : _namespaces.values()) {
            MetaVersion metaVersion2 = ns.getMetaVersion();
            if (metaVersion2 == null) continue;
            metaVersion2.init();
            for (Version version : metaVersion2.getSyntheticVersions()) {
                Versions.addVersion(version);
            }
        }
    }

    public static void createNamespace(String name, nsDescription nsDescription2, Product product, String comment, Supplier<DocTreePath> docSupplier) {
        Namespace vmodlNS = new Namespace(name, nsDescription2, product, comment, docSupplier);
        _namespaces.put(name, vmodlNS);
    }

    public static void createVersion(String versionName, String wireNs, String wireId, String displayName, service svc, Iterable<String> parents, supportsManagedObjectsOf supportedMO, Version.Kind kind) {
        Version version = new Version(versionName, svc, kind);
        Versions.addVersion(version);
        version.setWireNs(wireNs);
        if (wireId != null) {
            version.setWireId(wireId);
        }
        if (displayName != null) {
            version.setDisplayName(displayName);
        }
        if (parents != null) {
            Versions.setParents(version, parents);
        }
        if (supportedMO != null) {
            version.setSupportedMO(supportedMO);
        }
        if (_legacyVersionNames.contains(versionName)) {
            Versions.addLegacyVersion(version);
        }
    }

    public static Iterable<String> getVersionPackages() {
        HashSet<String> packageList = new HashSet<String>();
        for (Version version : Versions.getVersions()) {
            String packageName = version.getPackage();
            if (Versions.isVersionsContainer(packageName)) {
                packageName = packageName.substring(0, packageName.lastIndexOf(46));
            }
            packageList.add(packageName);
        }
        return packageList;
    }

    public static boolean isVersionsContainer(String fullName) {
        return fullName.endsWith(".version");
    }

    public static boolean isVersion(String name) {
        return _versions.containsKey(name);
    }

    public static Version getVersion(String name) {
        Version version = _versions.get(name);
        if (version != null) {
            return version;
        }
        if (name != null && name.endsWith("latest.")) {
            Namespace ns = Versions.getNamespace(name.substring(0, name.lastIndexOf(".version")));
            if (ns == null) {
                throw new RuntimeException("ns.version.latest. alias is only available for @nsDescription namespaces");
            }
            return ns.getReleaseVersions().iterator().next().ltsVersion();
        }
        return null;
    }

    public static Namespace getNamespaceCaching(String namespace) {
        if (namespace.isEmpty()) {
            return null;
        }
        Namespace ns = _namespaces.get(namespace);
        if (ns != null) {
            return ns;
        }
        ns = Versions.getNamespaceCaching(namespace.substring(0, namespace.lastIndexOf(46)));
        if (ns != null) {
            _namespaces.put(namespace, ns);
        }
        return ns;
    }

    public static Namespace getNamespace(String name) {
        return _namespaces.get(name);
    }

    public static Collection<Version> getVersions() {
        return _versions.values();
    }

    public static Version getTargetVersion() {
        return _targetVersion;
    }

    public static String getVmodlNamespace() {
        return _vmodlNamespace;
    }

    private static void addVersion(Version version) {
        if (_versions.put(version.getVmodlName(), version) != null) {
            throw new RuntimeException("Version already defined: " + version.getVmodlName());
        }
    }

    public static void createMetaVersion(metaVersion mv, String namespace, breakingChangesList breakingChanges, service svc, Product product) {
        if (product.getFssConfig() == null) {
            throw new RuntimeException("Meta versions require Feature State Information");
        }
        Namespace ns = Versions.getNamespace(namespace);
        if (ns == null) {
            throw new RuntimeException("'" + namespace + "' is NOT annotated with @nsDescription");
        }
        nsConfig nsConfig2 = _versionsLoader.getNsConfigMap().get(namespace);
        MetaVersion metaVersion2 = new MetaVersion(svc, ns, nsConfig2, breakingChanges);
        _metaVersions.put(namespace, metaVersion2);
        ns.setMetaVersion(metaVersion2);
        if (namespace.equals("vim")) {
            _metaVersions.put("hostd", metaVersion2);
        }
        Versions.setMetaParents(metaVersion2, mv.compatible());
    }

    private static void setParents(Version version, Iterable<String> parents) {
        if (_parentsUnresolved.containsKey(version)) {
            throw new RuntimeException(version.getVmodlName() + " parents are already defined");
        }
        _parentsUnresolved.put(version, parents);
    }

    private static void resolveReleasedParents() {
        for (Map.Entry<Version, Iterable<String>> it : _parentsUnresolved.entrySet()) {
            Version version = it.getKey();
            for (String parentName : it.getValue()) {
                Version parent = Versions.getVersion(parentName);
                if (parent == null) {
                    throw new RuntimeException(parentName + " is not a valid version name for " + version.getVmodlName());
                }
                version.addDirectParent(parent);
            }
        }
        _parentsUnresolved.clear();
    }

    private static void setMetaParents(MetaVersion version, String[] nsList) {
        _metaParentsUnresolved.put(version, nsList);
    }

    private static void resolveMetaParents() {
        for (Map.Entry<MetaVersion, String[]> it : _metaParentsUnresolved.entrySet()) {
            MetaVersion metaVersion2 = it.getKey();
            for (String namespace : it.getValue()) {
                MetaVersion metaParent = Versions.getMetaVersion(namespace);
                if (metaParent == null) {
                    throw new RuntimeException("There is no meta-version in namespace " + namespace);
                }
                metaVersion2.addMetaParent(metaParent);
            }
        }
        _metaParentsUnresolved.clear();
    }

    private static void bridgeVSanDevModel() {
        if (_vmodlNamespace == null || !_vmodlNamespace.equals("vsan")) {
            return;
        }
        Version vimDevVersion = Versions.getMetaVersion("vim").getDevVersion();
        Version vsanLatestVersion = Versions.getLatestVersion("vsan");
        vsanLatestVersion.addDirectParent(vimDevVersion);
    }

    private static void resolveHeritage() {
        for (Version version : _versions.values()) {
            version.resolveHeritage();
        }
    }

    public static boolean isAncestor(Version version, Version possibleParent) {
        if (version == possibleParent) {
            return true;
        }
        return version != null && version.isAncestor(possibleParent);
    }

    public static boolean isTargetNewerThan(String versionName) {
        return _targetVersion.isAncestor(Versions.getVersion(versionName));
    }

    public static boolean isTargetNewerThan(Version version) {
        return version != null && _targetVersion.isAncestor(version);
    }

    public static boolean isTargetOlderThan(Version version) {
        return version != null && !_targetVersion.isAncestor(version);
    }

    public static boolean isInternalAtTarget(VmodlApi vmodlApi) {
        return vmodlApi.isInternal() || Versions.isTargetOlderThan(vmodlApi.getInternalBefore());
    }

    public static MetaVersion getMetaVersion(String namespace) {
        int dotPos;
        MetaVersion result = _metaVersions.get(namespace);
        if (result != null) {
            return result;
        }
        String packageName = namespace;
        while ((dotPos = packageName.lastIndexOf(46)) != -1) {
            result = _metaVersions.get(packageName = packageName.substring(0, dotPos));
            if (result == null) continue;
            _metaVersions.put(namespace, result);
            return result;
        }
        return null;
    }

    public static Iterable<MetaVersion> getMetaVersions() {
        return _metaVersions.values();
    }

    public static Set<Version> getSortedDirectParents(Version version) {
        TreeSet<Version> result = new TreeSet<Version>(_comparator);
        result.addAll(version.getDirectParents());
        return result;
    }

    private static void addLegacyVersion(Version version) {
        String wireNs = version.getWireNs();
        if (wireNs == null) {
            throw new RuntimeException("Wire NS required for legacy " + version.getVmodlName());
        }
        if (!_legacyWireNs.add(wireNs)) {
            throw new RuntimeException("Duplicate legacy versions for wire ns: " + wireNs);
        }
        version.setIsLegacy();
    }

    public static boolean haveLegacyVersions() {
        return !_legacyWireNs.isEmpty();
    }

    public static boolean hasLegacyChild(Version version) {
        for (Version childVersion : version.getAllChildren()) {
            if (!childVersion.isLegacy()) continue;
            return true;
        }
        return version.isLegacy();
    }

    private static void processOptions(Map<String, String> options) {
        _vmodlNamespace = options.get(VMODL_OPTION);
        if (_vmodlNamespace != null) {
            if (_vmodlNamespace.equals("hostd")) {
                _vmodlNamespace = "vim";
            }
            _metaVersion = Versions.getMetaVersion(_vmodlNamespace);
        }
    }

    private static void setOldestSupportedVersion() {
        if (_oldestSupportedVersion != null || _metaVersion == null) {
            return;
        }
        Version hierarchyOldest = Versions.discoverOldestSupportedVersion(_metaVersion);
        if (hierarchyOldest == null) {
            return;
        }
        if (hierarchyOldest.getWireNs().equals(_metaVersion.getWireNs())) {
            _oldestSupportedVersion = hierarchyOldest;
            return;
        }
        Version lastKnownAncestor = null;
        for (Version latest = _metaVersion.getLatestLtsVersion(); latest != null && latest.isAncestor(hierarchyOldest); latest = latest.getNsLtsParent()) {
            lastKnownAncestor = latest;
        }
        if (lastKnownAncestor != null) {
            _oldestSupportedVersion = lastKnownAncestor;
        }
    }

    private static Version getRelConfig(MetaVersion metaVersion2, String releaseName, String versionName, String description) {
        if (releaseName.isEmpty() && versionName.isEmpty()) {
            return null;
        }
        Namespace namespace = metaVersion2.getNamespace();
        if (!releaseName.isEmpty() && !versionName.isEmpty()) {
            throw new RuntimeException("Either a version or a release may set as " + description + " for VMODL namespace " + namespace.getName());
        }
        if (!releaseName.isEmpty()) {
            Version ltsVersion = namespace.getLtsVersion(releaseName);
            if (ltsVersion != null) {
                return ltsVersion;
            }
            throw new RuntimeException("There is no LTS version in release " + releaseName + " of VMODL namespace " + namespace.getName());
        }
        Version result = Versions.getVersion(versionName);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Invalid " + description + " version: " + versionName);
    }

    private static Version discoverOldestSupportedVersion(MetaVersion metaVersion2) {
        Version version;
        nsConfig nsConfig2 = metaVersion2.getNsConfig();
        if (nsConfig2 != null && (version = Versions.getRelConfig(metaVersion2, nsConfig2.oldestSupportedRelease(), nsConfig2.oldestSupported(), "oldest")) != null) {
            return version;
        }
        for (MetaVersion parentMetaVersion : metaVersion2.getMetaParents()) {
            Version result = Versions.discoverOldestSupportedVersion(parentMetaVersion);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static void setMetaLegacyVersion() {
        if (_metaVersion == null) {
            return;
        }
        nsConfig nsConfig2 = _metaVersion.getNsConfig();
        if (nsConfig2 == null) {
            return;
        }
        Version version = Versions.getRelConfig(_metaVersion, nsConfig2.legacyRelease(), nsConfig2.legacyVersion(), "legacy");
        if (version != null) {
            Versions.addLegacyVersion(version);
        }
    }

    private static void setTargetVersion(String verTarget) {
        if (verTarget != null) {
            if (_metaVersion != null) {
                throw new RuntimeException("Legacy target version option is incompatible with the modern VMODL development model");
            }
            _targetVersion = Versions.getVersion(verTarget);
            if (_targetVersion == null) {
                throw new RuntimeException("Invalid target version name: " + verTarget);
            }
            _vmodlNamespace = _targetVersion.getNamespace();
        } else {
            if (_vmodlNamespace == null || _vmodlNamespace.isEmpty()) {
                throw new RuntimeException("Missing target VMODL version or namespace");
            }
            _targetVersion = _metaVersion != null ? _metaVersion.getDisabledVersion() : Versions.getLatestVersion(_vmodlNamespace);
        }
        Versions.initVersionsList();
    }

    private static void resolveOnUnspecifiedTagConfig() {
        String ns;
        _onUnspecifiedVersion.put(VMODL_OPTION, "vmodl.version.version0");
        for (Map.Entry<String, nsConfig> entry : _versionsLoader.getNsConfigMap().entrySet()) {
            ns = entry.getKey();
            if (_onUnspecifiedVersion.containsKey(ns)) continue;
            nsConfig nsConfig2 = entry.getValue();
            String releaseName = nsConfig2.onUnspecifiedRelease();
            String versionName = nsConfig2.onUnspecifiedVersion();
            if (!releaseName.isEmpty() && !versionName.isEmpty()) {
                throw new RuntimeException("Only one onUnspecified* should be set for " + ns);
            }
            if (!releaseName.isEmpty()) {
                Namespace namespace = _namespaces.get(ns);
                if (namespace == null) {
                    throw new RuntimeException("No namespace description for " + ns);
                }
                Version ltsVersion = namespace.getLtsVersion(releaseName);
                if (ltsVersion == null) {
                    throw new RuntimeException("No LTS version for " + releaseName + " in " + ns);
                }
                _onUnspecifiedRelease.put(ns + ".", ltsVersion);
            }
            if (versionName.isEmpty()) continue;
            _onUnspecifiedVersion.put(ns, versionName);
        }
        for (Map.Entry<String, Object> entry : _onUnspecifiedVersion.entrySet()) {
            ns = entry.getKey();
            String versionName = (String)entry.getValue();
            Version version = Versions.getVersion(versionName);
            if (version == null) {
                throw new RuntimeException("Version " + versionName + " is unknown in " + ns);
            }
            _onUnspecifiedRelease.put(ns + ".", version);
        }
        Versions.addOnUnspecifiedVersionIfExists("vmodl.query", "vmodl.query.version.version1");
        Versions.addOnUnspecifiedVersionIfExists("vmodl.reflect", "vmodl.reflect.version.version1");
    }

    private static void addOnUnspecifiedVersionIfExists(String namespace, String versionName) {
        Version version = Versions.getVersion(versionName);
        if (version != null) {
            _onUnspecifiedVersion.put(namespace, versionName);
            _onUnspecifiedRelease.put(namespace, version);
        }
    }

    private static void setReleaseDisplayNames() {
        Map<String, nsConfig> nsConfigMap = _versionsLoader.getNsConfigMap();
        block0: for (Namespace ns : _namespaces.values()) {
            String releaseNamePrefix = ns.getReleaseNamePrefix();
            if (releaseNamePrefix.isEmpty()) continue;
            nsConfig nsConfig2 = nsConfigMap.get(ns.getName());
            String oldestSupportedRelease = nsConfig2 == null ? null : nsConfig2.oldestSupportedRelease();
            for (ReleaseVersions rv : ns.getReleaseVersions()) {
                Version ltsVersion = rv.ltsVersion();
                if (ltsVersion.getDisplayName() == null) {
                    ltsVersion.setDisplayName(releaseNamePrefix + rv.id());
                }
                if (!rv.id().equals(oldestSupportedRelease)) continue;
                continue block0;
            }
        }
    }

    public static void moveToDevVersion() {
        if (_metaVersion != null) {
            _targetVersion = _metaVersion.getDevVersion();
            Versions.initVersionsList();
        }
    }

    public static void moveToLtsVersion() {
        if (_metaVersion != null) {
            _targetVersion = _metaVersion.getLatestLtsVersion();
            Versions.initVersionsList();
        }
    }

    private static Version getLatestVersion(String namespace) {
        String prefix = namespace + ".";
        HashSet<Version> candidateVersions = new HashSet<Version>();
        HashSet<Version> nonLatestVersions = new HashSet<Version>();
        for (Map.Entry<String, Version> entry : _versions.entrySet()) {
            Version version;
            String name = entry.getKey();
            if (!name.startsWith(prefix) || !namespace.equals((version = entry.getValue()).getNamespace()) || version.getKind() != Version.Kind.LTS) continue;
            Version parent = version.getNsLtsParent();
            if (parent != null) {
                nonLatestVersions.add(parent);
                candidateVersions.remove(parent);
            }
            if (nonLatestVersions.contains(version)) continue;
            candidateVersions.add(version);
        }
        if (candidateVersions.size() > 1) {
            StringBuilder sb = new StringBuilder("Multiple latest versions in the same namespace:");
            for (Version version : candidateVersions) {
                sb.append(' ');
                sb.append(version.getVmodlName());
            }
            throw new RuntimeException(sb.toString());
        }
        return (Version)candidateVersions.iterator().next();
    }

    public static List<Version> enumerateVersions() {
        return _versionsList;
    }

    private static void initVersionsList() {
        _versionsList = new ArrayList<Version>();
        if (_metaVersion != null) {
            Versions.createMetaVersionsList();
        } else {
            Namespace namespace = Versions.getNamespace(_vmodlNamespace);
            if (namespace != null) {
                Versions.createNamespaceVersionsList(namespace);
            } else {
                Versions.createLegacyVersionsList();
            }
        }
        _nsVersionAliases = new NsVersionAliases();
    }

    private static void createMetaVersionsList() {
        switch (_targetVersion.getKind()) {
            case DISABLED: 
            case DEV: {
                if (!Platform.builtOnMain()) break;
                _versionsList.add(_metaVersion.getDevVersion());
            }
        }
        Versions.createNamespaceVersionsList(_metaVersion.getNamespace());
    }

    private static void createNamespaceVersionsList(Namespace ns) {
        for (ReleaseVersions rv : ns.getReleaseVersions()) {
            Version ltsVersion = rv.ltsVersion();
            if (_targetVersion.isAncestor(ltsVersion)) {
                _versionsList.add(ltsVersion);
            }
            if (_oldestSupportedVersion == null || ltsVersion != _oldestSupportedVersion) continue;
            break;
        }
    }

    private static void createLegacyVersionsList() {
        for (Version version = _targetVersion; version != null; version = version.getNsLtsParent()) {
            _versionsList.add(version);
            if (version == _oldestSupportedVersion) break;
        }
    }

    public static NsVersionAliases getNsVersionAliases() {
        return _nsVersionAliases;
    }

    public static Version onUnspecifiedReleaseTag(String typeName) {
        for (Map.Entry<String, Version> entry : _onUnspecifiedRelease.entrySet()) {
            if (!typeName.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        throw new RuntimeException("No versioning info for " + typeName);
    }

    public static boolean getTwoOperationsForTaskMethod() {
        return _twoOperationsForTaskMethod;
    }

    public static void setTwoOperationsForTaskMethod(boolean b) {
        _twoOperationsForTaskMethod = b;
    }

    public static void initSyntheticVersions() {
        for (MetaVersion metaVersion2 : _metaVersions.values()) {
            metaVersion2.initSyntheticVersions();
        }
        ArrayList<VmodlObject> objects = new ArrayList<VmodlObject>(ObjectRegistry.getAllObjects());
        objects.sort(null);
        for (VmodlObject object : objects) {
            object.enqueueDigest();
        }
        for (MetaVersion metaVersion3 : _metaVersions.values()) {
            metaVersion3.sealSyntheticVersions();
        }
    }

    public static NavigableSet<Version> getVersionsOrderedByAncestry(String namespace) {
        TreeSet<Version> versionSet = new TreeSet<Version>(_comparator);
        for (Version version : Versions.getVersions()) {
            if (namespace != null && !version.getNamespace().equals(namespace) || Services.schemaNamespaceId(version) == null) continue;
            versionSet.add(version);
        }
        return versionSet;
    }

    public static void reportVisibilityViolation(String message) {
        if (!_allowVisibilityViolations) {
            throw new RuntimeException(message);
        }
    }

    public static void allowVisibilityViolations() {
        _allowVisibilityViolations = true;
    }

    public static void disallowVisibilityViolations() {
        _allowVisibilityViolations = false;
    }

    static {
        _onUnspecifiedVersion = new TreeMap(Collections.reverseOrder());
        _onUnspecifiedRelease = new TreeMap(Collections.reverseOrder());
        _versions = new HashMap<String, Version>();
        _namespaces = new HashMap<String, Namespace>();
        _metaVersions = new HashMap<String, MetaVersion>();
        _legacyVersionNames = new HashSet<String>();
        _legacyWireNs = new HashSet<String>();
        _parentsUnresolved = new HashMap<Version, Iterable<String>>();
        _metaParentsUnresolved = new HashMap<MetaVersion, String[]>();
        _nsVersionAliases = null;
        _allowVisibilityViolations = true;
    }

    public static class VersionsComparator
    implements Comparator<Version> {
        @Override
        public int compare(Version v1, Version v2) {
            if (v1.isSameNamespace(v2)) {
                return VersionsComparator.isAncestorDisjoint(v1, v2);
            }
            return v1.getVmodlName().compareTo(v2.getVmodlName());
        }

        private static int isAncestorDisjoint(Version v1, Version v2) {
            Version v2Base;
            if (v1.isAncestor(v2)) {
                return 1;
            }
            if (v2.isAncestor(v1)) {
                return -1;
            }
            Version v1Base = VersionsComparator.getLtsBase(v1);
            if (v1Base == (v2Base = VersionsComparator.getLtsBase(v2))) {
                return v1.getVmodlName().compareTo(v2.getVmodlName());
            }
            return v1Base.isAncestor(v2Base) ? 1 : -1;
        }

        private static Version getLtsBase(Version version) {
            return version.getKind() == Version.Kind.LTS ? version : version.getNsLtsParent();
        }
    }
}

