/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.go;

import emitters.ObjectRegistry;
import emitters.VmodlEmitter;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.time.Year;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class GoEmitter
extends VmodlEmitter {
    private final String _baseDir;
    private final String _namespace;
    private final boolean _emitInternal;
    private final HashSet<String> _localTypes = new HashSet();
    private final HashSet<String> _polymorphicTypes = new HashSet();
    private final ArrayList<Binding> _dataObjects = new ArrayList();
    private final ArrayList<Binding> _managedObjects = new ArrayList();
    private final ArrayList<Binding> _enums = new ArrayList();
    private final ArrayList<Binding> _extraBaseTypes = new ArrayList();
    private static final String[] COPYRIGHT_MESSAGE = new String[]{"/*", "Copyright (c) " + Year.now() + " VMware, Inc. All Rights Reserved.", "Licensed under the Apache License, Version 2.0 (the \"License\");", "you may not use this file except in compliance with the License.", "You may obtain a copy of the License at", "    http://www.apache.org/licenses/LICENSE-2.0", "Unless required by applicable law or agreed to in writing, software", "distributed under the License is distributed on an \"AS IS\" BASIS,", "WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.", "See the License for the specific language governing permissions and", "limitations under the License.", "*/", ""};

    private boolean isLocal(String name) {
        return this._localTypes.contains(name);
    }

    private boolean isPolymorphic(String name) {
        return this._polymorphicTypes.contains(name);
    }

    public GoEmitter(Map<String, String> options, String basePath) {
        String emitInternal;
        this._baseDir = basePath;
        this._namespace = options.get("namespace");
        this._emitInternal = options.containsKey("internal") ? ((emitInternal = options.get("internal")) != null ? Boolean.parseBoolean(emitInternal) : true) : false;
        String extraBaseTypes = options.get("extrabasetypes");
        if (extraBaseTypes != null) {
            for (String extraBaseType : extraBaseTypes.split(",", 0)) {
                DataObject dObj = (DataObject)ObjectRegistry.getObject(extraBaseType = extraBaseType.trim());
                if (dObj == null) {
                    throw new RuntimeException("Data type not found: " + extraBaseType);
                }
                this._localTypes.add(dObj.getWsdlName());
                this._polymorphicTypes.add(dObj.getWsdlName());
                this._extraBaseTypes.add(new DataObjectBinding(dObj, true));
            }
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.preprocessTypeInfo(objects);
        this.emitTypes();
        this.emitInterfaces();
        this.emitEnums();
        this.emitManagedObjects();
        this.emitMethods();
    }

    private void preprocessTypeInfo(List<VmodlObject> objects) {
        this._localTypes.add("void");
        this._localTypes.add("bool");
        this._localTypes.add("byte");
        this._localTypes.add("int16");
        this._localTypes.add("int32");
        this._localTypes.add("int64");
        this._localTypes.add("float32");
        this._localTypes.add("float64");
        this._localTypes.add("time.Time");
        this._localTypes.add("string");
        for (VmodlObject obj : objects) {
            if (obj.getKind() != VmodlObject.Kind.DataObject && obj.getKind() != VmodlObject.Kind.ManagedObject) continue;
            this._localTypes.add(obj.getWsdlName());
            this._polymorphicTypes.add(obj.getBaseObject().getWsdlName());
        }
        this._polymorphicTypes.add("MethodFault");
        for (VmodlObject obj : objects) {
            if (obj.isInternal() && !this._emitInternal || obj.getVersion().getKind() == Version.Kind.DEV || obj.getVersion().getKind() == Version.Kind.DISABLED) continue;
            switch (obj.getKind()) {
                case DataObject: {
                    this._dataObjects.add(new DataObjectBinding((DataObject)obj, false));
                    break;
                }
                case ManagedObject: {
                    this._managedObjects.add(new ManagedObjectBinding((ManagedObject)obj));
                    break;
                }
                case Enum: {
                    this._enums.add(new EnumBinding((Enum)obj));
                }
            }
            this.preprocessTypeInfo(new ArrayList<VmodlObject>(obj.getNestedList()));
        }
    }

    private void emitTypes() {
        String[] imports = new String[]{"reflect", "time", "", "github.com/vmware/govmomi/vim25/types"};
        try (OutputFile f = new OutputFile("types/types.go", "types", imports);){
            Stream.concat(this._managedObjects.stream(), this._dataObjects.stream()).forEach(b -> {
                b.emitTypes();
                this.emitGap();
            });
        }
    }

    private void emitInterfaces() {
        String[] imports = new String[]{"github.com/vmware/govmomi/vim25/types"};
        try (OutputFile f = new OutputFile("types/if.go", "types", imports);){
            for (Binding b : this._extraBaseTypes) {
                b.emitInterfaces();
            }
            for (Binding b : this._dataObjects) {
                b.emitInterfaces();
            }
        }
    }

    private void emitEnums() {
        String[] imports = new String[]{"reflect", "", "github.com/vmware/govmomi/vim25/types"};
        try (OutputFile f = new OutputFile("types/enum.go", "types", imports);){
            for (Binding b : this._enums) {
                b.emitEnums();
            }
        }
    }

    private void emitManagedObjects() {
        String[] imports = new String[]{"reflect", "", "github.com/vmware/govmomi/vim25/types"};
        try (OutputFile f = new OutputFile("mo/mo.go", "types", imports);){
            for (Binding b : this._managedObjects) {
                b.emitManagedObjects();
            }
        }
    }

    private void emitMethods() {
        String[] imports = new String[]{"context", "", "github.com/vmware/govmomi/vim25/soap", "github.com/vmware/govmomi/" + this._namespace + "/types"};
        try (OutputFile f = new OutputFile("methods/methods.go", "methods", imports);){
            for (Binding b : this._managedObjects) {
                b.emitMethods();
            }
        }
    }

    private class EnumBinding
    extends Binding {
        private TypeAlias _alias;
        private EnumConstants _constants;
        private TypeInfoInit _aliasTypeInfo;

        public EnumBinding(Enum e) {
            super(e);
            this._alias = new TypeAlias(e.getWsdlName(), "string");
            this._constants = new EnumConstants(e);
            this._aliasTypeInfo = new TypeInfoInit(e.getWsdlName());
        }

        @Override
        public void emitEnums() {
            GoEmitter.this.emitGap();
            this._alias.emit();
            GoEmitter.this.emitGap();
            this._constants.emit();
            GoEmitter.this.emitGap();
            this._aliasTypeInfo.emit();
        }
    }

    private class ManagedObjectBinding
    extends Binding {
        private final ArrayList<MethodBinding> _methods;
        private final Struct _moStruct;
        private final ReferenceMethod _moReferenceMethod;
        private final TypeInfoInit _moStructTypeInfo;

        public ManagedObjectBinding(ManagedObject mObj) {
            super(mObj);
            this._methods = new ArrayList(mObj.getMethodList().size());
            for (Method method : mObj.getMethodList()) {
                if (method.isInternal() && !GoEmitter.this._emitInternal || method.getVersion().getKind() == Version.Kind.DEV || method.getVersion().getKind() == Version.Kind.DISABLED) continue;
                this._methods.add(new MethodBinding(method));
            }
            this._moStruct = new Struct(this.getWsdlName());
            this._moStruct.addField(new StructField(new SelfFieldInfo()));
            this._moReferenceMethod = new ReferenceMethod(mObj);
            this._moStructTypeInfo = new TypeInfoInit(this.getWsdlName());
        }

        @Override
        public void emitTypes() {
            boolean isFirst = true;
            for (MethodBinding method : this._methods) {
                if (!isFirst) {
                    GoEmitter.this.emitGap();
                }
                isFirst = false;
                method.emitTypes();
            }
        }

        @Override
        public void emitManagedObjects() {
            GoEmitter.this.emitGap();
            this._moStruct.emit();
            GoEmitter.this.emitGap();
            this._moReferenceMethod.emit();
            GoEmitter.this.emitGap();
            this._moStructTypeInfo.emit();
        }

        @Override
        public void emitMethods() {
            for (MethodBinding method : this._methods) {
                method.emitMethods();
            }
        }
    }

    private class MethodBinding
    extends Binding {
        private final TypeAlias _requestTypeAlias;
        private final TypeInfoInit _aliasTypeInfo;
        private final Struct _requestStruct;
        private final TypeInfoInit _requestStrucTypeInfo;
        private final Struct _responseStruct;
        private final Struct _bodyStruct;
        private final FaultAccessor _faultAccessor;
        private final MethodInvoker _methodInvoker;

        public MethodBinding(Method method) {
            super(method);
            String name = method.getWsdlName();
            String requestTypeName = name + "RequestType";
            this._requestTypeAlias = new TypeAlias(name, requestTypeName);
            this._aliasTypeInfo = new TypeInfoInit(name);
            this._requestStruct = new Struct(requestTypeName);
            this._requestStruct.addField(new StructField(new ThisFieldInfo()));
            for (Parameter p : method.getParameterList()) {
                if (p.getVersion().getKind() == Version.Kind.DEV || p.getVersion().getKind() == Version.Kind.DISABLED) continue;
                this._requestStruct.addField(new StructField(new RequestFieldInfo(p)));
            }
            this._requestStrucTypeInfo = new TypeInfoInit(requestTypeName);
            this._responseStruct = new Struct(name + "Response");
            if (!method.getReturnDecl().isVoid()) {
                this._responseStruct.addField(new StructField(new ResultFieldInfo(method)));
            }
            String namespaceUrn = GoEmitter.this._namespace != null ? "urn:" + GoEmitter.this._namespace + " " : "";
            String reqAnnotation = "`xml:\"" + namespaceUrn + name + ",omitempty\"`";
            String resAnnotation = "`xml:\"" + namespaceUrn + name + "Response,omitempty\"`";
            String faultAnnotation = "`xml:\"http://schemas.xmlsoap.org/soap/envelope/ Fault,omitempty\"`";
            this._bodyStruct = new Struct(name + "Body");
            this._bodyStruct.addField(new StructField(new FieldInfo("Req", "*types." + name, reqAnnotation)));
            this._bodyStruct.addField(new StructField(new FieldInfo("Res", "*types." + name + "Response", resAnnotation)));
            this._bodyStruct.addField(new StructField(new FieldInfo("Fault_", "*soap.Fault", faultAnnotation)));
            this._faultAccessor = new FaultAccessor(method);
            this._methodInvoker = new MethodInvoker(method);
        }

        @Override
        public void emitTypes() {
            this._requestTypeAlias.emit();
            GoEmitter.this.emitGap();
            this._aliasTypeInfo.emit();
            GoEmitter.this.emitGap();
            this._requestStruct.emit();
            GoEmitter.this.emitGap();
            this._requestStrucTypeInfo.emit();
            GoEmitter.this.emitGap();
            this._responseStruct.emit();
        }

        @Override
        public void emitMethods() {
            GoEmitter.this.emitGap();
            this._bodyStruct.emit();
            GoEmitter.this.emitGap();
            this._faultAccessor.emit();
            GoEmitter.this.emitGap();
            this._methodInvoker.emit();
        }
    }

    private class DataObjectBinding
    extends Binding {
        private final Struct _struct;
        private final TypeInfoInit _structTypeInfo;
        private final TypeAlias _externalTypeAlias;
        private final BaseInterface _baseIf;

        public DataObjectBinding(DataObject dObj, boolean isExternal) {
            super(dObj);
            VmodlObject baseObj = dObj.getBaseObject();
            if (baseObj != null) {
                String baseType = baseObj.getWsdlName();
                if (!GoEmitter.this.isLocal(baseType)) {
                    baseType = "types." + baseType;
                }
                this._struct = new Struct(dObj.getWsdlName(), baseType);
            } else {
                this._struct = new Struct(dObj.getWsdlName());
            }
            for (Property prop : dObj.getPropertyList()) {
                this._struct.addField(new StructField(new DataFieldInfo(prop)));
            }
            this._structTypeInfo = new TypeInfoInit(dObj.getWsdlName());
            if (GoEmitter.this.isPolymorphic(this.getWsdlName())) {
                this._externalTypeAlias = isExternal ? new TypeAlias(this.getWsdlName(), "types." + this.getWsdlName()) : null;
                this._baseIf = new BaseInterface(dObj);
            } else {
                this._baseIf = null;
                this._externalTypeAlias = null;
            }
        }

        @Override
        public void emitTypes() {
            this._struct.emit();
            GoEmitter.this.emitGap();
            this._structTypeInfo.emit();
        }

        @Override
        public void emitInterfaces() {
            if (this._externalTypeAlias != null) {
                GoEmitter.this.emitGap();
                this._externalTypeAlias.emit();
            }
            if (this._baseIf != null) {
                GoEmitter.this.emitGap();
                this._baseIf.emit();
            }
        }
    }

    private class Binding {
        private final String _name;
        private final String _wsdlName;
        private final Version _version;

        public Binding(VmodlApi obj) {
            this._name = obj.getName();
            this._wsdlName = obj.getWsdlName();
            this._version = obj.getVersion();
        }

        public void emitTypes() {
        }

        public void emitInterfaces() {
        }

        public void emitEnums() {
        }

        public void emitManagedObjects() {
        }

        public void emitMethods() {
        }

        public String getName() {
            return this._name;
        }

        public String getWsdlName() {
            return this._wsdlName;
        }

        public Version getVersion() {
            return this._version;
        }
    }

    class EnumConstants
    implements Declaration {
        private String _enumType;
        private List<String> _values;

        public EnumConstants(Enum e) {
            this._enumType = e.getWsdlName();
            this._values = e.getValueList();
        }

        @Override
        public void emit() {
            GoEmitter.this.emitLine("const (");
            GoEmitter.this.indent();
            for (String val : this._values) {
                this.emitValue(val);
            }
            GoEmitter.this.unindent();
            GoEmitter.this.emitLine(")");
        }

        private void emitValue(String val) {
            GoEmitter.this.emitLine(new String[]{this._enumType, val, " = ", this._enumType, "(\"", val, "\")"});
        }
    }

    class MethodInvoker
    implements Declaration {
        private final String _name;

        public MethodInvoker(Method method) {
            this._name = method.getWsdlName();
        }

        @Override
        public void emit() {
            GoEmitter.this.emitGap();
            GoEmitter.this.emitLine(new String[]{"func ", this._name, "(ctx context.Context, r soap.RoundTripper,", " req *types.", this._name, ") (*types.", this._name, "Response, error) {"});
            GoEmitter.this.indent();
            GoEmitter.this.emitLine(new String[]{"var reqBody, resBody ", this._name, "Body"});
            GoEmitter.this.emitGap();
            GoEmitter.this.emitLine("reqBody.Req = req");
            GoEmitter.this.emitGap();
            GoEmitter.this.emitLine("if err := r.RoundTrip(ctx, &reqBody, &resBody); err != nil {");
            GoEmitter.this.indent();
            GoEmitter.this.emitLine("return nil, err");
            GoEmitter.this.unindent();
            GoEmitter.this.emitLine("}");
            GoEmitter.this.emitGap();
            GoEmitter.this.emitLine("return resBody.Res, nil");
            GoEmitter.this.unindent();
            GoEmitter.this.emitLine("}");
        }
    }

    class FaultAccessor
    implements Declaration {
        private final String _name;

        public FaultAccessor(Method method) {
            this._name = method.getWsdlName();
        }

        @Override
        public void emit() {
            GoEmitter.this.emitGap();
            GoEmitter.this.emitLine(new String[]{"func (b *", this._name, "Body) Fault() *soap.Fault ", "{ return b.Fault_ }"});
        }
    }

    class ReferenceMethod
    implements Declaration {
        private final String _name;

        public ReferenceMethod(ManagedObject mObj) {
            this._name = mObj.getWsdlName();
        }

        @Override
        public void emit() {
            GoEmitter.this.emitLine(new String[]{"func (m ", this._name, ") Reference() types.ManagedObjectReference {"});
            GoEmitter.this.indent();
            GoEmitter.this.emitLine("return m.Self");
            GoEmitter.this.unindent();
            GoEmitter.this.emitLine("}");
        }
    }

    class BaseInterface
    implements Declaration {
        private final String _name;

        public BaseInterface(DataObject dObj) {
            this._name = dObj.getWsdlName();
        }

        @Override
        public void emit() {
            GoEmitter.this.emitLine(new String[]{"func (b *", this._name, ") Get", this._name, "() *", this._name, " { return b }"});
            GoEmitter.this.emitGap();
            GoEmitter.this.emitLine(new String[]{"type Base", this._name, " interface {"});
            GoEmitter.this.indent();
            GoEmitter.this.emitLine(new String[]{"Get", this._name, "() *", this._name});
            GoEmitter.this.unindent();
            GoEmitter.this.emitLine("}");
        }
    }

    private class Struct
    implements Declaration {
        private final String _name;
        private final String _baseType;
        private final ArrayList<StructField> _fields = new ArrayList();

        public Struct(String name) {
            this._name = name;
            this._baseType = null;
        }

        public Struct(String name, String baseType) {
            this._name = name;
            this._baseType = baseType;
        }

        void addField(StructField field) {
            this._fields.add(field);
        }

        @Override
        public void emit() {
            GoEmitter.this.emitLine(new String[]{"type ", this._name, " struct {"});
            GoEmitter.this.indent();
            if (this._baseType != null) {
                GoEmitter.this.emitLine(this._baseType);
                GoEmitter.this.emitGap();
            }
            for (StructField field : this._fields) {
                field.emit();
            }
            GoEmitter.this.unindent();
            GoEmitter.this.emitLine("}");
        }
    }

    class StructField
    implements Declaration {
        private String _name;
        private String _type;
        private String _annotation;

        protected StructField(FieldInfo fieldInfo) {
            this._name = fieldInfo.getName();
            this._type = fieldInfo.getTypeName();
            this._annotation = fieldInfo.getAnnotation();
        }

        @Override
        public void emit() {
            GoEmitter.this.emitLine(new String[]{this._name, " ", this._type, " ", this._annotation});
        }
    }

    private class TypeInfoInit
    implements Declaration {
        private final String _name;

        public TypeInfoInit(String name) {
            this._name = name;
        }

        @Override
        public void emit() {
            String namespacePrefix = GoEmitter.this._namespace != null ? GoEmitter.this._namespace + ":" : "";
            GoEmitter.this.emitLine("func init() {");
            GoEmitter.this.indent();
            GoEmitter.this.emitLine(new String[]{"types.Add(\"", namespacePrefix, this._name, "\", reflect.TypeOf((*", this._name, ")(nil)).Elem())"});
            GoEmitter.this.unindent();
            GoEmitter.this.emitLine("}");
        }
    }

    private class TypeAlias
    implements Declaration {
        private final String _alias;
        private final String _name;

        public TypeAlias(String alias, String name) {
            this._alias = alias;
            this._name = name;
        }

        @Override
        public void emit() {
            GoEmitter.this.emitLine(new String[]{"type ", this._alias, " ", this._name});
        }
    }

    private static interface Declaration {
        public void emit();
    }

    class SelfFieldInfo
    extends FieldInfo {
        public SelfFieldInfo() {
            super("Self", "types.ManagedObjectReference", "");
        }
    }

    class ThisFieldInfo
    extends FieldInfo {
        public ThisFieldInfo() {
            super("This", "types.ManagedObjectReference", "`xml:\"_this\"`");
        }
    }

    class RequestFieldInfo
    extends FieldInfo {
        public RequestFieldInfo(Parameter param) {
            super(param.getName(), param.getName(), param.getDecl());
        }

        @Override
        boolean hasTypeAttr(String baseTypeName, VmodlDecl decl, boolean isArray, boolean isBase) {
            return false;
        }

        @Override
        boolean hasOmitEmpty(String baseTypeName, VmodlDecl decl, boolean isArray, boolean isBase) {
            boolean isOmitEmpty = false;
            if (isArray || !decl.isBoolean() && decl.getTypeId() != VmodlDecl.TypeId.DATETIME) {
                isOmitEmpty = decl.isOptional();
            }
            return isOmitEmpty;
        }
    }

    class ResultFieldInfo
    extends FieldInfo {
        public ResultFieldInfo(Method method) {
            super("Returnval", "returnval", method.getReturnDecl());
        }

        @Override
        boolean hasTypeAttr(String baseTypeName, VmodlDecl decl, boolean isArray, boolean isBase) {
            boolean hasTypeAttr = isBase;
            return hasTypeAttr;
        }

        @Override
        boolean hasOmitEmpty(String baseTypeName, VmodlDecl decl, boolean isArray, boolean isBase) {
            boolean isOmitEmpty = false;
            if (isArray) {
                isOmitEmpty = true;
            } else if (decl.isData() && !isBase || decl.isManaged() || decl.isBoolean() || decl.getTypeId() == VmodlDecl.TypeId.DATETIME) {
                isOmitEmpty = decl.isOptional();
            }
            return isOmitEmpty;
        }
    }

    class DataFieldInfo
    extends FieldInfo {
        public DataFieldInfo(Property prop) {
            super(prop.getName(), prop.getName(), prop.getDecl());
        }

        @Override
        boolean hasTypeAttr(String baseTypeName, VmodlDecl decl, boolean isArray, boolean isBase) {
            boolean hasTypeAttr = isBase;
            if (decl.getTypeId() == VmodlDecl.TypeId.MANAGED) {
                if (decl.getObject() == null) {
                    hasTypeAttr = true;
                } else if (!decl.getObject().getDescendents().isEmpty() && !GoEmitter.this.isLocal(decl.getObject().getWsdlName())) {
                    hasTypeAttr = true;
                }
            }
            return hasTypeAttr;
        }

        @Override
        boolean hasOmitEmpty(String baseTypeName, VmodlDecl decl, boolean isArray, boolean isBase) {
            boolean isOmitEmpty = false;
            if (isArray || !decl.isBoolean() && decl.getTypeId() != VmodlDecl.TypeId.DATETIME) {
                isOmitEmpty = decl.isOptional();
            }
            return isOmitEmpty;
        }
    }

    private class FieldInfo {
        protected String _name;
        protected String _typeName;
        protected String _annotation;

        protected String getBaseTypeName(VmodlDecl decl) {
            String typeName;
            switch (decl.getTypeId()) {
                case VOID: {
                    typeName = "void";
                    break;
                }
                case BOOLEAN: {
                    typeName = "bool";
                    break;
                }
                case BYTE: 
                case BINARY: {
                    typeName = "byte";
                    break;
                }
                case SHORT: {
                    typeName = "int16";
                    break;
                }
                case INT: {
                    typeName = "int32";
                    break;
                }
                case LONG: {
                    typeName = "int64";
                    break;
                }
                case FLOAT: {
                    typeName = "float32";
                    break;
                }
                case DOUBLE: {
                    typeName = "float64";
                    break;
                }
                case DATETIME: {
                    typeName = "time.Time";
                    break;
                }
                case STRING: 
                case TYPENAME: 
                case METHODNAME: 
                case PROPPATH: 
                case URI: {
                    typeName = "string";
                    break;
                }
                case MANAGED: {
                    if (decl.getObject() != null && GoEmitter.this.isLocal(decl.getObject().getWsdlName())) {
                        typeName = decl.getObject().getWsdlName();
                        break;
                    }
                    typeName = "ManagedObjectReference";
                    break;
                }
                case DATA: {
                    typeName = decl.getObject().getWsdlName();
                    break;
                }
                case ANY: {
                    typeName = "AnyType";
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid type");
                }
            }
            return typeName;
        }

        protected boolean isPointer(VmodlDecl decl) {
            if (!decl.isOptional() || decl.isArray()) {
                return false;
            }
            switch (decl.getTypeId()) {
                case BOOLEAN: 
                case DATETIME: 
                case MANAGED: 
                case DATA: {
                    return true;
                }
            }
            return false;
        }

        protected boolean isBase(String baseTypeName, VmodlDecl decl) {
            if (decl.getObject() == null || decl.getObject().getDescendents().isEmpty()) {
                return false;
            }
            return !baseTypeName.equals("ManagedObjectReference") && !baseTypeName.equals("KeyValue");
        }

        boolean hasTypeAttr(String baseTypeName, VmodlDecl decl, boolean isArray, boolean isBase) {
            throw new RuntimeException("hasTypeAttr is not implemented");
        }

        boolean hasOmitEmpty(String baseTypeName, VmodlDecl decl, boolean isArray, boolean isBase) {
            throw new RuntimeException("hasOmitEmpty is not implemented");
        }

        protected FieldInfo(String name) {
            this._name = GoEmitter.capitalize(name);
        }

        protected FieldInfo(String name, String typeName, String annotation) {
            this(name);
            this._typeName = typeName;
            this._annotation = annotation;
        }

        protected FieldInfo(String name, String wsdlName, VmodlDecl decl) {
            this(name);
            String baseTypeName = this.getBaseTypeName(decl);
            boolean isPointer = this.isPointer(decl);
            boolean isArray = decl.isArray() || decl.getTypeId() == VmodlDecl.TypeId.BINARY;
            boolean isBase = this.isBase(baseTypeName, decl);
            boolean isExternal = !goEmitter.isLocal(baseTypeName);
            String typeName = (isExternal ? "types." : "") + (isBase ? "Base" : "") + baseTypeName;
            if (isPointer && !isBase) {
                typeName = "*" + typeName;
            } else if (isArray) {
                typeName = "[]" + typeName;
            }
            this._typeName = typeName;
            boolean hasTypeAttr = this.hasTypeAttr(baseTypeName, decl, isArray, isBase);
            boolean hasOmitEmpty = this.hasOmitEmpty(baseTypeName, decl, isArray, isBase);
            this._annotation = "`xml:\"" + wsdlName + (hasOmitEmpty ? ",omitempty" : "") + (hasTypeAttr ? ",typeattr" : "") + "\"`";
        }

        public String getName() {
            return this._name;
        }

        public String getTypeName() {
            return this._typeName;
        }

        public String getAnnotation() {
            return this._annotation;
        }
    }

    private class OutputFile
    implements AutoCloseable {
        public OutputFile(String filePath, String pkgName, String[] imports) {
            GoEmitter.this.beginFile(GoEmitter.this._baseDir + "/" + filePath);
            this.emitCopyrightHeader();
            GoEmitter.this.emitLine(new String[]{"package ", pkgName});
            GoEmitter.this.emitGap();
            this.emitImports(imports);
        }

        @Override
        public void close() {
            GoEmitter.this.endFile();
        }

        private void emitCopyrightHeader() {
            for (String line : COPYRIGHT_MESSAGE) {
                GoEmitter.this.emitLine(line);
            }
        }

        private void emitImports(String[] imports) {
            if (imports != null && imports.length > 0) {
                GoEmitter.this.emitLine("import (");
                GoEmitter.this.indent();
                for (String pkg : imports) {
                    if (pkg.length() > 0) {
                        GoEmitter.this.emitLine(new String[]{"\"", pkg, "\""});
                        continue;
                    }
                    GoEmitter.this.emitGap();
                }
                GoEmitter.this.unindent();
                GoEmitter.this.emitLine(")");
            }
            GoEmitter.this.emitGap();
        }
    }
}

