/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.gobject;

import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.model.Enum;
import emitters.model.Field;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class GObjectEmitter
extends VmodlEmitter {
    protected static final String _managedObjectType = "VMODL_TYPE_VMOMI_MANAGED_OBJECT";
    protected static final String _managedObjectCast = "VMODL_VMOMI_MANAGED_OBJECT";
    protected static final String _managedObjectInstance = "VmodlVmomiManagedObject";
    protected static final String _dataObjectCast = "VMODL_VMOMI_DATA_OBJECT";
    protected static final String _exceptionCast = "VMODL_VMOMI_METHOD_FAULT";
    protected static final String _managedTypeSuffix = "_managed_type";

    protected String getModuleName(String suffix) {
        String filename = this.getFilename();
        int begin = 0;
        int end = filename.lastIndexOf(suffix);
        String name = "";
        while (begin < end) {
            int index = filename.indexOf(47, begin);
            if (index < 0) {
                index = end;
            }
            name = name + GObjectEmitter.capitalize(filename.substring(begin, index));
            begin = index + 1;
        }
        return name;
    }

    @Override
    protected void beginFile(String filename) {
        super.beginFile(filename);
    }

    protected void emitFileHeader() {
        this.emitLine("#ifdef _WIN32");
        this.emitLine("#pragma once");
        this.emitLine("#endif");
        this.emitLine("/******** AUTOMATICALLY GENERATED CODE - DO NOT EDIT ********/");
        this.emitLine();
    }

    protected String formatVirtualMethod(Method method, VmodlObject obj) {
        ArrayList<String> paramNames = new ArrayList<String>();
        for (Field field : method.getParameterList()) {
            String paramName = field.getName();
            String typeName = this.getInParamString(field.getDecl());
            paramNames.add(this.formatDecl(typeName, paramName));
        }
        String methodPrefix = "void (* " + this.getUnderscoreCase(method.getName()).toLowerCase() + ") (";
        String string = this.getPadding(methodPrefix);
        StringBuffer result = new StringBuffer();
        result.append(methodPrefix + this.getGInstanceName(obj) + ",\n");
        for (String param : paramNames) {
            result.append(string + param + ",\n");
        }
        result.append(string + "GVmomiListener *listener);");
        return result.toString();
    }

    protected String formatMethodDecl(Method method, VmodlObject obj) {
        return this.formatMethod(method, obj, true);
    }

    protected String formatMethodDef(Method method, VmodlObject obj) {
        return this.formatMethod(method, obj, false);
    }

    private String formatMethod(Method method, VmodlObject obj, boolean isDecl) {
        ArrayList<String> paramNames = new ArrayList<String>();
        for (Field field : method.getParameterList()) {
            String paramName = field.getName();
            String typeName = this.getInParamString(field.getDecl());
            paramNames.add(this.formatDecl(typeName, paramName) + (field.getDecl().isOptional() ? " /* Optional */" : ""));
        }
        VmodlDecl vmodlDecl = method.getReturnDecl();
        String returnTypeName = vmodlDecl.isVoid() ? "void" : (vmodlDecl.isPrimitive() && !vmodlDecl.isArray() ? this.getReturnString(vmodlDecl) : this.getReturnString(vmodlDecl));
        String methodName = this.getMethodName(method, obj);
        String padding = this.getPadding(methodName + "(");
        StringBuffer result = new StringBuffer();
        if (isDecl) {
            result.append("GVMOMI_EXPORT\n");
        }
        result.append("void\n");
        result.append(methodName + "(" + this.getGInstanceName(obj) + " *vmodlObj,\n");
        for (String param : paramNames) {
            result.append(padding + param + ",\n");
        }
        result.append(padding + "GVmomiListener *listener)");
        if (isDecl) {
            result.append(";");
        }
        result.append(" /* Returns: " + returnTypeName.replaceAll("[/*][*/]", "") + " */");
        return result.toString();
    }

    protected String formatDecl(String typeName, String declName) {
        return typeName + (typeName.endsWith("*") ? "" : " ") + declName;
    }

    protected String getMemberName(Property property) {
        return "_" + property.getName();
    }

    protected String getFormalName(Property property) {
        return property.getName() + "_";
    }

    protected String getTypeString(VmodlDecl.TypeId typeId) {
        switch (typeId) {
            case VOID: {
                return "void";
            }
            case BOOLEAN: {
                return "gboolean";
            }
            case BYTE: {
                return "gint8";
            }
            case SHORT: {
                return "gint16";
            }
            case INT: {
                return "gint32";
            }
            case LONG: {
                return "gint64";
            }
            case FLOAT: {
                return "gfloat";
            }
            case DOUBLE: {
                return "gdouble";
            }
            case STRING: {
                return "gchar *";
            }
            case DATETIME: {
                return "GTimeVal *";
            }
            case TYPENAME: {
                return "gchar *";
            }
            case METHODNAME: {
                return "gchar *";
            }
            case PROPPATH: {
                return "gchar *";
            }
            case URI: {
                return "gchar *";
            }
            case BINARY: {
                return "GByteArray *";
            }
        }
        throw new RuntimeException("C type unknown for non-primitive typeId");
    }

    protected String getTrueTypeString(VmodlDecl decl) {
        String typeName = decl.isData() || decl.isEnum() ? this.getGInstanceName(decl.getObject()) : (decl.isAny() ? "GValue" : (decl.isManaged() ? (decl.getObject() != null ? this.getGInstanceName(decl.getObject()) : _managedObjectInstance) : this.getTypeString(decl.getTypeId())));
        return typeName;
    }

    protected String getTypeString(VmodlDecl decl) {
        String typeName = this.getTrueTypeString(decl);
        if (decl.isArray()) {
            if (decl.isAny()) {
                typeName = "Any";
            }
            return "/* " + typeName + " */ GArray";
        }
        return typeName;
    }

    protected String getTypeDesc(VmodlDecl decl) {
        String typeName = this.getTrueTypeString(decl);
        if (decl.isArray()) {
            if (decl.isAny()) {
                typeName = "Any";
            }
            return "Array of " + GObjectEmitter.qq("#" + typeName);
        }
        return typeName;
    }

    protected String getDeclString(VmodlDecl decl) {
        String typeName = this.getTypeString(decl);
        if (decl.isPrimitive() && !decl.isArray()) {
            return typeName;
        }
        if (decl.isLink() && !decl.isArray() || decl.isManaged() || decl.isData()) {
            return typeName + " *";
        }
        if (decl.isArray()) {
            return typeName + " *";
        }
        if (decl.isAny()) {
            return typeName;
        }
        throw new RuntimeException("Unhandled type passed to getDeclString");
    }

    protected String getPropDeclString(VmodlDecl decl) {
        String typeName = this.getDeclString(decl);
        if (decl.isManaged() && !decl.isArray()) {
            typeName = "gchar *";
        }
        return typeName;
    }

    protected String getInParamString(VmodlDecl decl) {
        String typeName = this.getDeclString(decl);
        switch (decl.getTypeId()) {
            case STRING: 
            case DATETIME: 
            case TYPENAME: 
            case METHODNAME: 
            case PROPPATH: 
            case URI: 
            case BINARY: {
                typeName = "const " + typeName;
                break;
            }
        }
        if (decl.isOptional()) {
            switch (decl.getTypeId()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case ENUM: 
                case ANY: {
                    typeName = typeName + " *";
                    break;
                }
            }
        }
        return typeName;
    }

    protected String getReturnString(VmodlDecl decl) {
        return this.getDeclString(decl);
    }

    protected String getFullClassName(VmodlObject obj) {
        String fullName = obj.getClassName();
        if (obj.getContainer() != null) {
            fullName = GObjectEmitter.join(obj.getContainerNameList(), "::") + "::" + fullName;
        }
        return fullName;
    }

    protected String getQualifiedClassName(VmodlObject obj) {
        return this.qualifyClassName(obj, this.getFullClassName(obj));
    }

    protected String getHeaderFileBasename(VmodlObject obj, String directory) {
        String className = this.getQualifiedClassName(obj);
        if (className.startsWith("::")) {
            className = className.replaceFirst("::", "");
        }
        String filename = className.replaceAll("::", "/");
        if (directory.length() > 0) {
            filename = directory + "/" + filename;
        }
        return filename;
    }

    protected String getHeaderFile(VmodlObject obj, String directory) {
        return this.getHeaderFileBasename(obj, directory) + ".h";
    }

    protected String getClassDeclFile(VmodlObject obj, String directory) {
        return this.getHeaderFileBasename(obj, directory) + "Decl.h";
    }

    private String qualifyClassName(VmodlObject obj, String className) {
        String namespace = obj.getNamespace();
        if (namespace.length() > 0) {
            className = namespace.replace(".", "::") + "::" + className;
        }
        return "::" + className;
    }

    private String getObjectName(VmodlObject obj) {
        String objName;
        if (obj instanceof Enum) {
            objName = obj.getContainer() == null ? obj.getNamespace() : this.getObjectName(obj.getContainer());
        } else {
            objName = obj.getNamespace();
            VmodlObject parent = obj;
            while ((parent = parent.getContainer()) != null) {
                objName = objName + parent.getClassName();
            }
        }
        objName = objName + obj.getClassName();
        return objName.replace(".", "");
    }

    private String getUnderscoreCase(String name) {
        Pattern capitals = Pattern.compile("(.)([A-Z]+)");
        Matcher regexMatcher = capitals.matcher(name);
        StringBuffer buffer = new StringBuffer();
        while (regexMatcher.find()) {
            String group1 = regexMatcher.group(1);
            String group2 = regexMatcher.group(2);
            regexMatcher.appendReplacement(buffer, group1 + "_" + group2);
        }
        regexMatcher.appendTail(buffer);
        return buffer.length() == 0 ? name : buffer.toString();
    }

    protected String getUnderscoreName(VmodlObject obj) {
        return this.getUnderscoreCase(this.getObjectName(obj));
    }

    protected String getGTypeName(VmodlObject obj) {
        return "VMODL_TYPE_" + this.getUnderscoreName(obj).toUpperCase();
    }

    protected String getGTypeCast(VmodlObject obj) {
        return "VMODL_" + this.getUnderscoreName(obj).toUpperCase();
    }

    protected String getBaseGTypeCast(VmodlObject obj) {
        if (obj.isFault()) {
            return _exceptionCast;
        }
        if (obj instanceof ManagedObject) {
            return _managedObjectCast;
        }
        return _dataObjectCast;
    }

    protected String getGInstanceName(VmodlObject obj) {
        return "Vmodl" + this.getObjectName(obj);
    }

    protected String getGClassName(VmodlObject obj) {
        return this.getGInstanceName(obj) + "Class";
    }

    protected String getMethodPrefix(VmodlObject obj) {
        return this.getGTypeCast(obj).toLowerCase();
    }

    protected String getMethodName(Method method, VmodlObject obj) {
        return this.getMethodPrefix(obj) + "_" + this.getUnderscoreCase(method.getName()).toLowerCase();
    }

    protected String getGetType(VmodlObject obj) {
        String usLName = this.getMethodPrefix(obj);
        return usLName + "_get_type";
    }

    protected String getGEnumValue(String value, Enum obj) {
        String scope = obj.getContainer() == null ? obj.getNamespace().replace(".", "") : this.getObjectName(obj.getContainer());
        String enumValue = obj.IsCppEnumClass() ? obj.getName() + "_" + value : value;
        return "VMODL_" + (this.getUnderscoreCase(scope) + "_" + enumValue).toUpperCase();
    }

    protected String getPropertyID(VmodlObject obj, Property property) {
        return "PROP_" + (this.getGInstanceName(obj) + this.getMemberName(property)).toUpperCase();
    }

    protected String getGType(VmodlDecl decl) {
        if (decl.isPrimitive()) {
            switch (decl.getTypeId()) {
                case VOID: {
                    return "G_TYPE_NONE";
                }
                case BOOLEAN: {
                    return "G_TYPE_BOOLEAN";
                }
                case BYTE: {
                    return "G_TYPE_CHAR";
                }
                case SHORT: 
                case INT: {
                    return "G_TYPE_INT";
                }
                case LONG: {
                    return "G_TYPE_INT64";
                }
                case FLOAT: {
                    return "G_TYPE_FLOAT";
                }
                case DOUBLE: {
                    return "G_TYPE_DOUBLE";
                }
                case DATETIME: {
                    return "GVMOMI_TYPE_TIMEVAL";
                }
                case STRING: 
                case TYPENAME: 
                case METHODNAME: 
                case PROPPATH: {
                    return "G_TYPE_STRING";
                }
                case URI: {
                    return "GVMOMI_TYPE_URI";
                }
                case BINARY: {
                    return "GVMOMI_TYPE_BYTE_ARRAY";
                }
                case ENUM: {
                    return this.getGTypeName(decl.getObject());
                }
            }
            throw new RuntimeException("C type unknown for primitive typeId " + (Object)((Object)decl.getTypeId()));
        }
        if (decl.isData() || decl.isManaged()) {
            if (decl.getObject() == null) {
                return _managedObjectType;
            }
            return this.getGTypeName(decl.getObject());
        }
        if (decl.isAny()) {
            return "G_TYPE_VALUE";
        }
        throw new RuntimeException("C type unknown for unexpected typeId");
    }

    protected String getPadding(String source) {
        StringBuffer padding = new StringBuffer();
        for (int i = 0; i < source.length(); ++i) {
            padding.append(" ");
        }
        return padding.toString();
    }

    protected List<VmodlObject> collectNestedObjects(Collection<VmodlObject> objects) {
        ArrayList<VmodlObject> ret = new ArrayList<VmodlObject>();
        for (VmodlObject obj : objects) {
            ret.addAll(obj.getNestedList());
            ret.addAll(this.collectNestedObjects(obj.getNestedList()));
        }
        return ret;
    }

    private String getVersionSuffix(Version version) {
        String wireNs = version.getWireNs();
        String wireId = version.getUniqueWireId();
        String suffix = wireNs + (wireId == null ? "" : "_" + wireId);
        return suffix.replace(".", "_");
    }

    protected String getVersionQuarkName(Version version) {
        return this.getVersionSuffix(version).isEmpty() ? "" : "GVMOMI_QUARK_VERSION_" + this.getVersionSuffix(version).toUpperCase();
    }

    protected String getVersionName(Version version) {
        return this.getVersionSuffix(version).isEmpty() ? "" : "GVMOMI_VERSION_" + this.getVersionSuffix(version).toUpperCase();
    }

    protected boolean shouldEmitVersionForClass(Version version, String packageName) {
        if (!version.getVmodlName().startsWith(packageName + ".") && !version.getVmodlName().startsWith("vmodl." + packageName + ".")) {
            return false;
        }
        return !version.getWireNs().isEmpty();
    }

    static List<Version> getTargetVersions() {
        ArrayList<Version> result = new ArrayList<Version>();
        Version targetVersion = Versions.getTargetVersion();
        for (Version version : Versions.getVersions()) {
            if (!targetVersion.isAncestor(version)) continue;
            result.add(version);
        }
        return result;
    }
}

