/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.python;

import emitters.bindings.python.AstMethod;
import emitters.bindings.python.AstNode;
import emitters.bindings.python.AstNodeVisitor;
import emitters.bindings.python.AstProperty;
import java.util.ArrayList;
import java.util.List;

public final class AstClass
extends AstNode {
    private final String _baseName;
    private final List<AstClass> _nestedClasses = new ArrayList<AstClass>();
    private final List<AstProperty> _properties = new ArrayList<AstProperty>();
    private final List<AstMethod> _methods = new ArrayList<AstMethod>();

    public AstClass(String name) {
        this(name, (String)null);
    }

    public AstClass(String name, String baseName) {
        super(name);
        this._baseName = baseName;
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.begin(this);
        for (AstClass nestedClass : this._nestedClasses) {
            nestedClass.accept(visitor);
        }
        for (AstProperty property : this._properties) {
            property.accept(visitor);
        }
        for (AstMethod method : this._methods) {
            method.accept(visitor);
        }
        visitor.end(this);
    }

    public String getBaseName() {
        return this._baseName;
    }

    public void addProperty(AstProperty astProperty) {
        this._properties.add(astProperty);
    }

    public void addNestedClass(AstClass astClass) {
        this._nestedClasses.add(astClass);
    }

    public void addMethod(AstMethod astMethod) {
        this._methods.add(astMethod);
    }
}

