/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.python;

import emitters.bindings.python.AstNode;
import emitters.bindings.python.AstNodeVisitor;
import java.util.Objects;

public final class AstImport
extends AstNode
implements Comparable<AstImport> {
    private final String _packageName;

    public AstImport(String name, String packageName) {
        super(name);
        this._packageName = packageName;
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String getPackageName() {
        return this._packageName;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AstImport)) {
            return false;
        }
        AstImport imp = (AstImport)other;
        return this._packageName.equals(imp._packageName) && this._name.equals(imp._name);
    }

    public int hashCode() {
        return Objects.hash(this._packageName, this._name);
    }

    @Override
    public int compareTo(AstImport other) {
        int n2;
        int n1 = this.subpackageCount(this._packageName);
        if (n1 == (n2 = this.subpackageCount(other._packageName))) {
            int rc = this._packageName.compareTo(other._packageName);
            if (rc != 0) {
                return rc;
            }
            return this._name.compareTo(other._name);
        }
        return n1 - n2;
    }

    private int subpackageCount(String packageName) {
        int count = 0;
        for (int i = 0; i < packageName.length(); ++i) {
            if (packageName.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }
}

