/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.python;

import emitters.bindings.python.AstNode;
import emitters.bindings.python.AstNodeVisitor;
import java.util.ArrayList;
import java.util.List;

public final class AstMethod
extends AstNode {
    private final ReturnType _returnType;
    private final List<ParamDesc> _params = new ArrayList<ParamDesc>();

    public AstMethod(String name, AstNode leftSibling, ReturnType returnType) {
        super(name, leftSibling);
        this._returnType = returnType;
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public void addParam(ParamDesc paramDesc) {
        this._params.add(paramDesc);
    }

    public ReturnType getReturnType() {
        return this._returnType;
    }

    public List<ParamDesc> getParamList() {
        return this._params;
    }

    public static final class ParamDesc {
        public final String type;
        public final String name;
        public final boolean isArray;
        public final boolean isOptional;

        public ParamDesc(String name, String type, boolean isArray, boolean isOptional) {
            this.name = name;
            this.type = type;
            this.isArray = isArray;
            this.isOptional = isOptional;
        }
    }

    public static final class ReturnType {
        public final String type;
        public final boolean isArray;
        public final boolean isOptional;

        public ReturnType(String type, boolean isArray, boolean isOptional) {
            this.type = type;
            this.isArray = isArray;
            this.isOptional = isOptional;
        }
    }
}

