/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.python;

import emitters.bindings.python.AstClass;
import emitters.bindings.python.AstImport;
import emitters.bindings.python.AstMethod;
import emitters.bindings.python.AstNode;
import emitters.bindings.python.AstNodeFilter;
import emitters.bindings.python.AstNodeVisitor;
import emitters.bindings.python.AstProperty;
import emitters.bindings.python.AstUtil;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.TreeSet;

public final class AstModule
extends AstNode {
    private final VmodlObject _vmodlObject;
    private final AstNodeFilter _astNodeFilter;
    private final TreeSet<AstImport> _imports = new TreeSet();
    private AstClass _astClass = null;

    public AstModule(VmodlObject vmodlObject, AstNodeFilter astNodeFilter) {
        super(vmodlObject.getClassName());
        this._vmodlObject = vmodlObject;
        this._astNodeFilter = astNodeFilter;
        this.buildAstModule();
    }

    public String getVmodlName() {
        return this._vmodlObject.getVmodlName();
    }

    public String getPackage() {
        return this._vmodlObject.getPackage();
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.begin(this);
        for (AstImport imp : this._imports) {
            imp.accept(visitor);
        }
        this._astClass.accept(visitor);
        visitor.end(this);
    }

    private void addImport(String packageName, String className) {
        if (this._name.equals(className)) {
            return;
        }
        this._imports.add(new AstImport(className, packageName));
    }

    private void addImport(AstUtil.TypeDesc desc) {
        if (desc.packageName != null && desc.importClassName != null) {
            this.addImport(desc.packageName, desc.importClassName);
        }
        if (desc.isOptional) {
            this.addImport("typing", "Optional");
        }
    }

    private AstClass createAstClass(VmodlObject vmodlObject) {
        AstClass astClass = null;
        VmodlObject base = vmodlObject.getBaseObject();
        if (base == null) {
            astClass = new AstClass(vmodlObject.getName());
        } else {
            AstUtil.TypeDesc desc = AstUtil.getType(base, this._vmodlObject);
            this.addImport(desc);
            astClass = new AstClass(vmodlObject.getName(), desc.typeName);
        }
        return astClass;
    }

    private AstProperty addProperty(AstClass astClass, Property property, AstNode leftSibling) {
        VmodlObject container = property.getContainer();
        assert (container != null);
        AstUtil.TypeDesc desc = AstUtil.getType(property.getDecl(), container);
        this.addImport(desc);
        AstProperty astProperty = null;
        if (container.getKind() == VmodlObject.Kind.ManagedObject) {
            astProperty = new AstProperty.Managed(property.getName(), leftSibling, desc.typeName, desc.isArray, desc.isOptional);
        } else if (container.getKind() == VmodlObject.Kind.DataObject) {
            astProperty = new AstProperty.Data(property.getName(), leftSibling, desc.typeName, desc.isArray, desc.isOptional);
        } else assert (false);
        astClass.addProperty(astProperty);
        return astProperty;
    }

    private AstClass addEnum(VmodlObject nestedObject) {
        this.addImport("VmomiSupport", "Enum");
        AstClass astClass = new AstClass(nestedObject.getName(), "Enum");
        AstProperty.Enum leftSibling = null;
        for (String value : ((Enum)nestedObject).getValueList()) {
            AstProperty.Enum astProperty = new AstProperty.Enum(value, leftSibling, "'" + value + "'");
            astClass.addProperty(astProperty);
            leftSibling = astProperty;
        }
        return astClass;
    }

    private AstClass addNestedClass(AstClass parent, VmodlObject nestedObject, AstNode leftSibling) {
        AstClass nestedClass = null;
        nestedClass = nestedObject.getKind() == VmodlObject.Kind.Enum ? this.addEnum(nestedObject) : this.addClass(nestedObject);
        nestedClass.setLeftSibling(leftSibling);
        parent.addNestedClass(nestedClass);
        return nestedClass;
    }

    private AstMethod addMethod(Method method, AstClass parent, AstNode leftSibling) {
        VmodlDecl decl = null;
        decl = method.isTask() && Method.taskReturnDecl() != null ? Method.taskReturnDecl() : method.getReturnDecl();
        VmodlObject container = method.getContainer();
        AstUtil.TypeDesc desc = AstUtil.getType(decl, container);
        this.addImport(desc);
        AstMethod astMethod = new AstMethod(method.getName(), leftSibling, new AstMethod.ReturnType(desc.typeName, desc.isArray, desc.isOptional));
        for (Parameter param : method.getParameterList()) {
            if (this._astNodeFilter.filter(param)) continue;
            AstUtil.TypeDesc paramDesc = AstUtil.getType(param.getDecl(), container);
            this.addImport(paramDesc);
            astMethod.addParam(new AstMethod.ParamDesc(param.getName(), paramDesc.typeName, paramDesc.isArray, paramDesc.isOptional));
        }
        parent.addMethod(astMethod);
        return astMethod;
    }

    private AstClass addClass(VmodlObject vmodlObject) {
        AstClass astClass = this.createAstClass(vmodlObject);
        AstNode leftSibling = null;
        for (VmodlObject nestedObject : vmodlObject.getNestedList()) {
            if (this._astNodeFilter.filter(nestedObject)) continue;
            leftSibling = this.addNestedClass(astClass, nestedObject, leftSibling);
        }
        for (Property property : vmodlObject.getPropertyList()) {
            if (this._astNodeFilter.filter(property)) continue;
            leftSibling = this.addProperty(astClass, property, leftSibling);
        }
        if (vmodlObject.getKind() == VmodlObject.Kind.ManagedObject) {
            ManagedObject managedObject = (ManagedObject)vmodlObject;
            for (Method method : managedObject.getMethodList()) {
                if (this._astNodeFilter.filter(method)) continue;
                leftSibling = this.addMethod(method, astClass, leftSibling);
            }
        }
        return astClass;
    }

    private void buildAstModule() {
        this._astClass = this.addClass(this._vmodlObject);
        for (AstImport imp : this._imports) {
            imp.setLeftSibling(this._imports.lower(imp));
        }
        if (!this._imports.isEmpty()) {
            this._astClass.setLeftSibling(this._imports.last());
        }
    }
}

