/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.python;

import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.List;

public final class AstUtil {
    public static TypeDesc getType(VmodlObject base, VmodlObject obj) {
        List<String> typeClassNames = base.getContainerNameList();
        typeClassNames.add(base.getClassName());
        List<String> objClassNames = obj.getContainerNameList();
        objClassNames.add(obj.getClassName());
        return AstUtil.getType(base.getPackage(), false, false, typeClassNames, objClassNames);
    }

    public static TypeDesc getType(VmodlDecl decl, VmodlObject container) {
        VmodlObject typeObj = decl.getObject();
        if (typeObj == null) {
            return AstUtil.getType(decl);
        }
        List<String> typeClassNames = typeObj.getContainerNameList();
        typeClassNames.add(typeObj.getClassName());
        List<String> propClassNames = container.getContainerNameList();
        propClassNames.add(container.getClassName());
        return AstUtil.getType(typeObj.getPackage(), decl.isArray(), decl.isOptional(), typeClassNames, propClassNames);
    }

    private static TypeDesc getType(String packageName, boolean isArray, boolean isOptional, List<String> typeClassNames, List<String> objClassNames) {
        String objName;
        String className;
        int i;
        assert (packageName != null && packageName.length() > 0);
        assert (typeClassNames != null && !typeClassNames.isEmpty());
        assert (objClassNames != null && !objClassNames.isEmpty());
        int size = Math.min(typeClassNames.size(), objClassNames.size());
        for (i = 0; i < size && (className = typeClassNames.get(i)).equals(objName = objClassNames.get(i)); ++i) {
        }
        StringBuilder typeName = new StringBuilder();
        while (i < typeClassNames.size()) {
            typeName.append(typeClassNames.get(i));
            if (i < typeClassNames.size() - 1) {
                typeName.append(".");
            }
            ++i;
        }
        if (typeName.length() == 0) {
            typeName.append(typeClassNames.get(typeClassNames.size() - 1));
        }
        return new TypeDesc(packageName, typeClassNames.get(0), typeName.toString(), isArray, isOptional);
    }

    private static TypeDesc getType(VmodlDecl decl) {
        String packageName = null;
        String importClassName = null;
        String typeName = null;
        switch (decl.getTypeId()) {
            case VOID: {
                packageName = "typing";
                importClassName = "NoReturn";
                typeName = "NoReturn";
                break;
            }
            case BOOLEAN: {
                typeName = "bool";
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                typeName = "int";
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                typeName = "float";
                break;
            }
            case STRING: {
                typeName = "str";
                break;
            }
            case DATETIME: {
                packageName = "vmodl";
                importClassName = "DateTime";
                typeName = "DateTime";
                break;
            }
            case URI: {
                packageName = "vmodl";
                importClassName = "URI";
                typeName = "URI";
                break;
            }
            case BINARY: {
                packageName = "vmodl";
                importClassName = "Binary";
                typeName = "Binary";
                break;
            }
            case TYPENAME: {
                packageName = "vmodl";
                importClassName = "TypeName";
                typeName = "TypeName";
                break;
            }
            case PROPPATH: {
                packageName = "vmodl";
                importClassName = "PropertyPath";
                typeName = "PropertyPath";
                break;
            }
            case METHODNAME: {
                packageName = "vmodl";
                importClassName = "MethodName";
                typeName = "MethodName";
                break;
            }
            case ANY: {
                packageName = "vmodl";
                importClassName = "Any";
                typeName = "Any";
                break;
            }
            case ENUM: 
            case DATA: 
            case MANAGED: {
                if (decl.getObject() != null) {
                    assert (false);
                    break;
                }
                if (decl.isData()) {
                    packageName = "vmodl";
                    importClassName = "DynamicData";
                    typeName = "DynamicData";
                    break;
                }
                if (decl.isManaged()) {
                    packageName = "vmodl";
                    importClassName = "ManagedObject";
                    typeName = "ManagedObject";
                    break;
                }
                if (decl.isEnum()) {
                    packageName = "VmomiSupport";
                    importClassName = "Enum";
                    typeName = "Enum";
                    break;
                }
                assert (false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return new TypeDesc(packageName, importClassName, typeName, decl.isArray(), decl.isOptional());
    }

    public static final class TypeDesc {
        public final String packageName;
        public final String importClassName;
        public final String typeName;
        public final boolean isArray;
        public final boolean isOptional;

        public TypeDesc(String packageName, String importClassName, String typeName, boolean isArray, boolean isOptional) {
            this.packageName = packageName;
            this.importClassName = importClassName;
            this.typeName = typeName;
            this.isArray = isArray;
            this.isOptional = isOptional;
        }
    }
}

