/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.python;

import emitters.bindings.python.AstClass;
import emitters.bindings.python.AstImport;
import emitters.bindings.python.AstMethod;
import emitters.bindings.python.AstModule;
import emitters.bindings.python.AstNode;
import emitters.bindings.python.AstNodeVisitor;
import emitters.bindings.python.AstProperty;
import emitters.bindings.python.PythonEmitter;
import emitters.model.VmodlApi;
import emitters.model.VmodlObject;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PyInterfacesEmitter
extends PythonEmitter {
    private final String _dirname;

    public PyInterfacesEmitter(String dirname, boolean isInternal) {
        super(isInternal);
        this._dirname = dirname;
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        for (VmodlObject obj : objects) {
            if (!this.simplifyVersion((VmodlApi)obj)._emitAPIs) continue;
            AstModule astModule = new AstModule(obj, new PythonEmitter.VersionNodeFilter(this));
            astModule.accept(new PyInterfacesVisitor());
        }
    }

    private final class PyInterfacesVisitor
    implements AstNodeVisitor {
        private final Set<String> _processedPackages = new HashSet<String>();

        private PyInterfacesVisitor() {
        }

        @Override
        public void begin(AstModule astModule) {
            String pyPackage = astModule.getPackage();
            this.createPackage(pyPackage);
            String fileName = astModule.getVmodlName().replace('.', File.separatorChar);
            PyInterfacesEmitter.this.beginFile(PyInterfacesEmitter.this._dirname + File.separator + fileName + ".pyi");
        }

        @Override
        public void end(AstModule astModule) {
            PyInterfacesEmitter.this.endFile();
        }

        @Override
        public void visit(AstImport astImport) {
            AstNode leftSibling = astImport.getLeftSibling();
            if (leftSibling != null) {
                if (leftSibling instanceof AstImport) {
                    AstImport left = (AstImport)leftSibling;
                    if (!left.getPackageName().equals(astImport.getPackageName())) {
                        PyInterfacesEmitter.this.emitLine();
                    }
                } else {
                    PyInterfacesEmitter.this.emitLine();
                }
            }
            PyInterfacesEmitter.this.emitPartial(new String[]{"from ", astImport.getPackageName(), " import ", astImport.getName()});
            PyInterfacesEmitter.this.emitLine();
        }

        @Override
        public void begin(AstClass astClass) {
            String base;
            AstNode leftSibling = astClass.getLeftSibling();
            if (leftSibling != null) {
                PyInterfacesEmitter.this.emitLine();
            }
            if ((base = astClass.getBaseName()) != null) {
                assert (base.length() > 0);
                PyInterfacesEmitter.this.emitPartial(new String[]{"class ", astClass.getName(), "(", base, "):"});
            } else {
                PyInterfacesEmitter.this.emitPartial(new String[]{"class ", astClass.getName(), ":"});
            }
            PyInterfacesEmitter.this.emitLine();
            PyInterfacesEmitter.this.indent();
        }

        @Override
        public void end(AstClass astClass) {
            PyInterfacesEmitter.this.unindent();
        }

        @Override
        public void visit(AstMethod astMethod) {
            AstNode leftSibling = astMethod.getLeftSibling();
            if (leftSibling != null && !(leftSibling instanceof AstMethod)) {
                PyInterfacesEmitter.this.emitLine();
            }
            PyInterfacesEmitter.this.emitPartial(new String[]{"def ", astMethod.getName(), "(self"});
            List<AstMethod.ParamDesc> paramList = astMethod.getParamList();
            for (AstMethod.ParamDesc paramDesc : paramList) {
                PyInterfacesEmitter.this.emitPartial(", ");
                PyInterfacesEmitter.this.emitPartial(paramDesc.name);
                PyInterfacesEmitter.this.emitPartial(": ");
                if (paramDesc.isArray) {
                    PyInterfacesEmitter.this.emitPartial("list");
                } else if (paramDesc.isOptional) {
                    PyInterfacesEmitter.this.emitPartial("Optional");
                }
                PyInterfacesEmitter.this.emitPartial("[");
                PyInterfacesEmitter.this.emitPartial(paramDesc.type);
                PyInterfacesEmitter.this.emitPartial("]");
            }
            PyInterfacesEmitter.this.emitPartial(") -> ");
            String closingBracket = null;
            AstMethod.ReturnType returnType = astMethod.getReturnType();
            if (returnType.isArray) {
                PyInterfacesEmitter.this.emitPartial("list[");
                closingBracket = "]";
            } else if (returnType.isOptional) {
                PyInterfacesEmitter.this.emitPartial("Optional[");
                closingBracket = "]";
            }
            PyInterfacesEmitter.this.emitPartial(returnType.type);
            if (closingBracket != null) {
                PyInterfacesEmitter.this.emitPartial(closingBracket);
            }
            PyInterfacesEmitter.this.emitPartial(": ...");
            PyInterfacesEmitter.this.emitLine();
        }

        @Override
        public void visit(AstProperty astProperty) {
            if (astProperty instanceof AstProperty.Managed) {
                this.visit((AstProperty.Managed)astProperty);
            } else if (astProperty instanceof AstProperty.Data) {
                this.visit((AstProperty.Data)astProperty);
            } else if (astProperty instanceof AstProperty.Enum) {
                this.visit((AstProperty.Enum)astProperty);
            } else assert (false);
        }

        private void visit(AstProperty.Managed managedProperty) {
            AstNode leftSibling = managedProperty.getLeftSibling();
            if (leftSibling != null && !(leftSibling instanceof AstProperty)) {
                PyInterfacesEmitter.this.emitLine();
            }
            PyInterfacesEmitter.this.emitLine("@property");
            String closingBracket = null;
            PyInterfacesEmitter.this.emitPartial(new String[]{"def ", managedProperty.getName(), "(self) -> "});
            if (managedProperty.isArray()) {
                PyInterfacesEmitter.this.emitPartial("list[");
                closingBracket = "]";
            } else if (managedProperty.isOptional()) {
                PyInterfacesEmitter.this.emitPartial("Optional[");
                closingBracket = "]";
            }
            PyInterfacesEmitter.this.emitPartial(managedProperty.getType());
            if (closingBracket != null) {
                PyInterfacesEmitter.this.emitPartial(closingBracket);
            }
            PyInterfacesEmitter.this.emitPartial(": ...");
            PyInterfacesEmitter.this.emitLine();
        }

        private void visit(AstProperty.Data dataProperty) {
            AstNode leftSibling = dataProperty.getLeftSibling();
            if (leftSibling != null && !(leftSibling instanceof AstProperty)) {
                PyInterfacesEmitter.this.emitLine();
            }
            String value = null;
            PyInterfacesEmitter.this.emitPartial(new String[]{dataProperty.getName(), ": "});
            if (dataProperty.isArray()) {
                PyInterfacesEmitter.this.emitPartial("list[");
                value = "] = []";
            } else if (dataProperty.isOptional()) {
                PyInterfacesEmitter.this.emitPartial("Optional[");
                value = "] = None";
            }
            PyInterfacesEmitter.this.emitPartial(dataProperty.getType());
            if (value != null) {
                PyInterfacesEmitter.this.emitPartial(value);
            }
            PyInterfacesEmitter.this.emitLine();
        }

        private void visit(AstProperty.Enum enumProperty) {
            AstNode leftSibling = enumProperty.getLeftSibling();
            if (leftSibling != null && !(leftSibling instanceof AstProperty)) {
                PyInterfacesEmitter.this.emitLine();
            }
            PyInterfacesEmitter.this.emitPartial(new String[]{enumProperty.getName(), ": ClassVar[", enumProperty.getType(), "] = ", enumProperty.getValue()});
            PyInterfacesEmitter.this.emitLine();
        }

        private void createPackage(String pyPackage) {
            String packageDir = pyPackage.replace('.', File.separatorChar);
            if (this._processedPackages.contains(packageDir)) {
                return;
            }
            PyInterfacesEmitter.this.beginFile(PyInterfacesEmitter.this._dirname + File.separator + packageDir + File.separator + "__init__.pyi");
            PyInterfacesEmitter.this.endFile();
            this._processedPackages.add(packageDir);
        }
    }
}

