/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.python;

import emitters.VmodlEmitter;
import emitters.bindings.python.AstNodeFilter;
import emitters.model.MetaVersion;
import emitters.model.Parameter;
import emitters.model.SyntheticVersion;
import emitters.model.Version;
import emitters.model.VmodlApi;
import java.time.LocalDate;

public abstract class PythonEmitter
extends VmodlEmitter {
    protected final boolean _isInternal;

    protected PythonEmitter(boolean isInternal) {
        this._isInternal = isInternal;
        this.setHideInternalDecls(!isInternal);
        this.setHideUndocumentedDecls(!isInternal);
    }

    protected boolean shouldEmit(Version version) {
        switch (version.getKind()) {
            case LTS: {
                return true;
            }
            case MILESTONE: 
            case FEATURE: {
                return false;
            }
        }
        return this._isInternal;
    }

    protected SimplifiedVersion simplifyVersion(Parameter param) {
        if (!this.shouldGenerateFor(param)) {
            return new SimplifiedVersion();
        }
        return new SimplifiedVersion(param.getVersion());
    }

    protected SimplifiedVersion simplifyVersion(VmodlApi vmodlApi) {
        if (!this.shouldGenerate(vmodlApi)) {
            return new SimplifiedVersion();
        }
        return new SimplifiedVersion(vmodlApi.getVersion());
    }

    @Override
    protected void beginFile(String filename) {
        super.beginFile(filename);
        int year = LocalDate.now().getYear();
        this.emitLine("# Copyright (c) " + Integer.toString(year) + " Broadcom. All Rights Reserved.");
        this.emitLine("# Broadcom Confidential. The term \"Broadcom\" refers to Broadcom Inc.");
        this.emitLine("# and/or its subsidiaries.");
        this.emitLine();
        this.emitLine("# ******* WARNING - AUTO GENERATED CODE - DO NOT EDIT *******");
        this.emitLine();
    }

    protected final class VersionNodeFilter
    implements AstNodeFilter {
        protected VersionNodeFilter() {
        }

        @Override
        public boolean filter(VmodlApi vmodlApi) {
            SimplifiedVersion sv = PythonEmitter.this.simplifyVersion(vmodlApi);
            return !sv._emitAPIs;
        }

        @Override
        public boolean filter(Parameter parameter) {
            SimplifiedVersion sv = PythonEmitter.this.simplifyVersion(parameter);
            return !sv._emitAPIs;
        }
    }

    protected class SimplifiedVersion {
        final boolean _emitAPIs;
        final Version _version;

        SimplifiedVersion() {
            this._emitAPIs = false;
            this._version = null;
        }

        SimplifiedVersion(Version version) {
            switch (version.getKind()) {
                case LTS: {
                    this._emitAPIs = true;
                    this._version = version;
                    break;
                }
                case MILESTONE: 
                case FEATURE: {
                    this._emitAPIs = PythonEmitter.this._isInternal;
                    SyntheticVersion sv = (SyntheticVersion)version;
                    MetaVersion metaVersion2 = sv.getMetaVersion();
                    this._version = metaVersion2.getDevVersion();
                    break;
                }
                default: {
                    this._emitAPIs = PythonEmitter.this._isInternal;
                    this._version = version;
                }
            }
        }
    }
}

