/*
 * Decompiled with CFR 0.152.
 */
package emitters.doc;

import com.sun.source.util.DocTreePath;
import emitters.model.Version;

public interface JavadocLinkResolver {
    public String getLabel(DocTreePath var1, LinkContext var2);

    public String getDestination(DocTreePath var1, LinkContext var2);

    public boolean enabled(LinkContext var1);

    public static class LinkContext {
        private final Type _type;
        private final boolean _satellite;
        public static LinkContext DISABLED = new LinkContext(Type.DISABLED);
        public static LinkContext DATA_OBJECT = new LinkContext(Type.DATA_OBJECT);
        public static LinkContext ENUM = new LinkContext(Type.ENUM);
        public static LinkContext MANAGED_OBJECT = new LinkContext(Type.MANAGED_OBJECT);
        public static LinkContext METHOD_PARAMS = new LinkContext(Type.METHOD_PARAMS);
        public static LinkContext NAMESPACE = new LinkContext(Type.NAMESPACE);
        public static LinkContext MANAGED_METHOD_BASE = new LinkContext(Type.MANAGED_METHOD, false);
        public static LinkContext MANAGED_METHOD_SATELLITE = new LinkContext(Type.MANAGED_METHOD, true);
        private static LinkContext MANAGED_PROPERTY_BASE = new LinkContext(Type.MANAGED_PROPERTY, false);
        private static LinkContext MANAGED_PROPERTY_SATELLITE = new LinkContext(Type.MANAGED_PROPERTY, true);

        private LinkContext(Type type) {
            this(type, false);
        }

        private LinkContext(Type type, boolean satellite) {
            this._type = type;
            this._satellite = satellite;
        }

        public Type getType() {
            return this._type;
        }

        public boolean isSatellite() {
            return this._satellite;
        }

        public static LinkContext getPropertyContext(Version version, String defaultNamespace) {
            return version.isBaseNamespace(defaultNamespace) ? MANAGED_PROPERTY_BASE : MANAGED_PROPERTY_SATELLITE;
        }

        public static LinkContext getMethodContext(Version version, String defaultNamespace) {
            return version.isBaseNamespace(defaultNamespace) ? MANAGED_METHOD_BASE : MANAGED_METHOD_SATELLITE;
        }

        public static enum Type {
            DISABLED,
            MANAGED_OBJECT,
            MANAGED_METHOD,
            MANAGED_PROPERTY,
            DATA_OBJECT,
            ENUM,
            METHOD_PARAMS,
            NAMESPACE;

        }
    }
}

