/*
 * Decompiled with CFR 0.152.
 */
package emitters.doc;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.util.DocTreePath;
import emitters.Versions;
import emitters.doc.Issue;
import emitters.doc.JavadocElements;
import emitters.doc.JavadocLinkResolver;
import emitters.doc.JavadocToMarkdown;
import emitters.doc.LinkResolver;
import emitters.javac.Platform;
import emitters.model.DataProperty;
import emitters.model.Documented;
import emitters.model.Entity;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.ManagedProperty;
import emitters.model.Method;
import emitters.model.Namespace;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;

public class MarkdownRenderer {
    private final StringBuilder _buffer = new StringBuilder();
    private final JavadocLinkResolver _jdLinkResolver;
    private final LinkResolver _linkResolver;
    private final boolean _renderMoRef;
    private final String _defaultNamespace;
    private final boolean _warnOnWrongThrowsJavadoc;

    public MarkdownRenderer(LinkResolver linkResolver, JavadocLinkResolver jdLinkResolver, boolean renderMoRef, String defaultNamespace, boolean warnOnWrongThrowsJavadoc) {
        this._linkResolver = linkResolver;
        this._jdLinkResolver = jdLinkResolver;
        this._renderMoRef = renderMoRef;
        this._defaultNamespace = defaultNamespace;
        this._warnOnWrongThrowsJavadoc = warnOnWrongThrowsJavadoc;
    }

    public String renderSummary(Entity element) {
        DocTreePath doc = element.getDoc();
        if (doc == null || doc.getDocComment() == null) {
            return null;
        }
        this.reset();
        SummaryRenderer renderer = new SummaryRenderer(this._buffer);
        this.printIssues((Issue)renderer.scan(doc, JavadocLinkResolver.LinkContext.DISABLED), doc);
        return renderer.toString();
    }

    public String renderDescription(Documented element) {
        return this.renderDescription(element, null);
    }

    public String renderDescription(Documented element, String epilogue) {
        return this.renderDescription(element, null, null, epilogue);
    }

    public String renderDescription(Enum element) {
        DocTreePath doc = element.getDoc();
        this.reset();
        Version version = element.getVersion();
        String versionDisplayName = version != null && version.isNonInitialViJsonRelease() ? version.getDisplayName() : null;
        DescriptionRenderer renderer = new DescriptionRenderer(this._buffer, versionDisplayName, null, null, JavadocLinkResolver.LinkContext.ENUM);
        if (doc != null && doc.getDocComment() != null) {
            this.printIssues((Issue)renderer.scan(doc, JavadocLinkResolver.LinkContext.ENUM), doc);
        }
        renderer.paragraph().code("Possible values:");
        renderer.startUnorderedList();
        for (int i = 0; i < element.getValueList().size(); ++i) {
            if (!MarkdownRenderer.shouldEmitEnumValue(element, i)) continue;
            this.renderEnumValue(renderer, element, i);
        }
        renderer.endUnorderedList();
        return renderer.toString();
    }

    private void renderEnumValue(DescriptionRenderer renderer, Enum element, int index) {
        String valueVersionName;
        Version valueVersion;
        String value = element.getValueList().get(index);
        renderer.startUnorderedListItem().code("`").code(value).code("`");
        Supplier<DocTreePath> valueDocSupp = element.getValueDocList().get(index);
        DocTreePath valueDoc = null;
        if (valueDocSupp != null && (valueDoc = valueDocSupp.get()) != null) {
            renderer.code(": ");
            this.printIssues((Issue)renderer.scan(valueDoc, JavadocLinkResolver.LinkContext.ENUM), valueDoc);
        }
        if ((valueVersion = element.getValueVersionList().get(index)) != null && valueVersion.isNonInitialViJsonRelease() && (valueVersionName = valueVersion.getDisplayName()) != null && valueVersionName.length() > 0) {
            if (valueDoc != null) {
                renderer.paragraph();
            } else {
                renderer.code(": ");
            }
            renderer.renderVersion(valueVersionName);
        }
    }

    public static boolean shouldEmitEnumValue(Enum element, int index) {
        Version version = element.getValueVersionList().get(index);
        return version == null || Versions.getTargetVersion().isAncestor(version);
    }

    public String renderDescription(Documented element, String privilege, VmodlDecl decl) {
        return this.renderDescription(element, privilege, decl, null, null);
    }

    private String renderDescription(Documented element, String privilege, VmodlDecl decl, String epilogue) {
        return this.renderDescription(element, privilege, decl, null, epilogue);
    }

    public String renderDescription(Documented element, String privilege, VmodlDecl decl, JavadocLinkResolver.LinkContext context) {
        return this.renderDescription(element, privilege, decl, context, null);
    }

    private String renderDescription(Documented element, String privilege, VmodlDecl decl, JavadocLinkResolver.LinkContext context, String epilogue) {
        String comment;
        DocTreePath doc = element.getDoc();
        DocCommentTree docComment = doc == null ? null : doc.getDocComment();
        String displayVersion = MarkdownRenderer.getDisplayVersion(element);
        if (context == null) {
            context = this.getLinkContext(element);
        }
        if (docComment == null && (comment = element.getComment()) != null) {
            epilogue = epilogue == null ? comment : comment + "\n\n" + epilogue;
        }
        return this.renderDescription(doc, displayVersion, privilege, decl, context, epilogue);
    }

    private static String getDisplayVersion(Documented element) {
        DataProperty prop;
        if (!(element instanceof Entity)) {
            return null;
        }
        if (element instanceof DataProperty && (prop = (DataProperty)element).getVersion() == prop.getContainer().getVersion()) {
            return null;
        }
        Version version = ((Entity)element).getVersion();
        return version != null && version.isNonInitialViJsonRelease() ? version.getDisplayName() : null;
    }

    private JavadocLinkResolver.LinkContext getLinkContext(Documented element) {
        if (element instanceof ManagedObject) {
            return JavadocLinkResolver.LinkContext.MANAGED_OBJECT;
        }
        if (element instanceof Method) {
            return JavadocLinkResolver.LinkContext.getMethodContext(((Entity)element).getVersion(), this._defaultNamespace);
        }
        if (element instanceof ManagedProperty) {
            return JavadocLinkResolver.LinkContext.getPropertyContext(((Entity)element).getVersion(), this._defaultNamespace);
        }
        if (element instanceof Enum) {
            return JavadocLinkResolver.LinkContext.ENUM;
        }
        if (element instanceof Namespace) {
            return JavadocLinkResolver.LinkContext.NAMESPACE;
        }
        return JavadocLinkResolver.LinkContext.DATA_OBJECT;
    }

    public String renderDescription(DocTreePath doc, VmodlDecl decl, JavadocLinkResolver.LinkContext context) {
        return this.renderDescription(doc, null, null, decl, context, null);
    }

    private String renderDescription(DocTreePath doc, String version, String privilege, VmodlDecl decl, JavadocLinkResolver.LinkContext context, String epilogue) {
        this.reset();
        DescriptionRenderer renderer = new DescriptionRenderer(this._buffer, version, privilege, decl, context);
        if (doc != null && doc.getDocComment() != null) {
            this.printIssues((Issue)renderer.scan(doc, context), doc);
        }
        if (epilogue != null) {
            renderer.paragraph().code(epilogue);
        }
        return renderer.toString();
    }

    public String renderFaults(Method m) {
        DocTreePath doc = m.getDoc();
        if (doc == null || doc.getDocComment() == null) {
            return null;
        }
        this.reset();
        FaultsRenderer renderer = new FaultsRenderer(this._buffer, m);
        JavadocLinkResolver.LinkContext context = m.getVersion().isBaseNamespace(this._defaultNamespace) ? JavadocLinkResolver.LinkContext.MANAGED_METHOD_BASE : JavadocLinkResolver.LinkContext.MANAGED_METHOD_SATELLITE;
        this.printIssues((Issue)renderer.scan(doc, context), doc);
        return renderer.toString();
    }

    private void reset() {
        this._buffer.setLength(0);
    }

    private void printIssues(Issue last, DocTreePath doc) {
        if (last == Issue.NONE) {
            return;
        }
        ArrayList<Issue> issues = new ArrayList<Issue>();
        while (last != null) {
            issues.add(last);
            last = last.previous;
        }
        Collections.reverse(issues);
        issues.forEach(i -> Platform.printDocMessage(i.kind, i.message, doc, i.element));
    }

    class FaultsRenderer
    extends JavadocToMarkdown {
        private final Method method;
        private boolean renderingFaultReference;

        public FaultsRenderer(StringBuilder buffer, Method method) {
            super(MarkdownRenderer.this._jdLinkResolver, buffer);
            this.method = method;
        }

        @Override
        public Issue visitDocComment(DocCommentTree node, JavadocLinkResolver.LinkContext context) {
            return (Issue)this.scan(node.getBlockTags().stream().filter(t -> t.getKind() == DocTree.Kind.THROWS).collect(Collectors.toList()), context);
        }

        @Override
        public Issue visitThrows(ThrowsTree node, JavadocLinkResolver.LinkContext context) {
            this.paragraph();
            MarkdownRenderer.this._buffer.append("**");
            this.renderingFaultReference = true;
            Issue referenceIssue = (Issue)this.scan(node.getExceptionName(), context);
            this.renderingFaultReference = false;
            MarkdownRenderer.this._buffer.append("**: ");
            Issue descriptionIssue = (Issue)this.scan(node.getDescription(), context);
            return this.reduce(descriptionIssue, referenceIssue);
        }

        @Override
        public Issue visitReference(ReferenceTree node, JavadocLinkResolver.LinkContext context) {
            Issue referenceIssue = super.visitReference(node, context);
            if (MarkdownRenderer.this._warnOnWrongThrowsJavadoc && this.renderingFaultReference && referenceIssue == Issue.NONE) {
                Element e = JavadocElements.getElement(this.getCurrentPath());
                VmodlApi faultType = JavadocElements.getVmodlElement(e);
                if (!this.method.getFaultList().contains(faultType)) {
                    referenceIssue = new Issue("exception not thrown: " + faultType.getVmodlName(), node);
                }
            }
            return referenceIssue;
        }
    }

    class DescriptionRenderer
    extends JavadocToMarkdown {
        private final String _version;
        private final String _privilege;
        private final VmodlDecl _decl;
        private final JavadocLinkResolver.LinkContext _context;

        public DescriptionRenderer(StringBuilder buffer, String version, String privilege, VmodlDecl decl, JavadocLinkResolver.LinkContext context) {
            super(MarkdownRenderer.this._jdLinkResolver, buffer);
            this._version = version;
            this._privilege = privilege;
            this._decl = decl;
            this._context = context;
        }

        @Override
        public Issue visitDocComment(DocCommentTree node, JavadocLinkResolver.LinkContext context) {
            Issue issue = this.renderDeprecation(node);
            issue = this.reduce((Issue)this.scan(node.getFirstSentence(), context), issue);
            this.paragraph();
            issue = this.reduce((Issue)this.scan(node.getBody(), context), issue);
            issue = this.reduce(this.renderSees(node), issue);
            return issue;
        }

        private Issue renderDeprecation(DocCommentTree node) {
            Optional<DocTree> tag = node.getBlockTags().stream().filter(t -> t.getKind() == DocTree.Kind.DEPRECATED).findAny();
            if (tag.isPresent()) {
                Issue deprecationBeginning = Issue.NONE;
                if (node.getFirstSentence().size() == 0) {
                    deprecationBeginning = new Issue("Description starts with @deprecated", tag.get());
                }
                return this.reduce((Issue)this.scan(tag.get(), this._context), deprecationBeginning);
            }
            return Issue.NONE;
        }

        private Issue renderSees(DocCommentTree node) {
            Issue issue = Issue.NONE;
            Iterator sees = node.getBlockTags().stream().filter(t -> t.getKind() == DocTree.Kind.SEE).iterator();
            if (sees.hasNext()) {
                this.paragraph().code("See also ");
                while (sees.hasNext()) {
                    issue = this.reduce((Issue)this.scan((DocTree)sees.next(), this._context), issue);
                    if (!sees.hasNext()) continue;
                    this.code(", ");
                }
                this.code(".");
            }
            return issue;
        }

        @Override
        public String toString() {
            if (this._version != null) {
                this.paragraph();
                this.renderVersion(this._version);
            }
            if (this._privilege != null) {
                this.paragraph().code("***Required privileges:*** ").code(this._privilege);
            }
            if (MarkdownRenderer.this._renderMoRef && this._decl != null && this._decl.isManaged()) {
                this.renderMoRef(this._decl.getObject(), this._decl.isArray());
            }
            return super.toString();
        }

        void renderVersion(String version) {
            this.code("***Since:*** ").code(version);
        }

        private void renderMoRef(VmodlObject obj, boolean plural) {
            if (obj == null) {
                return;
            }
            this.paragraph();
            this.code("Refers instance");
            if (plural) {
                this.code("s");
            }
            this.code(" of ");
            this.code(MarkdownRenderer.this._linkResolver.getLink(obj, this._context)).code(".");
        }
    }

    class SummaryRenderer
    extends JavadocToMarkdown {
        public SummaryRenderer(StringBuilder buffer) {
            super(MarkdownRenderer.this._jdLinkResolver, buffer);
        }

        @Override
        public Issue visitDocComment(DocCommentTree node, JavadocLinkResolver.LinkContext context) {
            return (Issue)this.scan(node.getFirstSentence(), context);
        }
    }
}

