/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.info;

import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.model.Field;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListPrivileges
extends VmodlEmitter {
    private final String _folderPrefix;
    private final Kind _kind;
    private final OutputFormat _outputFormat;
    private ManagedObject _currentMo;
    private String _apiKind;
    private Kind _reportKind;
    private boolean _isFileOpened;
    private boolean _isHeaderWritten;

    public ListPrivileges(Map<String, String> options, String folder) {
        this._folderPrefix = folder + File.separator;
        Kind kind = null;
        String kindParameter = options.get("kind");
        if (kindParameter != null) {
            if (kindParameter.equals("anonymous")) {
                kind = Kind.ANONYMOUS;
            } else if (kindParameter.equals("dynamic")) {
                kind = Kind.DYNAMIC;
            } else if (kindParameter.equals("default")) {
                kind = Kind.DEFAULT;
            } else {
                throw new RuntimeException("Unsupported info.priv.kind: " + kindParameter);
            }
        }
        this._kind = kind;
        this._outputFormat = "csv".equals(options.get("format")) ? OutputFormat.CSV : OutputFormat.TXT;
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.prepareOutput();
        this.processObjectList(objects);
        this.setReportingContext(null, null, null);
        this.finalizeOutput();
    }

    private void processObjectList(Collection<VmodlObject> objects) {
        for (VmodlObject object : objects) {
            switch (object.getKind()) {
                case ManagedObject: {
                    ManagedObject managedObject = (ManagedObject)object;
                    if (this._kind != null) {
                        this.processManagedObject(managedObject, this._kind);
                        break;
                    }
                    this.processManagedObject(managedObject, Kind.ANONYMOUS);
                    this.processManagedObject(managedObject, Kind.DYNAMIC);
                    this.processManagedObject(managedObject, Kind.DEFAULT);
                    break;
                }
            }
            this.processObjectList(object.getNestedList());
        }
    }

    private void processManagedObject(ManagedObject mo, Kind kind) {
        this.setReportingContext(mo, "Methods", kind);
        for (Method method : mo.getMethodList()) {
            if (!this.shouldReport(method, mo, kind)) continue;
            this.reportApi(method);
        }
        this.setReportingContext(mo, "Managed properties", kind);
        for (Property property : mo.getPropertyListWithOverrides()) {
            if (!this.shouldReport(property.getPrivilegeId(), false, mo, kind)) continue;
            this.reportApi(property);
        }
    }

    private boolean shouldReport(Method method, ManagedObject mo, Kind kind) {
        boolean extraMethodCond = true;
        if (kind == Kind.DEFAULT) {
            extraMethodCond = !this.hasPrivilegeInParams(method);
        }
        return extraMethodCond && this.shouldReport(method.getPrivilegeId(), method.isDynamicPrivs(), mo, kind);
    }

    private boolean shouldReport(String privId, boolean isDynamic, ManagedObject mo, Kind kind) {
        switch (kind) {
            case ANONYMOUS: {
                return "System.Anonymous".equals(privId);
            }
            case DYNAMIC: {
                return isDynamic;
            }
            case DEFAULT: {
                return privId == null && !isDynamic && !mo.isSessionSpecific();
            }
        }
        return false;
    }

    private boolean hasPrivilegeInParams(Method method) {
        HashSet<String> seen = new HashSet<String>();
        for (Parameter param : method.getParameterList()) {
            if (!this.hasPrivilege(param, seen)) continue;
            return true;
        }
        return false;
    }

    private boolean hasPrivilege(Field field, Set<String> seen) {
        if (field.getPrivilegeId() != null) {
            return true;
        }
        VmodlDecl fieldDecl = field.getDecl();
        if (fieldDecl.getTypeId() == VmodlDecl.TypeId.DATA) {
            String doFullName = fieldDecl.getObject().getFullClassName();
            if (seen.contains(doFullName)) {
                return false;
            }
            seen.add(doFullName);
            for (Property prop : fieldDecl.getObject().getFullPropertyList()) {
                if (!this.hasPrivilege(prop, seen)) continue;
                return true;
            }
        }
        return false;
    }

    private void setReportingContext(ManagedObject managedObject, String apiKind, Kind reportKind) {
        if (this._outputFormat == OutputFormat.TXT) {
            if (!(!this._isHeaderWritten || this._apiKind.equals(apiKind) && this._reportKind.equals((Object)reportKind))) {
                this.unindent();
                this.emitLine();
                this._isHeaderWritten = false;
            }
            if (this._isFileOpened && managedObject != this._currentMo) {
                this.endFile();
                this._isFileOpened = false;
            }
        }
        this._currentMo = managedObject;
        this._apiKind = apiKind;
        this._reportKind = reportKind;
    }

    private void reportApi(VmodlApi vmodlApi) {
        switch (this._outputFormat) {
            case CSV: {
                this.reportApiInCsv(vmodlApi);
                break;
            }
            default: {
                this.reportApiInTxt(vmodlApi);
            }
        }
    }

    private void reportApiInCsv(VmodlApi vmodlApi) {
        this.emitPartial(this._currentMo.getQualifiedVmodlType(), ",");
        if ("Managed properties".equals(this._apiKind)) {
            this.emitPartial(",", vmodlApi.getName(), ",");
        } else {
            this.emitPartial(vmodlApi.getName(), ",,");
        }
        this.emitLine(this._reportKind.name());
    }

    private void reportApiInTxt(VmodlApi vmodlApi) {
        if (!this._isFileOpened) {
            this._isFileOpened = true;
            this.beginFile(this._currentMo);
            this.emitLine("Executables in ", this._currentMo.getQualifiedVmodlType(), ":");
            this.emitLine();
        }
        if (!this._isHeaderWritten) {
            this._isHeaderWritten = true;
            this.emitLine(this._apiKind, " with ", this._reportKind.toString(), " access:");
            this.indent();
        }
        this.emitLine("- ", vmodlApi.getName());
    }

    private void beginFile(VmodlObject object) {
        String fileName = object.getQualifiedVmodlType().replace(".", File.separator);
        this.beginFile(this._folderPrefix + fileName + ".txt");
    }

    private void prepareOutput() {
        if (this._outputFormat == OutputFormat.CSV) {
            this.beginFile(this._folderPrefix + Versions.getVmodlNamespace() + ".privs.csv");
            this.emitLine("Managed Object,Managed Method,Managed Property,", "Required Privileges");
        }
    }

    private void finalizeOutput() {
        if (this._outputFormat == OutputFormat.CSV) {
            this.endFile();
        }
    }

    static enum OutputFormat {
        TXT,
        CSV;

    }

    static enum Kind {
        ANONYMOUS,
        DYNAMIC,
        DEFAULT;

    }
}

