/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import com.sun.source.util.DocTreePath;
import emitters.ObjectRegistry;
import emitters.Utils;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.doc.JavadocLinkResolver;
import emitters.generators.joap.DummyRawObject;
import emitters.lists.CoreObjects;
import emitters.lists.ObjectSet;
import emitters.model.DataObject;
import emitters.model.DataProperty;
import emitters.model.Entity;
import emitters.model.Enum;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import emitters.wsdl.BaseXMLGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class JoapEmitter
extends VmodlEmitter {
    private static final String AT_LINK = "{@link ";
    private static final String AT_LINK_TERMINATORS = " #}\n";
    private static final String AT_SEE = "@see ";
    private static final String AT_SEE_TERMINATORS = " #)\n";
    protected final String _path;
    protected static Version _targetVersion;
    private String _InAnyPlaceholder;
    protected final DataObject _Any;
    protected final Map<String, DataObject> _methodParams;
    protected static final String AUTHN_HEADER = "vmware-api-session-id";
    protected static final String CORE_NAMESPACE = "core";
    protected static final String CORE_PACKAGE = "core.";
    protected static final String ANY_SCHEMA_NAME = "Any";
    protected static final String MOREF_SCHEMA_NAME = "ManagedObjectReference";
    protected static final String MOREF_VALUE_DOC = "A unique identifier (within this vCenter Server instance) for a specific managed object such as `group-d1` or `vm-015` or `ServiceInstance`.";
    protected static final String MOID_PARAM_NAME = "moId";
    protected static final String MOID_PARAM_SCHEMA_NAME = "moId";
    protected static final String DISCRIMINATOR = "_typeName";
    protected static final String PRIMITIVE_PREFIX = "Primitive";
    protected static final String ARRAY_WIRE_PREFIX = "ArrayOf";
    protected static final String ARRAY_SUFFIX = ".array";
    protected static final String ENUM_SUFFIX = ".enum";
    protected static final String PARAMS_SUFFIX = ".params";
    protected static final String ARRAY;
    protected static final String ENUM;
    protected static final String PARAMS;
    protected static final ObjectSet CORE_OBJECTS;
    protected static final Primitive[] PRIMITIVES;

    protected JoapEmitter(String path) {
        this._path = path;
        _targetVersion = Versions.getTargetVersion();
        this._Any = this.createAnyType();
        JoapEmitter.setDefaultBase(this._Any);
        this._methodParams = new HashMap<String, DataObject>();
    }

    private DataObject createAnyType() {
        DummyRawObject rawAny = new DummyRawObject(ANY_SCHEMA_NAME, "The base of all data types. Not to be used directly on the wire.");
        DataObject Any2 = new DataObject(rawAny, null);
        Any2.setVersion(Version._root);
        VmodlDecl stringDecl = new VmodlDecl(VmodlDecl.TypeId.STRING);
        String desc = "The type discriminator. Refers to the name of a valid data object type.";
        JoapEmitter.addDataProperty(Any2, DISCRIMINATOR, stringDecl, null, desc, null);
        return Any2;
    }

    protected DataObject createMoRef(Enum moTypes, boolean typePropertyIsEnum) {
        VmodlDecl stringDecl;
        String description = "The ManagedObjectReference data object type is a special-purpose data object. Commonly referred to as simply a \"reference\", \"MoRef\", \"MOR\", or other variations of this theme, instances of managed object references contain data that identifies specific server-side managed objects. Managed object references are typically one of the return types from a method invocation.\n\nManaged object references are client application references to server-side managed objects. The client application uses ManagedObjectReference objects when it invokes operations on a server. A ManagedObjectReference is guaranteed to be unique and persistent during an object's lifetime. The reference persists after an object has moved within the inventory, across sessions, and across server restarts. If you remove an object, for example, a virtual machine, from the inventory, and then put it back, the reference changes.";
        DummyRawObject rawMoRef = new DummyRawObject(MOREF_SCHEMA_NAME, description);
        DataObject moRef = new DataObject(rawMoRef, null);
        moRef.setVersion(Version._root);
        moRef.setBaseObject(this._Any);
        VmodlDecl moTypesDecl = stringDecl = new VmodlDecl(VmodlDecl.TypeId.STRING);
        String typeDescription = "The name of the Managed Object type this ManagedObjectReference refers to.";
        if (moTypes != null) {
            if (typePropertyIsEnum) {
                moTypesDecl = new VmodlDecl(VmodlDecl.TypeId.ENUM, moTypes);
            } else {
                typeDescription = typeDescription + " See " + this.getLink(moTypes, JavadocLinkResolver.LinkContext.DATA_OBJECT) + " for a list of possible values.";
            }
        }
        JoapEmitter.addDataProperty(moRef, "type", moTypesDecl, null, typeDescription, null);
        JoapEmitter.addDataProperty(moRef, "value", stringDecl, null, MOREF_VALUE_DOC, null);
        return moRef;
    }

    private static void setDefaultBase(DataObject defaultBase) {
        for (VmodlObject object : ObjectRegistry.getAllObjects()) {
            DataObject dataObject;
            if (object.getKind() != VmodlObject.Kind.DataObject || (dataObject = (DataObject)object).getBaseObject() != null) continue;
            dataObject.setBaseObject(defaultBase);
        }
    }

    private DataObject createParamsType(Method method, String comment) {
        DataObject paramsType = this.createHelperType(BaseXMLGenerator.getNonTaskWsdlName(method.getWsdlName()) + "RequestType", comment);
        paramsType.setVersion(method.getVersion());
        for (Parameter parameter : method.getParameterList()) {
            DataProperty dataProperty = new DataProperty(paramsType, parameter.getName(), null, parameter.getDecl(), false, parameter.getPrivilegeId(), parameter.getVersion(), null, -1, parameter.getDocSupplier());
            paramsType.addProperty(dataProperty);
        }
        return paramsType;
    }

    private DataObject createHelperType(String name, String comment) {
        DummyRawObject rawHelper = new DummyRawObject(name, comment);
        DataObject helperType = new DataObject(rawHelper, null);
        return helperType;
    }

    protected BoxedPair createBoxedPrimitive(Primitive primitive) {
        String typeName = primitive.typeName;
        String comment = "A boxed " + primitive.typeName + " primitive" + this.getInAnyPlaceholder();
        DataObject boxedPrimitive = this.createHelperType(PRIMITIVE_PREFIX + typeName, comment);
        VmodlDecl primitiveDecl = new VmodlDecl(primitive.typeId);
        this.initBoxedType(boxedPrimitive, primitiveDecl);
        DataObject boxedPrimitiveArray = this.createBoxedArray(primitive.typeId, null, typeName, boxedPrimitive);
        return new BoxedPair(boxedPrimitive, boxedPrimitiveArray);
    }

    protected BoxedPair createBoxedEnum(Enum enum_) {
        String comment = "A boxed " + this.getLink(enum_, JavadocLinkResolver.LinkContext.DATA_OBJECT) + this.getInAnyPlaceholder();
        DataObject boxedEnum = this.createHelperType(enum_.getJsonName(), comment);
        VmodlDecl enumDecl = new VmodlDecl(VmodlDecl.TypeId.ENUM, enum_);
        this.initBoxedType(boxedEnum, enumDecl);
        return new BoxedPair(boxedEnum, this.createBoxedArray(VmodlDecl.TypeId.ENUM, enum_));
    }

    protected DataObject createBoxedArray(DataObject dataObject) {
        return this.createBoxedArray(VmodlDecl.TypeId.DATA, dataObject);
    }

    protected DataObject createBoxedArray(VmodlDecl.TypeId typeId, VmodlObject object) {
        return this.createBoxedArray(typeId, object, object.getJsonName(), null);
    }

    protected DataObject createBoxedArray(VmodlDecl.TypeId typeId, VmodlObject object, String name, VmodlApi linkElement) {
        String comment = "A boxed array of " + this.getLink(object == null ? linkElement : object, JavadocLinkResolver.LinkContext.DATA_OBJECT) + this.getInAnyPlaceholder();
        DataObject boxedArray = this.createHelperType(ARRAY_WIRE_PREFIX + name, comment);
        VmodlDecl arrayDecl = new VmodlDecl(typeId, object);
        arrayDecl.setArray();
        this.initBoxedType(boxedArray, arrayDecl);
        return boxedArray;
    }

    private void initBoxedType(DataObject boxedType, VmodlDecl decl) {
        boxedType.setVersion(JoapEmitter.getVersion(decl));
        boxedType.setBaseObject(this._Any);
        JoapEmitter.addDataProperty(boxedType, "_value", decl);
    }

    private static void addDataProperty(VmodlObject container, String name, VmodlDecl decl) {
        JoapEmitter.addDataProperty(container, name, decl, null, null, null);
    }

    private static void addDataProperty(VmodlObject container, String name, VmodlDecl decl, Supplier<DocTreePath> documentation, String comment, String privilege) {
        DataProperty dataProperty = new DataProperty(container, name, null, decl, false, privilege, JoapEmitter.getVersion(decl), comment, -1, documentation);
        container.addProperty(dataProperty);
    }

    private static Version getVersion(VmodlDecl decl) {
        VmodlObject object = decl.getObject();
        return object != null ? object.getVersion() : Version._root;
    }

    protected static boolean shouldEmit(VmodlApi vmodlApi) {
        if (vmodlApi.isInternal()) {
            return false;
        }
        return JoapEmitter.shouldEmit((Entity)vmodlApi);
    }

    protected static boolean shouldEmit(Entity versioned) {
        VmodlObject obj;
        VmodlObject container;
        if (!JoapEmitter.shouldEmit(versioned.getVersion())) {
            return false;
        }
        if (versioned instanceof VmodlObject && (container = (obj = (VmodlObject)versioned).getContainer()) != null) {
            return JoapEmitter.shouldEmit((Entity)container);
        }
        return true;
    }

    private static boolean shouldEmit(Version version) {
        return _targetVersion.isAncestor(version);
    }

    protected DataObject registerMethodParams(Method method) {
        List<Parameter> parameters = method.getParameterList();
        if (parameters.isEmpty()) {
            return null;
        }
        String comment = "The parameters of " + this.getLink(method, JavadocLinkResolver.LinkContext.METHOD_PARAMS) + ".";
        String id = method.getContainer().getJsonName() + "." + method.getName();
        return this._methodParams.computeIfAbsent(id, m -> this.createParamsType(method, comment));
    }

    protected String updateJavadocLinks(String comment, VmodlObject context) {
        if (comment == null) {
            return null;
        }
        comment = this.updateLinks(comment, context, AT_LINK, AT_LINK_TERMINATORS);
        return this.updateLinks(comment, context, AT_SEE, AT_SEE_TERMINATORS);
    }

    private String updateLinks(String comment, VmodlObject context, String prefix, String terminators) {
        int pos;
        StringBuilder result = new StringBuilder();
        int offset = 0;
        while ((pos = comment.indexOf(prefix, offset)) != -1) {
            int idStart = pos + prefix.length();
            while (comment.charAt(idStart) == ' ') {
                ++idStart;
            }
            result.append(comment.substring(offset, idStart));
            pos = idStart;
            while (terminators.indexOf(comment.charAt(pos)) == -1) {
                ++pos;
            }
            if (pos != idStart) {
                String vmodlName = comment.substring(idStart, pos);
                VmodlObject object = this.getObject(vmodlName, context);
                result.append(this.getLink(object, JavadocLinkResolver.LinkContext.DATA_OBJECT));
            }
            offset = pos;
        }
        if (offset == 0) {
            return comment;
        }
        result.append(comment.substring(offset));
        return result.toString();
    }

    private VmodlObject getObject(String vmodlName, VmodlObject context) {
        if (ANY_SCHEMA_NAME.equals(vmodlName)) {
            return this._Any;
        }
        VmodlObject result = ObjectRegistry.getObject(vmodlName);
        if (result != null) {
            return result;
        }
        String path = context.getQualifiedVmodlType();
        while ((result = ObjectRegistry.getObject(path + "." + vmodlName)) == null) {
            int pos = path.lastIndexOf(".");
            if (pos == -1) {
                throw new RuntimeException("Unknown reference to " + vmodlName + " in " + context.getQualifiedVmodlType());
            }
            path = path.substring(0, pos);
        }
        return result;
    }

    private String getInAnyPlaceholder() {
        if (this._InAnyPlaceholder == null) {
            this._InAnyPlaceholder = ". To be used in " + this.getLink(this._Any, JavadocLinkResolver.LinkContext.DATA_OBJECT) + " placeholders.";
        }
        return this._InAnyPlaceholder;
    }

    protected abstract String getLink(VmodlApi var1, JavadocLinkResolver.LinkContext var2);

    static {
        ARRAY = JoapEmitter.capitalize(ARRAY_SUFFIX.substring(1));
        ENUM = JoapEmitter.capitalize(ENUM_SUFFIX.substring(1));
        PARAMS = JoapEmitter.capitalize(PARAMS_SUFFIX.substring(1));
        CORE_OBJECTS = new CoreObjects().extend(Utils.DynamicDataClassName);
        PRIMITIVES = new Primitive[]{new Primitive("Boolean", VmodlDecl.TypeId.BOOLEAN, "boolean"), new Primitive("Byte", VmodlDecl.TypeId.BYTE, "byte"), new Primitive("Short", VmodlDecl.TypeId.SHORT, "short"), new Primitive("Int", VmodlDecl.TypeId.INT, "int"), new Primitive("Long", VmodlDecl.TypeId.LONG, "long"), new Primitive("Float", VmodlDecl.TypeId.FLOAT, "float"), new Primitive("Double", VmodlDecl.TypeId.DOUBLE, "double"), new Primitive("String", VmodlDecl.TypeId.STRING, "string"), new Primitive("DateTime", VmodlDecl.TypeId.DATETIME, "dateTime"), new Primitive("URI", VmodlDecl.TypeId.URI, "anyURI"), new Primitive("Binary", VmodlDecl.TypeId.BINARY, "base64Binary"), new Primitive("TypeName", VmodlDecl.TypeId.TYPENAME, "TypeName"), new Primitive("PropPath", VmodlDecl.TypeId.PROPPATH, "PropertyPath"), new Primitive("MethodName", VmodlDecl.TypeId.METHODNAME, "MethodName")};
    }

    protected static class Primitive {
        String typeName;
        VmodlDecl.TypeId typeId;
        String wsdlName;

        Primitive(String typeName_, VmodlDecl.TypeId typeId_, String wsdlName_) {
            this.typeName = typeName_;
            this.typeId = typeId_;
            this.wsdlName = wsdlName_;
        }
    }

    protected class BoxedPair {
        final DataObject _boxedObject;
        final DataObject _boxedArray;

        BoxedPair(DataObject boxedObject, DataObject boxedArray) {
            this._boxedObject = boxedObject;
            this._boxedArray = boxedArray;
        }
    }
}

