/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import com.sun.source.util.DocTreePath;
import emitters.ObjectRegistry;
import emitters.Utils;
import emitters.Versions;
import emitters.doc.JavadocLinkResolver;
import emitters.doc.MarkdownRenderer;
import emitters.generators.joap.DummyRawObject;
import emitters.generators.joap.JoapEmitter;
import emitters.generators.joap.MoTypesList;
import emitters.generators.joap.ObjectsEnumerator;
import emitters.generators.joap.OpenAPIDisabledLinkResolver;
import emitters.generators.joap.OpenAPIEveLinkResolver;
import emitters.generators.joap.OpenAPILinkResolver;
import emitters.lists.CoreObjects;
import emitters.model.DataObject;
import emitters.model.Documented;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Namespace;
import emitters.model.Product;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpenAPI3
extends JoapEmitter {
    private final String _baseUrl;
    private final String _release;
    private final boolean _eve;
    private final String _pathToDescription;
    private final String _pathToTranscoderDescription;
    private final String _defaultNamespace;
    private final Set<ManagedObject> _managedObjects;
    private final Set<DataObject> _dataObjects;
    private final Set<VmodlObject> _responseObjects;
    private final Set<Enum> _enums;
    private final Set<Namespace> _namespaces;
    private final OpenAPILinkResolver _linkResolver;
    private final MarkdownRenderer _docRenderer;
    private final DataObject _MoRef;
    private final MoTypesList _moTypesList;
    private static final Comparator<VmodlApi> NameComparator = new Comparator<VmodlApi>(){

        @Override
        public int compare(VmodlApi lhs, VmodlApi rhs) {
            return lhs.getName().compareTo(rhs.getName());
        }
    };
    private static final Comparator<VmodlObject> VmodlObjectComparator = new Comparator<VmodlObject>(){

        @Override
        public int compare(VmodlObject lhs, VmodlObject rhs) {
            return lhs.getJsonName().compareTo(rhs.getJsonName());
        }
    };
    private static final String SECURITY_SCHEME_NAME = "Session";
    private static final String VERSION_PARAM_NAME = "release";
    private static final String VERSION_PARAM_SCHEMA_NAME = "release";
    private static final String TRANSCODER_TAG = "WireFormatTranscoder";
    private static final String TRANSCODER_ERROR_ID = "ViTranscoderErrorResponse";
    private static final List<DataObject> NO_FAULTS = Collections.emptyList();
    private static final Collection<VmodlObject> OBJECTS_TO_SKIP = new CoreObjects().extend(Utils.DynamicDataClassName, Utils.ManagedObjectReferenceClassName);
    private static final String BYTE_MIN = "-128";
    private static final String BYTE_MAX = "127";
    private static final String SHORT_MIN = "-32768";
    private static final String SHORT_MAX = "32767";
    private static final String APPLICATION_JSON = "application/json:";
    private static final String INDENT_SPACES = "  ";

    public OpenAPI3(Map<String, String> options, String path) {
        super(path);
        Product p;
        LinkedHashSet<String> releases;
        this._defaultNamespace = options.get("default.namespace");
        this._baseUrl = _targetVersion.getWireNs();
        String profile = options.get("profile");
        if (profile == null || profile.equals("public")) {
            this._linkResolver = new OpenAPIDisabledLinkResolver();
            this._eve = false;
        } else if (profile.equals("eve")) {
            String baseUrl = this._baseUrl + "/" + "release" + "/";
            this._linkResolver = new OpenAPIEveLinkResolver(baseUrl, this._defaultNamespace);
            this._eve = true;
        } else {
            throw new RuntimeException("Unknown profile: " + profile);
        }
        boolean warnOnWrongThrowsJavadoc = Boolean.valueOf(options.get("validate.javadoc.throws"));
        this._docRenderer = new MarkdownRenderer(this._linkResolver, this._linkResolver, !this._eve, this._defaultNamespace, warnOnWrongThrowsJavadoc);
        this._pathToDescription = options.get("description");
        this._pathToTranscoderDescription = options.get("transcoderDescription");
        ObjectsEnumerator enumerator = OpenAPI3.enumerateObjects(this._defaultNamespace);
        this._managedObjects = enumerator.getManagedObjects();
        this._dataObjects = enumerator.getDataObjects();
        this._enums = enumerator.getEnums();
        Enum moTypesEnum = MoTypesList.createEnum();
        this._moTypesList = new MoTypesList(moTypesEnum);
        this._MoRef = this.createMoRef(moTypesEnum, !this._eve);
        if (this._eve) {
            this._responseObjects = new HashSet<VmodlObject>();
            this._namespaces = new LinkedHashSet<Namespace>();
        } else {
            this._responseObjects = Collections.emptySet();
            this._namespaces = Collections.emptySet();
        }
        this.setIndentSpaces(INDENT_SPACES);
        String release = _targetVersion.getWireId();
        if (Product.products.size() == 1 && !(releases = (p = Product.products.values().iterator().next()).getViJsonReleases()).isEmpty()) {
            release = (String)releases.iterator().next();
        }
        this._release = release;
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.beginFile(this._path);
        this.emitHeader("Virtual Infrastructure JSON API");
        this.emitLine("paths:", INDENT);
        for (ManagedObject managedObject : this._managedObjects) {
            this.emitMethods(managedObject);
            this.emitManagedPropertyGetters(managedObject);
        }
        if (this._eve) {
            this.emitTranscoderOperation();
        }
        this.unindent();
        this.emitLine("tags:", INDENT);
        this.emitNamespaces();
        this._managedObjects.forEach(this::emitTag);
        if (this._eve) {
            this.emitTranscoderTag();
        }
        this.unindent();
        this.emitLine("components:", INDENT);
        this.emitLine("securitySchemes:", INDENT);
        this.emitLine(SECURITY_SCHEME_NAME, ":");
        this.indent();
        this.emitLine("type: apiKey");
        this.emitLine("in: header");
        this.emitLine("name: ", "vmware-api-session-id");
        this.emitLine("description: A session token, placed in the `", "vmware-api-session-id", "` HTTP header, returned by the `Login` operation of the `SessionManager` interface.");
        this.unindent();
        this.unindent();
        this.emitLine("schemas:", INDENT);
        this.emitCoreObjects();
        this.emitMethodParamsObjects();
        this.emitDataObjects();
        this.emitEnums();
        this.unindent();
        this.emitLine("parameters:", INDENT);
        if (this._eve) {
            this.emitVersionParameter();
        } else {
            this.emitMoIdParameter();
        }
        this.unindent();
        this.unindent();
        this.endFile();
    }

    private void emitHeader(String title) {
        this.emitLine("openapi: 3.0.0");
        this.emitLine("info:", INDENT);
        this.emitLine("title: ", OpenAPI3.qs(title));
        this.emitLine("version: ", this._release);
        if (this._pathToDescription != null) {
            String description;
            Path p = Paths.get(this._pathToDescription, new String[0]);
            try {
                description = new String(Files.readAllBytes(p), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while reading description file " + p.toAbsolutePath(), e);
            }
            description = description.replace("{$RELEASE}", this._release);
            this.emitOpenAPI_description(description);
        }
        this.unindent();
        this.emitGap();
        this.pushIndent();
        this.emitLine("servers:", INDENT);
        this.emitPartial("- url: https://{vcenter-host}/", this._baseUrl);
        if (!this._eve) {
            this.emitPartial("/{", "release", "}");
        }
        this.emitLine();
        this.indent();
        this.emitLine("variables:", INDENT);
        this.emitLine("vcenter-host:", INDENT);
        this.emitLine("default: localhost");
        if (!this._eve) {
            this.unindent();
            this.emitLine("release", ":");
            this.indent();
            this.emitLine("default: ", this._release);
            this.emitVersionParamDescription();
        }
        this.popIndent();
        this.emitGap();
    }

    private void emitVersionParamDescription() {
        this.emitLine("description: The vSphere release schema. The current specification covers vSphere ", this._release, " APIs.");
    }

    private void emitMethods(ManagedObject managedObject) {
        String moType = this._linkResolver.getId(managedObject);
        for (Method method : OpenAPI3.getReleasedMethods(managedObject)) {
            VmodlDecl result;
            this.pushIndent();
            Version version = method.getVersion();
            String xVmwDocAddedIn = this._eve && version.isNonInitialViJsonRelease() ? version.getDisplayName() : null;
            this.emitOperation(version, moType, this._linkResolver.getId(method), this._linkResolver.getOperationId(managedObject, method), this._linkResolver.getHttpMethod(method), this._docRenderer.renderSummary(method), this._docRenderer.renderDescription(method, method.getPrivilegeId(), null), "method", xVmwDocAddedIn, OpenAPI3.isAnonymous(method.getPrivilegeId()), method.isDeprecated());
            DataObject methodParams = this.registerMethodParams(method);
            if (methodParams != null) {
                this.emitRequestBody(this._linkResolver.getId(methodParams));
            }
            VmodlDecl vmodlDecl = result = method.isTask() ? Method.taskReturnDecl() : method.getReturnDecl();
            if (this._eve) {
                this._responseObjects.add(result.getObject());
            }
            DocTreePath returnJavadoc = method.isTask() ? method.getTaskDoc() : method.getReturnDoc();
            String returnDoc = this._docRenderer.renderDescription(returnJavadoc, result, JavadocLinkResolver.LinkContext.getMethodContext(version, this._defaultNamespace));
            String faultsDoc = this._docRenderer.renderFaults(method);
            this.emitResponse(result, returnDoc, method.getFaultList(), faultsDoc);
            this.popIndent();
            this.emitGap();
        }
    }

    private void emitNamespaces() {
        for (Namespace ns : this._namespaces) {
            this.emitTag(ns.getDisplayName(), ns);
        }
    }

    private void emitTag(ManagedObject managedObject) {
        this.emitTag(this._linkResolver.getId(managedObject), managedObject);
    }

    private void emitTag(String name, Documented documented) {
        if (TRANSCODER_TAG.equals(name) && this._eve) {
            throw new RuntimeException("Transcoder tag collision!");
        }
        String description = this._docRenderer.renderDescription(documented);
        if (description == null || description.length() == 0) {
            return;
        }
        this.emitLine("- name: ", name);
        this.indent();
        this.emitOpenAPI_description(description);
        this.unindent();
    }

    private static boolean isAnonymous(String privilige) {
        return "System.Anonymous".equals(privilige);
    }

    private void emitManagedPropertyGetters(ManagedObject managedObject) {
        String moType = this._linkResolver.getId(managedObject);
        for (Property property : OpenAPI3.getReleasedProperties(managedObject)) {
            this.pushIndent();
            Version version = property.getVersion();
            String xVmwDocAddedIn = this._eve && version.isNonInitialViJsonRelease() ? version.getDisplayName() : null;
            this.emitOperation(version, moType, this._linkResolver.getId(property), this._linkResolver.getOperationId(managedObject, property), this._linkResolver.getHttpMethod(property), this._docRenderer.renderSummary(property), this._docRenderer.renderDescription(property, property.getPrivilegeId(), null), "property", xVmwDocAddedIn, OpenAPI3.isAnonymous(property.getPrivilegeId()), property.getDecl().isDeprecated());
            String returnDoc = this._docRenderer.renderDescription(property.getReturnDoc(), property.getDecl(), JavadocLinkResolver.LinkContext.getPropertyContext(version, this._defaultNamespace));
            if (this._eve) {
                this._responseObjects.add(property.getDecl().getObject());
            }
            this.emitResponse(property.getDecl(), returnDoc, NO_FAULTS, null);
            this.popIndent();
            this.emitGap();
        }
    }

    private void emitOperation(Version version, String typeName, String resource, String operationId, String httpMethod, String summary, String comment, String entity, String xVmwDocAddedIn, boolean anonymous, boolean deprecated) {
        Namespace ns;
        boolean satellite;
        this.emitOperationSchema();
        boolean bl = satellite = !version.isBaseNamespace(this._defaultNamespace);
        if (satellite) {
            this.emitPartial("/", version.getNamespace());
            ns = Versions.getNamespace(version.getNamespace());
        } else {
            ns = Versions.getNamespace(this._defaultNamespace);
        }
        this.emitLine("/", typeName, "/{", "moId", "}/", resource, ":");
        this.emitLine(INDENT, httpMethod, ":");
        this.indent();
        this.emitPartial("tags: [");
        if (this._eve && this._defaultNamespace != null) {
            String navTag = version.getNamespace();
            if (ns != null) {
                navTag = ns.getDisplayName();
                this._namespaces.add(ns);
            }
            this.emitPartial(navTag, ", ");
        }
        this.emitLine(typeName, "]");
        this.emitOpenAPI_summary(summary);
        this.emitLine("operationId: ", operationId);
        if (deprecated) {
            this.emitLine("deprecated: true");
        }
        if (xVmwDocAddedIn != null) {
            this.emitLine("x-vmw-doc-added-in: ", xVmwDocAddedIn);
        }
        this.emitOpenAPI_description(comment);
        this.emitLine("parameters:", INDENT);
        if (this._eve) {
            this.emitMoIdParameter(typeName, entity);
        } else {
            this.emitLine("- $ref: '#/components/parameters/", "moId", "'");
        }
        this.emitOperationSchemaParams();
        this.unindent();
        this.emitLine("security:", INDENT);
        this.emitLine("- ", SECURITY_SCHEME_NAME, ": []");
        if (anonymous) {
            this.emitLine("- {}");
        }
        this.unindent();
    }

    private void emitOperationSchema() {
        if (this._eve) {
            this.emitPartial("/{", "release", "}");
        }
    }

    private void emitOperationSchemaParams() {
        if (this._eve) {
            this.emitLine("- $ref: '#/components/parameters/", "release", "'");
        }
    }

    private void emitRequestBody(String schemaId) {
        this.pushIndent();
        this.emitLine("requestBody:", INDENT);
        this.emitLine("required: true");
        this.emitContentTags();
        this.emitRef(schemaId);
        this.popIndent();
    }

    private void emitResponse(VmodlDecl result, String returnDoc, List<DataObject> faults, String faultsDescription) {
        this.emitLine("responses:", INDENT);
        this.pushIndent();
        if (result.getTypeId() == VmodlDecl.TypeId.VOID) {
            this.emitLine("'204':", INDENT);
            this.emitOpenAPI_description("No Content");
        } else {
            this.emitLine("'200':", INDENT);
            this.emitOpenAPI_description(returnDoc, "OK");
            this.emitContentTags();
            if (result.isOptional()) {
                this.emitLine("nullable: true");
            }
            this.emitDecl(result);
        }
        this.popIndent();
        if (faults.size() > 0) {
            this.emitLine("'500':", INDENT);
            this.emitOpenAPI_description(faultsDescription, "Failure");
            this.emitContentTags();
            this.emitRef(this.getCommonAncestor(faults));
        }
    }

    VmodlObject getCommonAncestor(List<DataObject> faults) {
        VmodlObject firstFault = faults.get(0);
        if (faults.size() == 1) {
            return firstFault;
        }
        ArrayList<VmodlObject> faultsList = this.getParentsList(firstFault);
        int index = 0;
        block0: for (DataObject fault : faults) {
            ArrayList<VmodlObject> parentsList = this.getParentsList(fault);
            int faultsIndex = faultsList.size();
            int parentsIndex = parentsList.size();
            while (faultsIndex > index && parentsIndex > 0) {
                if (faultsList.get(--faultsIndex) == parentsList.get(--parentsIndex)) continue;
                index = faultsIndex + 1;
                continue block0;
            }
        }
        return faultsList.get(index);
    }

    ArrayList<VmodlObject> getParentsList(VmodlObject fault) {
        ArrayList<VmodlObject> result = new ArrayList<VmodlObject>();
        do {
            result.add(fault);
        } while ((fault = fault.getBaseObject()) != null);
        return result;
    }

    private void emitContentTags() {
        this.emitLine("content:", INDENT);
        this.emitLine(APPLICATION_JSON, INDENT);
        this.emitLine("schema:", INDENT);
    }

    private void emitCoreObjects() {
        this.emitAnySchema();
        this.emitMoRefSchema();
        for (JoapEmitter.Primitive primitive : PRIMITIVES) {
            this.emitBoxedPrimitive(primitive);
        }
    }

    private void emitAnySchema() {
        this.emitSchemaObject(this._Any, false);
        this.pushIndent();
        this.emitLine(INDENT, "discriminator:");
        this.emitLine(INDENT, "propertyName: ", "_typeName");
        this.emitLine("mapping:");
        this.indent();
        for (JoapEmitter.Primitive p : PRIMITIVES) {
            this.emitLine(p.wsdlName, ": '#/components/schemas/", "Primitive", p.typeName, "'");
            String arrayItemsType = OpenAPI3.capitalize(p.wsdlName);
            if (arrayItemsType.equals(p.typeName)) continue;
            this.emitLine("ArrayOf", arrayItemsType, ": '#/components/schemas/", "ArrayOf", p.typeName, "'");
        }
        this.unindent();
        this.popIndent();
        this.emitGap();
        this.emitSchemaObject(this.createBoxedArray(VmodlDecl.TypeId.DATA, this._Any, "AnyType", null));
    }

    private void emitMoRefSchema() {
        this.emitSchemaObject(this._MoRef, !this._eve);
        if (this._eve) {
            this.pushIndent();
            this.emitLine(INDENT, "discriminator:");
            this.emitLine(INDENT, "propertyName: type");
            this.emitLine("mapping:", INDENT);
            for (ManagedObject managedObject : this._managedObjects) {
                this.emitPartial(this._linkResolver.getId(managedObject), ": ");
                this.emitSchemaRef(this.getMoRefSchemaName(managedObject));
            }
            this.popIndent();
            this.emitGap();
            this._managedObjects.forEach(this::emitMoRefSchema);
        }
        this.emitEnumSchema(this._moTypesList.fillEnum(this._managedObjects));
        this.emitSchemaObject(this.createBoxedArray(this._MoRef));
    }

    private void emitMoRefSchema(ManagedObject managedObject) {
        VmodlObject base = managedObject.getBaseObject();
        if (base == null) {
            return;
        }
        String schemaName = this.getMoRefSchemaName(managedObject);
        String description = "Reference to an instance of the " + this.getLink(managedObject, JavadocLinkResolver.LinkContext.DATA_OBJECT) + " managed object.";
        DummyRawObject rawMoRef = new DummyRawObject(schemaName, description);
        DataObject moRef = new DataObject(rawMoRef, null);
        moRef.setVersion(managedObject.getVersion());
        moRef.setBaseObject(base.getBaseObject() == null ? this._MoRef : base);
        this.emitSchemaObject(moRef);
    }

    private String getMoRefSchemaName(ManagedObject managedObject) {
        if (this._eve && managedObject.getBaseObject() != null) {
            return "MoRef" + this._linkResolver.getId(managedObject);
        }
        return "ManagedObjectReference";
    }

    private void emitBoxedPrimitive(JoapEmitter.Primitive primitive) {
        JoapEmitter.BoxedPair boxedPair = this.createBoxedPrimitive(primitive);
        this.emitSchemaObject(boxedPair._boxedObject);
        this.emitSchemaObject(boxedPair._boxedArray);
    }

    private void emitMethodParamsObjects() {
        DataObject[] methodParamsList = this._methodParams.values().toArray(new DataObject[0]);
        Arrays.sort(methodParamsList, VmodlObjectComparator);
        JavadocLinkResolver.LinkContext context = this._eve ? JavadocLinkResolver.LinkContext.DISABLED : null;
        for (DataObject methodParams : methodParamsList) {
            this.emitSchemaObject(methodParams, context, true);
        }
    }

    private void emitDataObjects() {
        for (DataObject dataObject : this._dataObjects) {
            this.emitSchemaObject(dataObject);
            this.emitSchemaObject(this.createBoxedArray(dataObject));
        }
        if (this._eve) {
            this.emitTranscoderErrorDefinition();
        }
    }

    private void emitEnums() {
        for (Enum enum_ : this._enums) {
            if (!OpenAPI3.shouldEmit(enum_)) continue;
            this.emitEnumSchema(enum_);
            if (enum_.isConstants()) continue;
            JoapEmitter.BoxedPair boxedPair = this.createBoxedEnum(enum_);
            this.emitSchemaObject(boxedPair._boxedObject);
            this.emitSchemaObject(boxedPair._boxedArray);
        }
    }

    private void emitEnumSchema(Enum enum_) {
        this.pushIndent();
        this.emitSchemaEntry(this._linkResolver.getId(enum_));
        this.emitLine("type: string");
        this.emitOpenAPI_description(this._docRenderer.renderDescription(enum_));
        this.emitLine("enum:", INDENT);
        for (int i = 0; i < enum_.getValueList().size(); ++i) {
            if (!MarkdownRenderer.shouldEmitEnumValue(enum_, i)) continue;
            this.emitLine("- ", enum_.getValueList().get(i));
        }
        this.emitGap();
        this.popIndent();
    }

    private void emitSchemaObject(DataObject object) {
        this.emitSchemaObject(object, true);
    }

    private void emitSchemaObject(DataObject object, JavadocLinkResolver.LinkContext context, boolean withPrivilege) {
        this.emitSchemaObject(object, true, context, withPrivilege);
    }

    private void emitSchemaObject(DataObject object, boolean emitGap) {
        JavadocLinkResolver.LinkContext context = this._eve && this._responseObjects.contains(object) ? JavadocLinkResolver.LinkContext.DISABLED : null;
        this.emitSchemaObject(object, emitGap, context, false);
    }

    private void emitSchemaObject(DataObject object, boolean emitGap, JavadocLinkResolver.LinkContext context, boolean withPrivilege) {
        this.pushIndent();
        this.emitSchemaEntry(this._linkResolver.getId(object));
        this.emitOpenAPI_object(object, context, withPrivilege);
        if (emitGap) {
            this.emitGap();
        }
        this.popIndent();
    }

    private void emitSchemaEntry(String id) {
        if (TRANSCODER_ERROR_ID.equals(id) && this._eve) {
            throw new RuntimeException("Transcoder error ID collision!");
        }
        this.emitLine(id, ":");
        this.indent();
    }

    private void emitDashRef(VmodlObject object) {
        this.emitPartial("- ");
        this.emitRef(object);
    }

    private void emitRef(VmodlObject object) {
        String ref = object.getKind() == VmodlObject.Kind.ManagedObject ? this.getMoRefSchemaName((ManagedObject)object) : this._linkResolver.getId(object);
        this.emitRef(ref);
    }

    private void emitRef(String typeName) {
        this.emitPartial("$ref: ");
        this.emitSchemaRef(typeName);
    }

    private void emitSchemaRef(String schemaId) {
        this.emitLine("'#/components/schemas/", schemaId, "'");
    }

    private void emitDecl(VmodlDecl decl) {
        if (decl.isArray()) {
            this.emitLine("type: array");
            this.emitLine("items:", INDENT);
        }
        switch (decl.getTypeId()) {
            case BOOLEAN: {
                this.emitOpenAPI_type("boolean");
                break;
            }
            case BYTE: {
                this.emitOpenAPI_int(BYTE_MIN, BYTE_MAX);
                break;
            }
            case SHORT: {
                this.emitOpenAPI_int(SHORT_MIN, SHORT_MAX);
                break;
            }
            case INT: {
                this.emitOpenAPI_type("integer", "int32");
                break;
            }
            case LONG: {
                this.emitOpenAPI_type("integer", "int64");
                break;
            }
            case FLOAT: {
                this.emitOpenAPI_type("number", "float");
                break;
            }
            case DOUBLE: {
                this.emitOpenAPI_type("number", "double");
                break;
            }
            case BINARY: {
                this.emitOpenAPI_type("string", "byte");
                break;
            }
            case DATETIME: {
                this.emitOpenAPI_type("string", "date-time");
                break;
            }
            case URI: 
            case METHODNAME: 
            case PROPPATH: 
            case TYPENAME: {
                this.emitOpenAPI_type("string");
                return;
            }
            case STRING: {
                if (decl.isSecret()) {
                    this.emitOpenAPI_type("string", "password");
                    break;
                }
                this.emitOpenAPI_type("string");
                break;
            }
            case ANY: {
                this.emitRef("Any");
                break;
            }
            case MANAGED: {
                VmodlObject mo = decl.getObject();
                String moSchema = mo == null ? "ManagedObjectReference" : this.getMoRefSchemaName((ManagedObject)decl.getObject());
                this.emitRef(moSchema);
                break;
            }
            case ENUM: 
            case DATA: {
                this.emitRef(decl.getObject());
                break;
            }
            default: {
                throw new RuntimeException("Unexpected object type: " + (Object)((Object)decl.getTypeId()));
            }
        }
    }

    private void emitOpenAPI_type(String type) {
        this.emitLine("type: ", type);
    }

    private void emitOpenAPI_type(String type, String format) {
        this.emitOpenAPI_type(type);
        this.emitLine("format: ", format);
    }

    private void emitOpenAPI_int(String min, String max) {
        this.emitOpenAPI_type("integer");
        this.emitLine("minimum: ", min);
        this.emitLine("maximum: ", max);
    }

    private void emitOpenAPI_object(VmodlObject object, JavadocLinkResolver.LinkContext context, boolean withPrivilege) {
        VmodlObject base;
        this.emitLine("type: object");
        if (object.isDeprecated()) {
            this.emitLine("deprecated: true");
        }
        Version version = object.getVersion();
        String satelliteDisclaimer = null;
        if (version != null) {
            String namespace;
            if (this._eve && version.isNonInitialViJsonRelease() && version.getDisplayName() != null) {
                this.emitLine("x-vmw-doc-added-in: ", version.getDisplayName());
            }
            if (!"vmodl".equals(namespace = version.getNamespace()) && !version.isBaseNamespace(this._defaultNamespace)) {
                satelliteDisclaimer = "This structure may be used only with operations rendered under `/" + namespace + "`.";
            }
        }
        this.emitOpenAPI_description(this._docRenderer.renderDescription(object, satelliteDisclaimer));
        Iterator properties = object.getPropertyListWithOverrides().stream().filter(p -> OpenAPI3.shouldEmit(p)).iterator();
        if (properties.hasNext()) {
            this.emitLine("properties:", INDENT);
            ArrayList<String> requiredFields = new ArrayList<String>();
            while (properties.hasNext()) {
                Property property = (Property)properties.next();
                VmodlDecl decl = property.getDecl();
                String name = property.getName();
                if (!decl.isOptional()) {
                    requiredFields.add(name);
                }
                this.pushIndent();
                this.emitLine(name, ":");
                this.indent();
                if (decl.isDeprecated()) {
                    this.emitLine("deprecated: true");
                }
                String privilege = withPrivilege ? property.getPrivilegeId() : null;
                this.emitOpenAPI_description(this._docRenderer.renderDescription((Documented)property, privilege, decl, context));
                this.emitDecl(decl);
                this.popIndent();
            }
            this.unindent();
            if (!requiredFields.isEmpty()) {
                this.emitLine("required:", INDENT);
                for (String name : requiredFields) {
                    this.emitLine("- ", name);
                }
                this.unindent();
            }
        }
        if ((base = object.getBaseObject()) != null) {
            this.emitLine("allOf:", INDENT);
            this.emitDashRef(base);
            this.unindent();
        }
    }

    private void emitOpenAPI_summary(String summary) {
        this.emitOpenAPI_multiline("summary", summary, null);
    }

    private void emitOpenAPI_description(String description) {
        this.emitOpenAPI_description(description, null);
    }

    private void emitOpenAPI_description(String description, String defaultValue) {
        this.emitOpenAPI_multiline("description", description, defaultValue);
    }

    private void emitOpenAPI_multiline(String identifier, String description, String defaultValue) {
        if (description == null || description.length() == 0) {
            if (defaultValue == null) {
                return;
            }
            description = defaultValue;
        }
        this.emitPartial(identifier, ": ");
        this.emitLine("|", String.valueOf(INDENT_SPACES.length()));
        this.indent();
        this.emitMultiline(description);
        this.unindent();
    }

    private void emitMoIdParameter() {
        this.pushIndent();
        this.emitLine("moId", ":");
        this.emitLine(INDENT, "name: ", "moId");
        this.emitLine("in: path");
        this.emitLine("required: true");
        this.emitLine("description: ", "A unique identifier (within this vCenter Server instance) for a specific managed object such as `group-d1` or `vm-015` or `ServiceInstance`.");
        this.emitLine("schema:", INDENT);
        this.emitLine("type: string");
        this.emitGap();
        this.popIndent();
    }

    private void emitMoIdParameter(String typeName, String entity) {
        this.pushIndent();
        this.emitLine("- name: ", "moId");
        this.emitLine(INDENT, "in: path");
        this.emitLine("required: true");
        this.emitLine("description: ", "The unique identifier for the managed object to which the ", entity, " attaches; the serialized managed object reference for a request has the form `moType/moId`, in this case `", typeName, "/{moId}`.");
        this.emitLine("schema:", INDENT);
        this.emitLine("type: string");
        this.emitGap();
        this.popIndent();
    }

    private void emitVersionParameter() {
        this.pushIndent();
        this.emitLine("release", ":");
        this.emitLine(INDENT, "name: ", "release");
        this.emitLine("in: path");
        this.emitLine("required: true");
        this.emitVersionParamDescription();
        this.emitLine("schema:", INDENT);
        this.emitLine("type: string");
        this.emitGap();
        this.popIndent();
    }

    private void emitTranscoderOperation() {
        this.pushIndent();
        this.emitOperationSchema();
        this.emitLine("/transcoder", ":");
        this.emitLine(INDENT, "post", ":");
        this.indent();
        String tags = this._defaultNamespace != null ? "Virtual Infrastructure, WireFormatTranscoder" : TRANSCODER_TAG;
        this.emitLine("tags: [" + tags + "]");
        this.emitOpenAPI_summary("Transcodes a data object from XML to VI/JSON or vice versa.");
        this.emitLine("operationId: ", "Transcoder_Transcode");
        this.emitLine("x-vmw-doc-added-in: ", "vSphere API Release 8.0.2.0");
        this.emitOpenAPI_description("Transcodes and validates the integrity of a JSON or XML\nserialized data object.\n\nTranscoding is available from JSON to XML and vice versa.\nAdditionally, the same encoding type can be used both for\ninput and output, which is useful for schema validation as\nthe transcoder service always does schema validation.\nAccordingly, requests with data objects that do not match\nthe selected `{release}` are rejected.");
        this.emitLine("parameters:", INDENT);
        this.pushIndent();
        this.emitLine("- name: ", "target_release");
        this.emitLine(INDENT, "in: query");
        this.emitLine("required: false");
        this.emitOpenAPI_description("The target vSphere release.\n\nThe optional `target_release` query parameter can be used to\ndowngrade the data object to a previous release. According\nto the rules for backward compatibility, this is achieved by\nremoving all fields that were not present in the target\nrelease - and upcasting in case the data object is introduced\nafter the target release.");
        this.emitLine("schema:", INDENT);
        this.emitLine("type: string");
        this.emitGap();
        this.popIndent();
        this.emitOperationSchemaParams();
        this.unindent();
        this.pushIndent();
        this.emitLine("requestBody:", INDENT);
        this.emitOpenAPI_description("The XML or JSON object to be transcoded.\nShould be a valid representation of Data Object\ndefined in the 'vim' namespace.");
        this.emitLine("required: true");
        this.emitLine("content:", INDENT);
        this.pushIndent();
        this.emitLine("application/xml:", INDENT);
        this.emitLine("schema:", INDENT);
        this.emitLine("type: object");
        this.popIndent();
        this.pushIndent();
        this.emitLine(APPLICATION_JSON, INDENT);
        this.emitLine("schema:", INDENT);
        this.emitLine("type: object");
        this.popIndent();
        this.popIndent();
        this.emitLine("security:", INDENT);
        this.emitLine("- ", SECURITY_SCHEME_NAME, ": []");
        this.unindent();
        this.emitLine("responses:", INDENT);
        this.emitLine("'200':", INDENT);
        this.emitOpenAPI_description("OK");
        this.emitLine("content:", INDENT);
        this.pushIndent();
        this.emitLine("application/xml:", INDENT);
        this.emitLine("schema:", INDENT);
        this.emitLine("type: object");
        this.popIndent();
        this.pushIndent();
        this.emitLine(APPLICATION_JSON, INDENT);
        this.emitLine("schema:", INDENT);
        this.emitLine("type: object");
        this.popIndent();
        this.unindent();
        this.unindent();
        this.pushIndent();
        String transcoderErrorLink = String.format("**[%s](../../../../../data-structures/%s/)**", TRANSCODER_ERROR_ID, TRANSCODER_ERROR_ID);
        this.emitLine("'400':", INDENT);
        this.emitOpenAPI_description(transcoderErrorLink + " with `error_type` `InvalidArgument` -\nthrown when invalid header or query params are supplied.\n\n" + transcoderErrorLink + " with `error_type` `InvalidRequest` -\nthrown when an invalid data object is passed as a body parameter.");
        this.emitLine("content:", INDENT);
        this.emitLine(APPLICATION_JSON, INDENT);
        this.emitLine("schema:", INDENT);
        this.emitRef(TRANSCODER_ERROR_ID);
        this.popIndent();
        this.pushIndent();
        this.emitLine("'401':", INDENT);
        this.emitOpenAPI_description(transcoderErrorLink + " with `error_type` `SecurityError` -\nthrown when the user is not authenticated.");
        this.emitLine("content:", INDENT);
        this.emitLine(APPLICATION_JSON, INDENT);
        this.emitLine("schema:", INDENT);
        this.emitRef(TRANSCODER_ERROR_ID);
        this.popIndent();
        this.popIndent();
    }

    private void emitTranscoderTag() {
        String description;
        if (this._pathToTranscoderDescription == null) {
            return;
        }
        Path p = Paths.get(this._pathToTranscoderDescription, new String[0]);
        try {
            description = new String(Files.readAllBytes(p), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading description file " + p.toAbsolutePath(), e);
        }
        description = description.replace("{$RELEASE}", this._release);
        this.emitLine("- name: ", TRANSCODER_TAG);
        this.indent();
        this.emitOpenAPI_description(description);
        this.unindent();
    }

    private void emitTranscoderErrorDefinition() {
        this.pushIndent();
        this.emitLine("ViTranscoderErrorResponse:", INDENT);
        this.emitLine("type: object");
        this.emitOpenAPI_description("Transcoder error.");
        this.emitLine("properties:", INDENT);
        this.emitLine("error_type:", INDENT);
        this.emitOpenAPI_description("The type of the error. One of {InvalidArgument, InvalidRequest,\nSecurityError}.");
        this.emitLine("type: string");
        this.unindent();
        this.emitLine("error_message:", INDENT);
        this.emitOpenAPI_description("The error message.");
        this.emitLine("type: string");
        this.emitGap();
        this.popIndent();
    }

    @Override
    protected String getLink(VmodlApi object, JavadocLinkResolver.LinkContext context) {
        return this._linkResolver.getLink(object, context);
    }

    private static ObjectsEnumerator enumerateObjects(String defaultNamespace) {
        class EnumeratorFilter
        implements ObjectsEnumerator.Filter {
            EnumeratorFilter() {
            }

            @Override
            public boolean shouldEmit(VmodlObject object) {
                return JoapEmitter.shouldEmit(object) && !OBJECTS_TO_SKIP.contains(object);
            }
        }
        return new ObjectsEnumerator(ObjectRegistry.getAllObjects(), new EnumeratorFilter(), defaultNamespace);
    }

    protected static List<Method> getReleasedMethods(ManagedObject managedObject) {
        List<Method> allMethods = managedObject.getFullMethodList();
        ArrayList<Method> methods = new ArrayList<Method>(allMethods.size());
        for (Method method : allMethods) {
            if (!OpenAPI3.shouldEmit(method)) continue;
            methods.add(method);
        }
        methods.sort(NameComparator);
        return methods;
    }

    protected static List<Property> getReleasedProperties(ManagedObject object) {
        List<Property> allProperties = object.getFullPropertyList();
        ArrayList<Property> properties = new ArrayList<Property>(allProperties.size());
        for (Property property : allProperties) {
            if (!OpenAPI3.shouldEmit(property)) continue;
            properties.add(property);
        }
        properties.sort(NameComparator);
        return properties;
    }
}

