/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import emitters.Versions;
import emitters.doc.JavadocLinkResolver;
import emitters.generators.joap.OpenAPILinkResolver;
import emitters.model.DataProperty;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.Namespace;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlObject;

class OpenAPIEveLinkResolver
extends OpenAPILinkResolver {
    private final String _baseOperationPath;
    private final String _defaultNamespace;

    OpenAPIEveLinkResolver(String baseOperationPath, String defaultNamespace) {
        this._baseOperationPath = baseOperationPath;
        this._defaultNamespace = defaultNamespace;
    }

    @Override
    protected String getNonOperationDestination(VmodlApi element, JavadocLinkResolver.LinkContext context) {
        if (element == null) {
            return null;
        }
        if (context == JavadocLinkResolver.LinkContext.DISABLED) {
            return "";
        }
        StringBuilder relative = this.getBasePath(context);
        if (element instanceof ManagedObject) {
            String id = this.getId(element);
            CharSequence tag = OpenAPIEveLinkResolver.toTag(id);
            if (this._defaultNamespace == null) {
                if (id.equals("SearchIndex")) {
                    tag = "search_index";
                }
            } else {
                Namespace ns;
                Version version = element.getVersion();
                String namespace = version.getNamespace();
                if (version.isBaseNamespace(this._defaultNamespace)) {
                    namespace = this._defaultNamespace;
                }
                String navigationTag = (ns = Versions.getNamespace(namespace)) == null ? namespace : ns.getDisplayName();
                relative.append(OpenAPIEveLinkResolver.toTag(navigationTag)).append('/');
            }
            relative.append(tag);
        } else {
            if (element instanceof DataProperty) {
                element = ((DataProperty)element).getContainer();
            }
            if (!(element instanceof VmodlObject)) {
                throw new IllegalArgumentException(element.getClass().getName());
            }
            relative.append("data-structures/").append(this.getWireId(element));
            if (element instanceof Enum) {
                relative.append("/enum");
            }
            relative.append('/');
        }
        return relative.toString();
    }

    private static CharSequence toTag(CharSequence id) {
        int length = id.length();
        if (length == 0) {
            return id;
        }
        StringBuilder result = new StringBuilder().append(Character.toLowerCase(id.charAt(0)));
        for (int i = 1; i < length; ++i) {
            char c = id.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!Character.isUpperCase(id.charAt(i - 1))) {
                    result.append('-');
                }
                result.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            result.append(c);
        }
        return result;
    }

    @Override
    protected String getOperationDestination(VmodlApi container, VmodlApi element, JavadocLinkResolver.LinkContext context) {
        boolean satellite;
        if (context == JavadocLinkResolver.LinkContext.DISABLED) {
            return "";
        }
        StringBuilder sb = this.getBasePath(context).append(this._baseOperationPath);
        Version version = container.getVersion();
        boolean bl = satellite = !version.isBaseNamespace(this._defaultNamespace);
        if (satellite) {
            sb.append(version.getNamespace()).append('/');
        }
        return sb.append(this.getId(container)).append('/').append("moId").append('/').append(this.getId(element)).append('/').append(this.getHttpMethod(element)).toString();
    }

    private StringBuilder getBasePath(JavadocLinkResolver.LinkContext context) {
        StringBuilder result = new StringBuilder();
        switch (context.getType()) {
            case NAMESPACE: {
                result.append("../");
            }
            case MANAGED_OBJECT: {
                if (this._defaultNamespace == null) {
                    result.append("../");
                    break;
                }
                result.append("../../");
                break;
            }
            case METHOD_PARAMS: 
            case DATA_OBJECT: {
                result.append("../../");
                break;
            }
            case ENUM: {
                result.append("../../../");
                break;
            }
            case MANAGED_METHOD: 
            case MANAGED_PROPERTY: {
                result.append("../../../../../../../");
                if (!context.isSatellite()) break;
                result.append("../");
                break;
            }
            default: {
                throw new RuntimeException("Unexpected link context: " + context);
            }
        }
        return result;
    }

    @Override
    protected String getLabel(VmodlApi element, JavadocLinkResolver.LinkContext context) {
        if (element instanceof Enum) {
            return this.getWireId(element) + "Enum";
        }
        return super.getLabel(element, context);
    }
}

