/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.xml;

import emitters.VmodlEmitter;
import emitters.model.VmodlObject;
import java.util.List;

public class BeanTypesEmitter
extends VmodlEmitter {
    private final String _fileName;
    private static final String XML_DOCUMENT_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String OPEN_VMOMI_TYPES_SET = "<util:set id=\"VmomiTypes\" value-type=\"java.lang.String\" set-class=\"java.util.HashSet\" >";
    private static final String CLOSE_VMOMI_TYPES_SET = "</util:set>";
    private static final String OPEN_BEANS_DEFINITION = "<beans xmlns=\"http://www.springframework.org/schema/beans\"    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:context=\"http://www.springframework.org/schema/context\"    xmlns:util=\"http://www.springframework.org/schema/util\" xmlns:aop=\"http://www.springframework.org/schema/aop\"    xsi:schemaLocation=\"http://www.springframework.org/schema/aop http://www.springframework.org/schema/aop/spring-aop-3.1.xsd        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd        http://www.springframework.org/schema/context http://www.springframework.org/schema/context/spring-context.xsd\">";
    private static final String CLOSE_BEANS_DEFINITION = "</beans>";

    public BeanTypesEmitter(String fileName) {
        this._fileName = fileName;
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.beginFile(this._fileName);
        this.emitHeader();
        for (VmodlObject obj : objects) {
            if (obj.getKind() != VmodlObject.Kind.ManagedObject) continue;
            this.emitLine("<value>", obj.getName(), "</value>");
        }
        this.emitFooter();
        this.endFile();
    }

    private void emitHeader() {
        this.emitLine(XML_DOCUMENT_HEADER);
        this.emitLine(OPEN_BEANS_DEFINITION);
        this.indent();
        this.emitLine(OPEN_VMOMI_TYPES_SET);
        this.indent();
    }

    private void emitFooter() {
        this.unindent();
        this.emitLine(CLOSE_VMOMI_TYPES_SET);
        this.unindent();
        this.emitLine(CLOSE_BEANS_DEFINITION);
    }
}

