/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import com.sun.source.doctree.DocTree;
import com.sun.source.util.DocTreePath;
import emitters.model.Documented;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class DocumentedBase
implements Documented {
    private final String _comment;
    private final Supplier<DocTreePath> _docSupplier;

    public DocumentedBase(String comment, Supplier<DocTreePath> docSupplier) {
        this._comment = comment;
        this._docSupplier = docSupplier;
    }

    @Override
    public String getComment() {
        return this._comment;
    }

    @Override
    public DocTreePath getDoc() {
        return this._docSupplier == null ? null : this._docSupplier.get();
    }

    public Supplier<DocTreePath> getDocSupplier() {
        return this._docSupplier;
    }

    public DocTreePath getReturnDoc() {
        return this.getBlockTag(t -> t.getKind() == DocTree.Kind.RETURN);
    }

    protected DocTreePath getBlockTag(Predicate<? super DocTree> filter) {
        DocTreePath doc = this.getDoc();
        if (doc == null) {
            return null;
        }
        Optional<? super DocTree> p = doc.getDocComment().getBlockTags().stream().filter(filter).findAny();
        if (!p.isPresent()) {
            return null;
        }
        return new DocTreePath(doc, p.get());
    }
}

