/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import com.sun.source.util.DocTreePath;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import emitters.model.raw.RawObject;
import emitters.model.raw.RawVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class Enum
extends VmodlObject {
    private final List<String> _values = new ArrayList<String>();
    private final Map<String, String> _comments = new HashMap<String, String>();
    private final List<Version> _valueVersions = new ArrayList<Version>();
    private final List<Supplier<DocTreePath>> _valueDocs = new ArrayList<Supplier<DocTreePath>>();
    private final boolean _isCppEnumClass;
    private final boolean _isConstants;

    public Enum(RawObject rawObject, RawVersion rawVersion, boolean isCppEnumClass, boolean isConstants) {
        super(rawObject, rawVersion);
        this._isCppEnumClass = isCppEnumClass;
        this._isConstants = isConstants;
    }

    public void addValue(String value, String comment, Version version, Supplier<DocTreePath> docSupplier) {
        this._values.add(value);
        this._comments.put(value, comment);
        this._valueVersions.add(version);
        this._valueDocs.add(docSupplier);
    }

    public boolean IsCppEnumClass() {
        return this._isCppEnumClass;
    }

    public boolean isConstants() {
        return this._isConstants;
    }

    public List<String> getValueList() {
        return this._values;
    }

    public List<Version> getValueVersionList() {
        return this._valueVersions;
    }

    public List<Supplier<DocTreePath>> getValueDocList() {
        return this._valueDocs;
    }

    public String getComment(String value) {
        return this._comments.get(value);
    }

    public String getValueString(String value) {
        String valueString = this.getName() + "_" + value;
        return valueString.toUpperCase();
    }

    @Override
    public VmodlObject.Kind getKind() {
        return VmodlObject.Kind.Enum;
    }

    public Set<VmodlDecl> getReferencedDecls(boolean wantFaults) {
        return Collections.emptySet();
    }

    @Override
    public void enqueueDigest() {
        super.enqueueDigest();
        for (int i = 0; i < this._values.size(); ++i) {
            Version version = this._valueVersions.get(i);
            if (version == null) {
                version = this._version;
            }
            String value = this._values.get(i);
            if (version != this._version) {
                version.enqueueDigestPartOf(this);
            }
            version.enqueueDigestEnum(value);
        }
    }

    @Override
    public void print() {
        super.print();
        System.out.print("Values:");
        for (String value : this._values) {
            System.out.print(" " + value);
        }
        System.out.println();
        System.out.print("Versions:");
        for (Version version : this._valueVersions) {
            if (version != null) {
                System.out.print(" " + version.getVmodlName());
                continue;
            }
            System.out.print(" None");
        }
        System.out.println(" ");
    }
}

