/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.model.Feature;
import emitters.model.Namespace;
import emitters.model.Product;
import emitters.model.ReleaseVersions;
import emitters.model.SyntheticVersion;
import emitters.model.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import vmodl.breakingChanges;
import vmodl.breakingChangesList;
import vmodl.nsConfig;
import vmodl.service;

public class MetaVersion {
    private final service _service;
    private final Namespace _namespace;
    private final nsConfig _nsConfig;
    private final Product _product;
    private final String _versionsPrefix;
    private String _wireNs;
    private List<ReleaseVersions> _releaseVersions;
    private final List<MetaVersion> _metaParents = new ArrayList<MetaVersion>();
    private final List<SyntheticVersion> _syntheticVersions = new ArrayList<SyntheticVersion>();
    private Map<String, SyntheticVersion> _featureVersionsMap = new HashMap<String, SyntheticVersion>();
    private SyntheticVersion _syntheticBase;
    private SyntheticVersion _devVersion;
    private SyntheticVersion _disabledVersion;
    private Version _latestLtsVersion;
    private Map<String, Integer> _breakingChanges = new HashMap<String, Integer>();

    public MetaVersion(service service2, Namespace namespace, nsConfig nsConfig2, breakingChangesList breakingChanges) {
        this._service = service2;
        this._namespace = namespace;
        this._nsConfig = nsConfig2;
        this._product = namespace.getProduct();
        this._versionsPrefix = namespace.getName() + ".version.";
        if (breakingChanges != null) {
            this.setBreakingChanges(breakingChanges);
        }
    }

    public void init() {
        assert (this._syntheticVersions.size() == 0);
        this._releaseVersions = this._namespace.getReleaseVersionsList();
        this._latestLtsVersion = this._releaseVersions.get(0).ltsVersion();
        this._wireNs = this._latestLtsVersion.getWireNs();
        this.createDisabledVersion(this.createDevVersion(this.createFeatureVersions(this.createMilestoneVersions(this.createSyntheticBase(this._latestLtsVersion)))));
    }

    private Version createSyntheticBase(Version baseVersion) {
        String syntheticBaseId = this._product.getSyntheticBase(this._namespace);
        if (syntheticBaseId == null) {
            return baseVersion;
        }
        this._syntheticBase = new SyntheticVersion(this, "_base_", Version.Kind.MILESTONE);
        this._syntheticBase.setWireId(syntheticBaseId);
        this._syntheticBase.addDirectParent(baseVersion);
        this._syntheticVersions.add(this._syntheticBase);
        return this._syntheticBase;
    }

    private Version createMilestoneVersions(Version baseVersion) {
        for (String milestone : this._product.getReleasedFeatures()) {
            SyntheticVersion sv = new SyntheticVersion(this, milestone, Version.Kind.MILESTONE);
            sv.addDirectParent(baseVersion);
            this._syntheticVersions.add(sv);
            this._featureVersionsMap.put(milestone, sv);
            baseVersion = sv;
        }
        return baseVersion;
    }

    private Set<Version> createFeatureVersions(Version baseVersion) {
        Set<Feature> features = this._product.getFeatures();
        if (features.size() == 0) {
            HashSet<Version> result = new HashSet<Version>();
            result.add(baseVersion);
            return result;
        }
        HashSet<SyntheticVersion> allFeatureVersions = new HashSet<SyntheticVersion>();
        for (Feature feature2 : features) {
            allFeatureVersions.add(this.getFeatureVersion(feature2, baseVersion));
        }
        HashSet<Version> result = new HashSet<Version>(allFeatureVersions);
        for (Version version : allFeatureVersions) {
            for (Version parent : version.getDirectParents()) {
                result.remove(parent);
            }
        }
        result.remove(baseVersion);
        return result;
    }

    private SyntheticVersion getFeatureVersion(Feature feature2, Version baseVersion) {
        String featureName = feature2.id;
        SyntheticVersion featureVersion = this._featureVersionsMap.get(featureName);
        if (featureVersion == null) {
            featureVersion = new SyntheticVersion(this, featureName, Version.Kind.FEATURE);
            for (Feature parentFeature : feature2.parents) {
                featureVersion.addDirectParent(this.getFeatureVersion(parentFeature, baseVersion));
            }
            if (featureVersion.getDirectParents().isEmpty()) {
                featureVersion.addDirectParent(baseVersion);
            }
            this._syntheticVersions.add(featureVersion);
            this._featureVersionsMap.put(featureName, featureVersion);
        }
        return featureVersion;
    }

    private Version createDevVersion(Set<Version> baseVersions) {
        this._devVersion = new SyntheticVersion(this, "unstable", Version.Kind.DEV);
        for (Version version : baseVersions) {
            this._devVersion.addDirectParent(version);
        }
        this._devVersion.addDirectParent(this._latestLtsVersion);
        this._syntheticVersions.add(this._devVersion);
        return this._devVersion;
    }

    private Version createDisabledVersion(Version baseVersion) {
        this._disabledVersion = new SyntheticVersion(this, "disabled", Version.Kind.DISABLED);
        this._disabledVersion.addDirectParent(baseVersion);
        this._syntheticVersions.add(this._disabledVersion);
        return this._disabledVersion;
    }

    public void addMetaParent(MetaVersion parent) {
        if (this._namespace.equals(parent._namespace)) {
            throw new RuntimeException("Invalid referral to the same namespace as a parent in " + this._namespace + " meta-version");
        }
        this._metaParents.add(parent);
        if (this._syntheticBase != null) {
            this._syntheticBase.addDirectParent(parent._syntheticBase);
        }
        for (Map.Entry<String, SyntheticVersion> entry : this._featureVersionsMap.entrySet()) {
            Version parentVersion = parent._featureVersionsMap.get(entry.getKey());
            entry.getValue().addDirectParent(parentVersion);
        }
        this._devVersion.addDirectParent(parent._devVersion);
        this._disabledVersion.addDirectParent(parent._disabledVersion);
    }

    public void initSyntheticVersions() {
        for (SyntheticVersion sv : this._syntheticVersions) {
            sv.initDigest();
        }
    }

    public void sealSyntheticVersions() {
        for (SyntheticVersion sv : this._syntheticVersions) {
            sv.setWireId();
        }
        if (this._namespace.supportsViJson()) {
            for (SyntheticVersion syntheticVersion : this._syntheticVersions) {
                switch (syntheticVersion.getKind()) {
                    case DEV: 
                    case MILESTONE: {
                        syntheticVersion.setViJsonRelease(syntheticVersion.getWireId());
                    }
                }
            }
        }
    }

    public List<ReleaseVersions> getReleaseVersions() {
        return this._releaseVersions;
    }

    private void setBreakingChanges(breakingChangesList l) {
        for (breakingChanges e : l.value()) {
            this._breakingChanges.put(e.branch(), e.count());
        }
    }

    public Version getFeatureVersion(String featureName) {
        return this._featureVersionsMap.get(featureName);
    }

    public Set<Map.Entry<String, Integer>> getBreakingChanges() {
        return this._breakingChanges.entrySet();
    }

    public service getService() {
        return this._service;
    }

    public Namespace getNamespace() {
        return this._namespace;
    }

    public nsConfig getNsConfig() {
        return this._nsConfig;
    }

    public Product getProduct() {
        return this._product;
    }

    public String getVersionsPrefix() {
        return this._versionsPrefix;
    }

    public String getWireNs() {
        return this._wireNs;
    }

    public List<MetaVersion> getMetaParents() {
        return this._metaParents;
    }

    public List<SyntheticVersion> getSyntheticVersions() {
        return this._syntheticVersions;
    }

    public Version getDevVersion() {
        return this._devVersion;
    }

    public Version getSyntheticBase() {
        return this._syntheticBase;
    }

    public Version getDisabledVersion() {
        return this._disabledVersion;
    }

    public Version getLatestLtsVersion() {
        return this._latestLtsVersion;
    }
}

