/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.util.DocTreePath;
import emitters.Versions;
import emitters.backend.FeatureState;
import emitters.core.SyntaxException;
import emitters.model.DataObject;
import emitters.model.EntityBase;
import emitters.model.Namespace;
import emitters.model.Parameter;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import vmodl.ssoToken;

public class Method
extends EntityBase
implements VmodlApi {
    private final VmodlObject _container;
    private String _wsdlName;
    private final VmodlDecl _returnDecl;
    private final List<Parameter> _parameterList = new ArrayList<Parameter>();
    private final List<DataObject> _faultList = new ArrayList<DataObject>();
    private List<String> _events;
    private final String _privId;
    private boolean _isDynamicPrivs;
    private Map<String, String> _subclassPrivs;
    private ssoToken _ssoToken;
    private boolean _isTask;
    private boolean _isMultibody;
    private boolean _isUndocumented;
    private boolean _isDeprecated;
    private boolean _isInternal;
    private boolean _isExplicitlyInternal;
    private Version _internalBefore;
    private boolean _isContinuous;
    private String _continuousFSS;
    private static VmodlDecl _taskReturnDecl;

    public Method(VmodlObject container, String name, VmodlDecl returnDecl, String privId, Version version, String comment, Supplier<DocTreePath> docSupplier) {
        super(name, version, comment, docSupplier);
        this._container = container;
        this._returnDecl = returnDecl;
        this._privId = privId;
    }

    Method(VmodlObject container, String name, VmodlDecl returnDecl, Version version, String comment) {
        this(container, name, returnDecl, null, version, comment, null);
    }

    Method(Method m, String privId) {
        super(m.getName(), m.getVersion(), m.getComment(), m.getDocSupplier());
        this._container = m._container;
        this._wsdlName = m._wsdlName;
        this._returnDecl = m._returnDecl;
        this._parameterList.addAll(m._parameterList);
        this._faultList.addAll(m._faultList);
        this._privId = privId;
        this._isTask = m._isTask;
        this._isMultibody = m._isMultibody;
        this._isDeprecated = m._isDeprecated;
        this._isUndocumented = m._isUndocumented;
        this._isContinuous = m._isContinuous;
        this._continuousFSS = m._continuousFSS;
        this._isInternal = m._isInternal;
        this._isExplicitlyInternal = m._isExplicitlyInternal;
    }

    public void setWsdlName(String wsdlName2) {
        if (this._wsdlName != null) {
            throw new RuntimeException("WSDL name redefinition");
        }
        this._wsdlName = wsdlName2;
    }

    public void addParameter(Parameter parameter) {
        this._parameterList.add(parameter);
    }

    public void addFault(DataObject fault) {
        this._faultList.add(fault);
    }

    public void addEvent(String event2) {
        if (this._events == null) {
            this._events = new ArrayList<String>();
        }
        this._events.add(event2);
    }

    public void setIsDynamicPrivs(boolean isDynamic) {
        this._isDynamicPrivs = isDynamic;
    }

    public void setSubclassPrivileges(Map<String, String> subclassPrivs) {
        this._subclassPrivs = subclassPrivs;
    }

    public void setSSOToken(ssoToken ssoToken2) {
        this._ssoToken = ssoToken2;
    }

    public void setTask() {
        this._isTask = true;
    }

    public void setMultibody() {
        this._isMultibody = true;
    }

    public void setUndocumented() {
        this._isUndocumented = true;
    }

    public void setDeprecated() {
        this._isDeprecated = true;
    }

    public void setInternal() {
        this._isInternal = true;
    }

    public void setExplicitlyInternal(boolean internal2) {
        this._isExplicitlyInternal = internal2;
    }

    public void setInternalBefore(Version internalBefore2) {
        this._internalBefore = internalBefore2;
    }

    public void setContinuous(String featureName) {
        this._isContinuous = true;
        if (!featureName.isEmpty()) {
            String nsId = this.getVersion().getNamespace();
            Namespace ns = Versions.getNamespace(nsId);
            if (ns == null) {
                throw SyntaxException.at(this._container, "Unknown namespace '%s' for the @continous annotation of '%s' method", nsId, this.getName());
            }
            FeatureState fs = ns.getProduct().getFssConfig().checkState(featureName);
            if (fs == null) {
                throw SyntaxException.at(this._container, "Unknown feature '%s' in the @continous annotation of '%s' method", featureName, this.getName());
            }
            this._continuousFSS = featureName;
        }
    }

    public VmodlObject getContainer() {
        return this._container;
    }

    @Override
    public String getVmodlName() {
        return this.getQualifiedName();
    }

    @Override
    public String getWsdlName() {
        return this._wsdlName;
    }

    public String getQualifiedName() {
        return this._container.getQualifiedVmodlType() + "." + this.getName();
    }

    public VmodlDecl getReturnDecl() {
        return this._returnDecl;
    }

    public List<Parameter> getParameterList() {
        return this._parameterList;
    }

    public List<DataObject> getFaultList() {
        return this._faultList;
    }

    public Iterable<String> getEvents() {
        return this._events;
    }

    public String getPrivilegeId() {
        return this._privId;
    }

    public boolean isDynamicPrivs() {
        return this._isDynamicPrivs;
    }

    public Map<String, String> getSubclassPrivileges() {
        return this._subclassPrivs;
    }

    public ssoToken getSSOToken() {
        return this._ssoToken;
    }

    public boolean isTask() {
        return this._isTask;
    }

    public boolean isMultibody() {
        return this._isMultibody;
    }

    @Override
    public boolean isUndocumented() {
        return this._isUndocumented;
    }

    public boolean isDeprecated() {
        return this._isDeprecated;
    }

    public boolean isContinuous() {
        return this._isContinuous;
    }

    public String getContinuousFSS() {
        return this._continuousFSS;
    }

    @Override
    public boolean isInternal() {
        return this._isInternal;
    }

    public boolean isExplicitlyInternal() {
        return this._isExplicitlyInternal;
    }

    @Override
    public Version getInternalBefore() {
        return this._internalBefore;
    }

    public DocTreePath getTaskDoc() {
        return this.getBlockTag(t -> t.getKind() == DocTree.Kind.UNKNOWN_BLOCK_TAG && ((UnknownBlockTagTree)t).getTagName().equals("task"));
    }

    void enqueueDigest() {
        Version version = this.getVersion();
        if (version != this._container.getVersion()) {
            version.enqueueDigestPartOf(this._container);
        }
        version.enqueueDigestMethod(this);
        this._returnDecl.enqueDigestDefiniton(version);
        for (Parameter parameter : this._parameterList) {
            parameter.enqueueDigest(this);
        }
        for (DataObject fault : this._faultList) {
            version.enqueueDigestFault(fault);
        }
    }

    void print() {
        System.out.print("   ");
        System.out.print("Name: " + this.getName());
        System.out.print(", WSDL name: " + (this._wsdlName != null ? this._wsdlName : "None"));
        if (this._isTask) {
            System.out.print(", @task");
        }
        if (this._isInternal) {
            System.out.print(", @internal");
        }
        if (this._isContinuous) {
            if (this._continuousFSS != null) {
                System.out.print(", @continuous(" + this._continuousFSS + ")");
            } else {
                System.out.print(", @continuous");
            }
        }
        System.out.print(", Version: " + this.getVersion().getVmodlName());
        if (this._internalBefore != null) {
            System.out.print(" internal before: " + this._internalBefore.getVmodlName());
        }
        System.out.println();
        if (this._returnDecl != null) {
            System.out.print("      ");
            System.out.print("Returns: ");
            this._returnDecl.print();
            System.out.println();
        }
        if (!this._parameterList.isEmpty()) {
            System.out.print("      ");
            System.out.println("Parameters:");
        }
        for (Parameter parameter : this._parameterList) {
            System.out.print("      ");
            parameter.print("   ");
            System.out.println();
        }
        if (!this._faultList.isEmpty()) {
            System.out.print("      ");
            System.out.print("Faults:");
            for (DataObject fault : this._faultList) {
                System.out.print(" " + fault.getQualifiedVmodlType());
            }
            System.out.println();
        }
    }

    public void validateVisibility() {
        VmodlObject retObj;
        if (this.isExplicitlyInternal() || this.getContainer().isInternal()) {
            return;
        }
        for (DataObject fault : this.getFaultList()) {
            if (!fault.isInternal()) continue;
            Versions.reportVisibilityViolation("The official method " + this.getVmodlName() + " is not allowed to throw fault of internal type " + fault.getVmodlName());
        }
        for (Parameter parameter : this.getParameterList()) {
            VmodlDecl decl = parameter.getDecl();
            VmodlObject obj = decl != null ? decl.getObject() : null;
            if (obj == null || !obj.isInternal()) continue;
            Versions.reportVisibilityViolation("The official method " + this.getVmodlName() + " can't have parameters of internal type " + obj.getVmodlName());
        }
        VmodlDecl retDecl = this.getReturnDecl();
        VmodlObject vmodlObject = retObj = retDecl != null ? retDecl.getObject() : null;
        if (retObj != null && retObj.isInternal()) {
            Versions.reportVisibilityViolation("The official method " + this.getVmodlName() + " has an internal return type " + retObj.getVmodlName());
        }
    }

    public static void resetTaskReturnDecl() {
        _taskReturnDecl = null;
    }

    public static void setTaskReturnType(VmodlDecl decl) {
        if (_taskReturnDecl != null) {
            throw new RuntimeException("Task return type should only be set once");
        }
        _taskReturnDecl = decl;
    }

    public static VmodlDecl taskReturnDecl() {
        return _taskReturnDecl;
    }
}

