/*
 * Decompiled with CFR 0.152.
 */
package emitters.model;

import emitters.Versions;
import emitters.model.DataObject;
import emitters.model.Field;
import emitters.model.Method;
import emitters.model.VmodlApi;
import emitters.model.VmodlObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import vmodl.service;
import vmodl.supportsManagedObjectsOf;

public class Version
implements Comparable<Version> {
    private static final String VERSION_SUFFIX = ".version";
    public static Version _root;
    private static String _initialViJsonRelease;
    public static final String ROOT = "vmodl.version.version0";
    protected final String _package;
    protected final String _namespace;
    protected final service _service;
    protected final Kind _kind;
    protected final String _vmodlName;
    protected final String _simpleName;
    protected String _wireNs;
    protected String _wireId;
    protected String _displayName;
    protected String _viJsonRelease;
    protected supportsManagedObjectsOf _supportedMO;
    protected final Set<Version> _directParents = new HashSet<Version>();
    protected final Set<Version> _directChildren = new HashSet<Version>();
    private Set<Version> _allParents;
    private Set<Version> _allChildren;
    private boolean _isUsed;
    private boolean _isLegacy;
    private static final Set<Version> _traversePath;

    public Version(String vmodlName, service svc, Kind kind) {
        this._vmodlName = vmodlName;
        this._service = svc;
        this._kind = kind;
        int pos = this._vmodlName.lastIndexOf(46);
        String string = this._package = pos != -1 ? this._vmodlName.substring(0, pos) : "";
        if (this._package.endsWith(VERSION_SUFFIX)) {
            int versionPos = this._package.length() - VERSION_SUFFIX.length();
            this._namespace = this._package.substring(0, versionPos);
        } else {
            this._namespace = this._package;
        }
        this._simpleName = this._vmodlName.substring(pos + 1);
    }

    public void setWireNs(String wireNs) {
        this._wireNs = wireNs != null ? wireNs : "";
    }

    public void setWireId(String wireId) {
        if (wireId == null || wireId.length() > 0) {
            this._wireId = wireId;
        }
    }

    public void setDisplayName(String displayName2) {
        this._displayName = displayName2;
    }

    public void setViJsonRelease(String viJsonRelease) {
        this._viJsonRelease = viJsonRelease;
    }

    public void setSupportedMO(supportsManagedObjectsOf supportedMO) {
        this._supportedMO = supportedMO;
    }

    public void addDirectParent(Version parentVersion) {
        this._directParents.add(parentVersion);
        parentVersion._directChildren.add(this);
    }

    public void setUsed() {
        this._isUsed = true;
    }

    public void setIsLegacy() {
        this._isLegacy = true;
    }

    public void resolveHeritage() {
        if (this._directParents.isEmpty() && this != _root) {
            this._directParents.add(_root);
        }
        this.findAllNeighbours(true);
        this.findAllNeighbours(false);
    }

    private Collection<Version> findAllNeighbours(boolean isParents) {
        Set<Version> immediateNeighbours;
        if (isParents) {
            if (this._allParents != null) {
                return this._allParents;
            }
            immediateNeighbours = this._directParents;
        } else {
            if (this._allChildren != null) {
                return this._allChildren;
            }
            immediateNeighbours = this._directChildren;
        }
        if (!_traversePath.add(this)) {
            throw new RuntimeException("Cyclic dependency for version " + this._vmodlName);
        }
        HashSet<Version> allNeighbours = new HashSet<Version>(immediateNeighbours);
        for (Version neighbour : immediateNeighbours) {
            allNeighbours.addAll(neighbour.findAllNeighbours(isParents));
        }
        _traversePath.remove(this);
        if (isParents) {
            this._allParents = allNeighbours;
        } else {
            this._allChildren = allNeighbours;
        }
        return allNeighbours;
    }

    public void pruneUnusedParents(Set<Version> prunedFeatureVersions) {
        for (Version prunedVersion : prunedFeatureVersions) {
            if (!this._directParents.remove(prunedVersion)) continue;
            this.addToDirectParents(prunedVersion._directParents, prunedFeatureVersions);
        }
        this._directChildren.removeAll(prunedFeatureVersions);
        this._allParents.removeAll(prunedFeatureVersions);
        this._allChildren.removeAll(prunedFeatureVersions);
    }

    private void addToDirectParents(Set<Version> parents, Set<Version> prunedFeatureVersions) {
        for (Version parent : parents) {
            if (parent._kind == Kind.FEATURE && prunedFeatureVersions.contains(parent)) {
                this.addToDirectParents(parent._directParents, prunedFeatureVersions);
                continue;
            }
            this._directParents.add(parent);
            parent._directChildren.add(this);
        }
    }

    public void enqueueDigestPartOf(VmodlApi vmodlApi) {
    }

    public void enqueueDigestObject(VmodlObject object) {
    }

    public void enqueueDigestBaseObject(VmodlObject object) {
    }

    public void enqueueDigestMethod(Method method) {
    }

    public void enqueueDigestFault(DataObject fault) {
    }

    public void enqueueDigestTypeFlag(String id) {
    }

    public void enqueueDigestTypeId(String id) {
    }

    public void enqueueDigestObjectRef(VmodlObject object) {
    }

    public void enqueueDigestField(Field field) {
    }

    public void enqueueDigestEnum(String value) {
    }

    public void enqueueDigestWsdlName(VmodlApi vmodlApi) {
    }

    public Version getNsLtsParent() {
        Set<Version> parents = this._directParents;
        HashSet<Version> grandParents = null;
        do {
            for (Version parent : parents) {
                if (!this.isSameNamespace(parent)) continue;
                if (parent._kind == Kind.LTS) {
                    return parent;
                }
                if (grandParents == null) continue;
                grandParents.addAll(parent._directParents);
            }
            if (grandParents != null) {
                parents = grandParents;
            }
            grandParents = new HashSet<Version>();
        } while (parents != null && !parents.isEmpty());
        return null;
    }

    public boolean isAncestor(Version version) {
        return version == this || version != null && this._allParents.contains(version);
    }

    public boolean isSameNamespace(Version version) {
        return this._namespace.equals(version._namespace);
    }

    public boolean isBaseNamespace(String namespace) {
        if (namespace == null || this._namespace.equals(namespace)) {
            return true;
        }
        return this.getDirectChildren().stream().filter(v -> v.getNamespace().equals(namespace)).findAny().isPresent();
    }

    public String getVmodlName() {
        return this._vmodlName;
    }

    public String getPackage() {
        return this._package;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public String getSimpleName() {
        return this._simpleName;
    }

    public service getService() {
        return this._service;
    }

    public Kind getKind() {
        return this._kind;
    }

    public String getWireNs() {
        return this._wireNs;
    }

    public String getWireId() {
        return this._wireId;
    }

    public String getPrintableWireId() {
        return this._wireId != null ? this._wireId : "";
    }

    public String getUniqueWireId() {
        return this._wireId != null || this._kind == Kind.LTS ? this._wireId : this._simpleName;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String getViJsonRelease() {
        return this._viJsonRelease;
    }

    public boolean isNonInitialViJsonRelease() {
        return this._viJsonRelease != null && !_initialViJsonRelease.equals(this._viJsonRelease);
    }

    public supportsManagedObjectsOf getSupportedMO() {
        return this._supportedMO;
    }

    public Set<Version> getDirectParents() {
        return this._directParents;
    }

    public Set<Version> getDirectChildren() {
        return this._directChildren;
    }

    public Set<Version> getAllParents() {
        return this._allParents;
    }

    public Set<Version> getAllChildren() {
        return this._allChildren;
    }

    public boolean isUsed() {
        return this._isUsed;
    }

    public boolean isLegacy() {
        return this._isLegacy;
    }

    public static void initRoot() {
        _root = Versions.getVersion(ROOT);
    }

    public static void setInitialViJsonRelease(String initialViJsonRelease) {
        _initialViJsonRelease = initialViJsonRelease;
    }

    @Override
    public int compareTo(Version v) {
        return this._vmodlName.compareTo(v._vmodlName);
    }

    static {
        _traversePath = new HashSet<Version>();
    }

    public static enum Kind {
        LTS,
        MILESTONE,
        FEATURE,
        DEV,
        DISABLED;

    }
}

