/*
 * Decompiled with CFR 0.152.
 */
package emitters.wsdl;

import emitters.ObjectRegistry;
import emitters.Services;
import emitters.Utils;
import emitters.Versions;
import emitters.backend.Platform;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.ObjectSourceOrderComparator;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.ScopedSourcedOrderComparator;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import emitters.wsdl.BaseXMLGenerator;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import vmodl.LocalizedMethodFault;
import vmodl.ssoToken;

public abstract class BaseWSDLEmitter
extends BaseXMLGenerator {
    protected static final String wsdlService = "service";
    protected static final String wsdlInterface = "interface";
    protected static final String xsd = "xsd";
    protected static final String wsdlOutputDir = "outputDir";
    protected static final String wsdlUnstableDir = "unstableDir";
    protected static final String wsdlName = "name";
    protected static final String wsdlNamespace = "namespace";
    protected static final String wsdlNamespacePrefix = "Nnamespace.prefix";
    protected static final String wsdlCompatibleWith = "compatible.with";
    protected static final String wsdlServiceLocation = "service.location";
    protected static final String wsdlShowInternal = "show.internal";
    protected static final String wsdlAddSecurityPolicies = "add.security.policies";
    protected String _targetNamespace = null;
    protected String _targetNSPrefix = null;
    protected String _serviceLocation = "https://localhost/";
    protected String _wsdlServiceFilename;
    protected String _wsdlInterfaceFilename;
    protected String _xsdFilename;
    protected String _serviceName;
    protected boolean _needMethodFaultType;
    protected boolean _needRuntimeFaultType;
    protected boolean _extendDynamicDataType = true;
    protected boolean _emitDynamicDataType = true;
    protected boolean _twoOpsForTaskMethod = false;
    protected boolean _wsdlAddSecurityPolicies = false;
    protected static final String samlHokTokenPolicyId = "SecPolicy_HoKToken";
    protected static final String samlBearerTokenPolicyId = "SecPolicy_BearerToken";
    protected static final String samlAllAltPolicyId = "SecPolicy_All";
    protected VmodlObject _managedObjectReference = null;
    private final Version _vmodl_version1;

    protected void commonSetup() {
        this._managedObjectReference = ObjectRegistry.getObject("vmodl.ManagedObjectReference");
        this.fillVmodlObjects();
        this.setupTargetNS();
        this.collectSynthesizedArrayTypes();
    }

    protected BaseWSDLEmitter(Map<String, String> options, boolean ltsOnly) {
        for (Map.Entry<String, String> pair : options.entrySet()) {
            String key = pair.getKey();
            String value = pair.getValue();
            if (key.equals(wsdlService)) {
                this._wsdlServiceFilename = value;
                continue;
            }
            if (key.equals(wsdlInterface)) {
                this._wsdlInterfaceFilename = value;
                continue;
            }
            if (key.equals(xsd)) {
                this._xsdFilename = value;
                continue;
            }
            if (key.equals(wsdlOutputDir) && ltsOnly) {
                this._outputDirPath = value;
                continue;
            }
            if (key.equals(wsdlUnstableDir) && !ltsOnly) {
                this._outputDirPath = value;
                continue;
            }
            if (key.equals(wsdlName)) {
                this._serviceName = value;
                continue;
            }
            if (key.equals(wsdlNamespace)) {
                this._targetNamespace = value;
                continue;
            }
            if (key.equals(wsdlNamespacePrefix)) {
                this._targetNSPrefix = value;
                continue;
            }
            if (key.equals(wsdlServiceLocation)) {
                this._serviceLocation = value;
                continue;
            }
            if (key.equals(wsdlCompatibleWith)) {
                String version = value;
                if ("1.2".equals(version)) {
                    this._mapManagedObjectsToXsdString = true;
                    this._addThisParameterToOperations = false;
                    this._addRuntimeFaultToOPerations = false;
                    this._synthesizeArrayTypes = false;
                    this._wrapArrayTypeParameters = false;
                    this._importAutoPrepTypes = true;
                    this._singleFault = true;
                    this._extendDynamicDataType = false;
                    this._emitDynamicDataType = false;
                    continue;
                }
                String optionName = wsdlCompatibleWith.substring(0, wsdlCompatibleWith.length() - 1);
                Platform.printError("Invalid value: " + version + " for " + optionName);
                throw new BaseXMLGenerator.InvalidOptionValueException(optionName, version);
            }
            if (key.equals(wsdlShowInternal)) {
                this.setHideInternalDecls(!Boolean.parseBoolean(value));
                continue;
            }
            if (!key.equals(wsdlAddSecurityPolicies)) continue;
            this._wsdlAddSecurityPolicies = Boolean.parseBoolean(value);
        }
        this._twoOpsForTaskMethod = Versions.getTwoOperationsForTaskMethod();
        if (this._wsdlServiceFilename == null && this._xsdFilename == null) {
            String optionName1 = wsdlService.substring(0, wsdlService.length() - 1);
            String optionName2 = xsd.substring(0, xsd.length() - 1);
            Platform.printError("Options " + optionName1 + " and " + optionName2 + " are both missing.  At least one must be specified.");
            throw new BaseXMLGenerator.MissingRequiredOptionException(optionName1);
        }
        if (this._wsdlServiceFilename != null && this._serviceName == null) {
            String optionName = wsdlName.substring(0, wsdlName.length() - 1);
            Platform.printError("Required option " + optionName + " is missing");
            throw new BaseXMLGenerator.MissingRequiredOptionException(optionName);
        }
        this._needMethodFaultType = this._addRuntimeFaultToOPerations;
        this._needRuntimeFaultType = this._addRuntimeFaultToOPerations;
        this._vmodl_version1 = Versions.getVersion("vmodl.version.version1");
    }

    @Override
    void fillPrimitiveTypeMap() {
        EnumMap<VmodlDecl.TypeId, String> vmodlPrimitiveTypeMap = new EnumMap<VmodlDecl.TypeId, String>(VmodlDecl.TypeId.class);
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.BOOLEAN, "xsd:boolean");
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.BYTE, "xsd:byte");
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.SHORT, "xsd:short");
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.INT, "xsd:int");
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.LONG, "xsd:long");
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.FLOAT, "xsd:float");
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.DOUBLE, "xsd:double");
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.ANY, "xsd:anyType");
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.URI, "xsd:anyURI");
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.DATETIME, "xsd:dateTime");
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.BINARY, "xsd:base64Binary");
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.PROPPATH, "xsd:string");
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.STRING, "xsd:string");
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.METHODNAME, "xsd:string");
        vmodlPrimitiveTypeMap.put(VmodlDecl.TypeId.TYPENAME, "xsd:string");
        _vmodlDeclTypeMap = Collections.unmodifiableMap(vmodlPrimitiveTypeMap);
    }

    protected void emitCopyrightNotice(PrintWriter out) {
        this.emitIndentedLine(out, "<!--", new Object[0]);
        this.indent();
        this.emitIndentedLine(out, "\tCopyright (c) 2005-" + Calendar.getInstance().get(1) + "\n\tBroadcom. All Rights Reserved.\n\tThe term \"Broadcom\" refers to Broadcom Inc.\n\tand/or its subsidiaries.", new Object[0]);
        this.unindent();
        this.emitIndentedLine(out, "-->", new Object[0]);
    }

    protected void emitTypesSection(PrintWriter out, String schemaFilename, String targetNSPrefix, String targetNS) {
        this.emitIndentedLine(out, "<types>", new Object[0]);
        this.indent();
        if (schemaFilename == null) {
            this.emitTargetSchema(out, targetNSPrefix, targetNS);
        } else {
            this.emitIndentedLine(out, "<schema xmlns=\"http://www.w3.org/2001/XMLSchema\">", new Object[0]);
            this.indent();
            this.emitIndentedLine(out, "<xsd:import namespace=\"%s\" schemaLocation=\"%s\" />", targetNS, schemaFilename);
            this.unindent();
            this.emitIndentedLine(out, "</schema>", new Object[0]);
        }
        this.unindent();
        this.emitIndentedLine(out, "</types>", new Object[0]);
    }

    protected void emitPortTypeSection(PrintWriter out) {
        this.emitIndentedLine(out, "<portType name=\"%sPortType\">", this._serviceName);
        this.indent();
        this.generateBindingOperations(out, GenerateElementType.GENERATE_PORT_ELEMENT);
        this.unindent();
        this.emitIndentedLine(out, "</portType>", new Object[0]);
    }

    protected void emitBindingSection(PrintWriter out) {
        this.emitIndentedLine(out, "<binding name=\"%sBinding\" type=\"%s:%sPortType\">", this._serviceName, this._targetNSPrefix, this._serviceName);
        this.indent();
        this.emitIndentedLine(out, "<soap:binding style=\"document\" %s", "transport=\"http://schemas.xmlsoap.org/soap/http\" />");
        this.generateBindingOperations(out, GenerateElementType.GENERATE_OPERATION_ELEMENT);
        this.unindent();
        this.emitIndentedLine(out, "</binding>", new Object[0]);
    }

    protected void emitServiceSection(PrintWriter out, String interfaceNSPrefix) {
        this.emitIndentedLine(out, "<service name=\"%sService\">", this._serviceName);
        this.indent();
        this.emitIndentedLine(out, "<port binding=\"%s:%sBinding\" name=\"%sPort\">", interfaceNSPrefix, this._serviceName, this._serviceName);
        this.indent();
        this.emitIndentedLine(out, "<soap:address location=\"%s\" />", this._serviceLocation);
        this.unindent();
        this.emitIndentedLine(out, "</port>", new Object[0]);
        this.unindent();
        this.emitIndentedLine(out, "</service>", new Object[0]);
    }

    protected void emitInterfaceSections(PrintWriter out, String schemaFilename, String targetNSPrefix, String targetNS) {
        this.emitTypesSection(out, schemaFilename, targetNSPrefix, targetNS);
        this.generateMessages(out);
        this.emitPortTypeSection(out);
        this.emitBindingSection(out);
    }

    protected void emitDefinitionsEndTag(PrintWriter out) {
        this.unindent();
        this.emitIndentedLine(out, "</definitions>", new Object[0]);
    }

    protected void emitXMLDeclaration(PrintWriter out) {
        this.emitIndentedLine(out, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>", new Object[0]);
    }

    protected void emitDefinitionsStartTag(PrintWriter out, String targetNSPrefix, String targetNS, String importNSPrefix, String importNS, String defaultNS, boolean mimeNS, boolean soapNS, boolean xsdNS, boolean wspNS) {
        this.emitIndentedLine(out, "<definitions targetNamespace=\"%s\"", targetNS);
        this.indent();
        this.emitIndentedLine(out, "xmlns=\"%s\"", defaultNS);
        if (mimeNS) {
            this.emitIndentedLine(out, "xmlns:mime=\"http://schemas.xmlsoap.org/wsdl/mime/\"", new Object[0]);
        }
        if (soapNS) {
            this.emitIndentedLine(out, "xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\"", new Object[0]);
        }
        if (targetNSPrefix != null) {
            this.emitIndentedLine(out, "xmlns:%s=\"%s\"", targetNSPrefix, targetNS);
        }
        if (xsdNS) {
            this.emitIndentedLine(out, "xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"", new Object[0]);
        }
        if (importNS != null) {
            if (importNSPrefix == null) {
                this.emitIndentedLine(out, "xmlns:import=\"%s\"", importNS);
            } else {
                this.emitIndentedLine(out, "xmlns:%s=\"%s\"", importNSPrefix, importNS);
            }
        }
        if (wspNS && this._wsdlAddSecurityPolicies) {
            this.emitIndentedLine(out, "xmlns:wsp=\"http://www.w3.org/ns/ws-policy\"", new Object[0]);
            this.emitIndentedLine(out, "xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"", new Object[0]);
            this.emitIndentedLine(out, "xmlns:sp=\"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702\"", new Object[0]);
        }
        this.unindent();
        this.emitIndentedLine(out, ">", new Object[0]);
        this.indent();
    }

    protected void fillVmodlObjects() {
        this._vmodlObjects = new TreeSet<VmodlObject>(ObjectSourceOrderComparator.objectSourceOrderComparator);
        this._vmodlObjects.addAll(ObjectRegistry.getAllObjects());
    }

    protected void setupTargetNS() {
        if (this._targetNamespace == null) {
            Version targetVersion = Versions.getTargetVersion();
            this._targetNamespace = Services.effectiveNamespaceId(targetVersion);
            if (this._targetNamespace.isEmpty()) {
                Platform.printError("Target version " + targetVersion.getVmodlName() + "must have an @wsdlName annotation or some containing scope must have an @service annotation.");
            }
            if (!this.hideInternalDecls()) {
                this._targetNamespace = "internal" + this._targetNamespace;
            }
        }
        if (this._targetNSPrefix == null) {
            this._targetNSPrefix = this._targetNamespace;
        }
        this._targetNamespace = "urn:" + this._targetNamespace;
    }

    private void dispatchGenerateElement(GenerateElementType elType, Method method, boolean forTaskOperation, PrintWriter out) {
        switch (elType) {
            case GENERATE_OPERATION_ELEMENT: {
                this.generateOperationElement(method, forTaskOperation, out);
                break;
            }
            case GENERATE_PORT_ELEMENT: {
                this.generatePortElement(method, forTaskOperation, out);
            }
        }
    }

    protected void generatePortElement(Method method, boolean forTaskOp, PrintWriter out) {
        String name = method.getWsdlName();
        if (!forTaskOp) {
            name = BaseWSDLEmitter.getNonTaskWsdlName(name);
        }
        this.emitIndentedLine(out, "<operation name=\"%s\">", name);
        this.indent();
        this.emitIndentedLine(out, "<input message=\"%s:%sRequestMsg\" />", this._targetNSPrefix, name);
        this.emitIndentedLine(out, "<output message=\"%s:%sResponseMsg\" />", this._targetNSPrefix, name);
        for (DataObject fault : BaseWSDLEmitter.sortedVmodlObjects(method.getFaultList(), ObjectSourceOrderComparator.objectSourceOrderComparator)) {
            if (this._singleFault) {
                this.emitIndentedLine(out, "<fault name=\"%sFault\" message=\"%s:FaultMessage\"/>", fault.getWsdlName(), this._targetNSPrefix, fault.getWsdlName());
                continue;
            }
            this.emitIndentedLine(out, "<fault name=\"%sFault\" message=\"%s:%sFaultMsg\"/>", fault.getWsdlName(), this._targetNSPrefix, fault.getWsdlName());
        }
        if (this._addRuntimeFaultToOPerations) {
            this.emitIndentedLine(out, "<fault name=\"RuntimeFault\" message=\"%s:RuntimeFaultFaultMsg\"/>", this._targetNSPrefix);
        }
        this.unindent();
        this.emitIndentedLine(out, "</operation>", new Object[0]);
    }

    protected void generateBindingOperations(PrintWriter out, GenerateElementType elType) {
        for (VmodlObject obj : this._vmodlObjects) {
            ManagedObject mobj;
            if (!(obj instanceof ManagedObject) || !this.shouldGenerateMo(mobj = (ManagedObject)obj)) continue;
            ScopedSourcedOrderComparator scopedComparator = new ScopedSourcedOrderComparator(obj);
            for (Method method : BaseWSDLEmitter.sortedLocatables(mobj.getMethodList(), scopedComparator)) {
                if (!this.shouldGenerateFor((VmodlObject)mobj, method)) continue;
                if (this._twoOpsForTaskMethod) {
                    this.dispatchGenerateElement(elType, method, false, out);
                    if (!method.isTask()) continue;
                    this.dispatchGenerateElement(elType, method, true, out);
                    continue;
                }
                this.dispatchGenerateElement(elType, method, method.isTask(), out);
            }
        }
    }

    protected void generateOperationElement(Method method, boolean forTaskOperation, PrintWriter out) {
        String wsdlName2 = method.getWsdlName();
        this.emitIndentedLine(out, "<operation name=\"%s\">", forTaskOperation ? wsdlName2 : BaseWSDLEmitter.getNonTaskWsdlName(wsdlName2));
        this.indent();
        Version targetVersion = Versions.getTargetVersion();
        String wireId = targetVersion.getWireId();
        if (wireId == null) {
            this.emitIndentedLine(out, "<soap:operation soapAction=\"\" style=\"document\" />", new Object[0]);
        } else {
            this.emitIndentedLine(out, "<soap:operation soapAction=\"%s\" style=\"document\" />", this._targetNamespace + "/" + wireId);
        }
        if (this._wsdlAddSecurityPolicies && !forTaskOperation) {
            this.generateSecurityPolicyRef(out, method);
        }
        this.emitIndentedLine(out, "<input>", new Object[0]);
        this.indent();
        this.emitIndentedLine(out, "<soap:body use=\"literal\" />", new Object[0]);
        this.unindent();
        this.emitIndentedLine(out, "</input>", new Object[0]);
        this.emitIndentedLine(out, "<output>", new Object[0]);
        this.indent();
        this.emitIndentedLine(out, "<soap:body use=\"literal\" />", new Object[0]);
        this.unindent();
        this.emitIndentedLine(out, "</output>", new Object[0]);
        for (DataObject fault : BaseWSDLEmitter.sortedVmodlObjects(method.getFaultList(), ObjectSourceOrderComparator.objectSourceOrderComparator)) {
            this.emitIndentedLine(out, "<fault name=\"%sFault\">", fault.getWsdlName());
            this.indent();
            this.emitIndentedLine(out, "<soap:fault name=\"%sFault\" use=\"literal\" />", fault.getWsdlName());
            this.unindent();
            this.emitIndentedLine(out, "</fault>", new Object[0]);
        }
        if (this._addRuntimeFaultToOPerations) {
            this.emitIndentedLine(out, "<fault name=\"RuntimeFault\">", new Object[0]);
            this.indent();
            this.emitIndentedLine(out, "<soap:fault name=\"RuntimeFault\" use=\"literal\" />", new Object[0]);
            this.unindent();
            this.emitIndentedLine(out, "</fault>", new Object[0]);
        }
        this.unindent();
        this.emitIndentedLine(out, "</operation>", new Object[0]);
    }

    private void generateSecurityPolicyRef(PrintWriter out, Method md) {
        ssoToken ssoTokenAnno = md.getSSOToken();
        if (ssoTokenAnno == null) {
            return;
        }
        this.emitIndentedLine(out, "<wsp:PolicyReference URI=\"#%s\" />", this.computeRefPolicyId(ssoTokenAnno));
    }

    private String computeRefPolicyId(ssoToken ssoTokenAnno) {
        ssoToken.TokenType tokenType = ssoTokenAnno.tokenType();
        switch (tokenType) {
            case SAML20_HOK: {
                return samlHokTokenPolicyId;
            }
            case SAML20_Bearer: {
                return samlBearerTokenPolicyId;
            }
            case SAML20_ALL: {
                return samlAllAltPolicyId;
            }
        }
        throw new RuntimeException(String.format("Unsupported token type %s for annotation @%s", tokenType.name(), ssoTokenAnno.getClass().getSimpleName()));
    }

    private void generateFaultMessageElement(PrintWriter out, VmodlObject obj) {
        String name = obj.getWsdlName();
        if (this._singleFault) {
            this.emitIndentedLine(out, "<message name=\"FaultMessage\">", new Object[0]);
        } else {
            this.emitIndentedLine(out, "<message name=\"%sFaultMsg\">", name);
        }
        this.indent();
        if (this._singleFault) {
            this.emitIndentedLine(out, "<part name=\"fault\" element=\"%s:%s\" />", this._targetNSPrefix, name);
        } else {
            this.emitIndentedLine(out, "<part name=\"fault\" element=\"%s:%sFault\" />", this._targetNSPrefix, name);
        }
        this.unindent();
        this.emitIndentedLine(out, "</message>", new Object[0]);
    }

    private void generateMessageElement(PrintWriter out, Method method, String elementSuffix, String messageSuffix, Boolean forTaskOp) {
        String name = method.getWsdlName();
        if (!forTaskOp.booleanValue()) {
            name = BaseWSDLEmitter.getNonTaskWsdlName(name);
        }
        this.emitIndentedLine(out, "<message name=\"%s%sMsg\">", name, messageSuffix);
        this.indent();
        this.emitIndentedLine(out, "<part name=\"parameters\" element=\"%s:%s%s\" />", this._targetNSPrefix, name, elementSuffix);
        this.unindent();
        this.emitIndentedLine(out, "</message>", new Object[0]);
    }

    protected void generateMessages(PrintWriter out) {
        for (VmodlObject obj : this._vmodlObjects) {
            ManagedObject mobj;
            if (obj.isFault()) {
                if (!this.shouldGenerate(obj) || obj.getQualifiedVmodlType().equals("vmodl.MethodFault") && !this._needMethodFaultType || obj.getQualifiedVmodlType().equals("vmodl.RuntimeFault") && !this._needRuntimeFaultType) continue;
                this.generateFaultMessageElement(out, obj);
                continue;
            }
            if (!(obj instanceof ManagedObject) || !this.shouldGenerateMo(mobj = (ManagedObject)obj)) continue;
            for (Method method : mobj.getMethodList()) {
                if (!this.shouldGenerateFor((VmodlObject)mobj, method)) continue;
                this.generateMessageElement(out, method, "", "Request", method.isTask());
                this.generateMessageElement(out, method, "Response", "Response", method.isTask());
                if (!this._twoOpsForTaskMethod) continue;
                this.generateMessageElement(out, method, "", "Request", !method.isTask());
                this.generateMessageElement(out, method, "Response", "Response", !method.isTask());
            }
        }
    }

    void emitArrayType(PrintWriter out, VmodlObject obj) {
        if (!this.needArrayOf(obj)) {
            return;
        }
        String name = obj.getWsdlName();
        this.emitIndentedLine(out, "<complexType name=\"ArrayOf%s\">", name);
        this.indent();
        this.emitIndentedLine(out, "<sequence>", new Object[0]);
        this.indent();
        this.emitIndentedLine(out, "<element name=\"%s\" type=\"%s:%s\" minOccurs=\"0\" %s", name, this.schemaId(obj), name, "maxOccurs=\"unbounded\" />");
        this.unindent();
        this.emitIndentedLine(out, "</sequence>", new Object[0]);
        this.unindent();
        this.emitIndentedLine(out, "</complexType>", new Object[0]);
    }

    private void generateForEnum(PrintWriter out, Enum en) {
        this.emitIndentedLine(out, "<simpleType name=\"%s\">", en.getWsdlName());
        this.indent();
        this.emitIndentedLine(out, "<restriction base=\"xsd:string\">", new Object[0]);
        this.indent();
        List<String> values = en.getValueList();
        List<Version> versions = en.getValueVersionList();
        for (int i = 0; i < values.size(); ++i) {
            if (versions.get(i) != null && !Versions.isTargetNewerThan(versions.get(i))) continue;
            this.emitIndentedLine(out, "<enumeration value=\"%s\" />", values.get(i));
        }
        this.unindent();
        this.emitIndentedLine(out, "</restriction>", new Object[0]);
        this.unindent();
        this.emitIndentedLine(out, "</simpleType>", new Object[0]);
        this.emitArrayType(out, en);
    }

    private void emitBuiltinArrayType(PrintWriter out, String typeName, String elementName, String elementType) {
        this.emitIndentedLine(out, "<complexType name=\"%s\">", typeName);
        this.indent();
        this.emitIndentedLine(out, "<sequence>", new Object[0]);
        this.indent();
        this.emitIndentedLine(out, "<element name=\"%s\" type=\"%s\" %s", elementName, elementType, "minOccurs=\"0\" maxOccurs=\"unbounded\" />");
        this.unindent();
        this.emitIndentedLine(out, "</sequence>", new Object[0]);
        this.unindent();
        this.emitIndentedLine(out, "</complexType>", new Object[0]);
    }

    private void emitManagedObjectReferenceType(PrintWriter out) {
        this.emitIndentedLine(out, "<complexType name=\"ManagedObjectReference\">", new Object[0]);
        this.indent();
        this.emitIndentedLine(out, "<simpleContent>", new Object[0]);
        this.indent();
        this.emitIndentedLine(out, "<extension base=\"xsd:string\">", new Object[0]);
        this.indent();
        this.emitIndentedLine(out, "<attribute name=\"type\" type=\"xsd:string\"/>", new Object[0]);
        if (!this.hideInternalDecls() && Versions.isTargetNewerThan(this._vmodl_version1)) {
            this.emitIndentedLine(out, "<attribute name=\"serverGuid\" type=\"xsd:string\" use=\"optional\"/>", new Object[0]);
        }
        this.unindent();
        this.emitIndentedLine(out, "</extension>", new Object[0]);
        this.unindent();
        this.emitIndentedLine(out, "</simpleContent>", new Object[0]);
        this.unindent();
        this.emitIndentedLine(out, "</complexType>", new Object[0]);
    }

    private static int minOccurs(VmodlDecl decl) {
        if (decl.isOptional()) {
            return 0;
        }
        return 1;
    }

    private static int maxOccurs(VmodlDecl decl) {
        if (decl.isArray()) {
            return -1;
        }
        return 1;
    }

    private String primitiveSchemaName(VmodlDecl.TypeId typeId) {
        switch (typeId) {
            case ANY: {
                return "xsd:anyType";
            }
            case BINARY: {
                return "xsd:base64Binary";
            }
            case BOOLEAN: {
                return "xsd:boolean";
            }
            case BYTE: {
                return "xsd:byte";
            }
            case DOUBLE: {
                return "xsd:double";
            }
            case FLOAT: {
                return "xsd:float";
            }
            case INT: {
                return "xsd:int";
            }
            case LONG: {
                return "xsd:long";
            }
            case METHODNAME: 
            case STRING: 
            case TYPENAME: {
                return "xsd:string";
            }
            case SHORT: {
                return "xsd:short";
            }
            case URI: {
                return "xsd:anyURI";
            }
            case DATETIME: {
                return "xsd:dateTime";
            }
            case PROPPATH: 
            case MANAGED: 
            case ENUM: {
                return "";
            }
        }
        throw new RuntimeException("Unexpected primitive element: " + (Object)((Object)typeId));
    }

    protected void emitCoreArrayPrimitives(PrintWriter out, String targetNSPrefix) {
        if (!this._mapManagedObjectsToXsdString) {
            this.emitManagedObjectReferenceType(out);
        }
        if (this.needMoRefArray()) {
            if (this._mapManagedObjectsToXsdString) {
                this.emitBuiltinArrayType(out, "ArrayOfManagedObjectReference", "string", "xsd:string");
            } else {
                this.emitBuiltinArrayType(out, "ArrayOfManagedObjectReference", "ManagedObjectReference", targetNSPrefix + ":ManagedObjectReference");
            }
        }
        this.emitBuiltinArrayType(out, "ArrayOfAnyURI", "anyURI", "xsd:anyURI");
        for (VmodlDecl.TypeId t : this._vmodlDeclPrimitivesNeedingArrayType) {
            if (t.equals((Object)VmodlDecl.TypeId.PROPPATH) || t.equals((Object)VmodlDecl.TypeId.METHODNAME) || t.equals((Object)VmodlDecl.TypeId.TYPENAME)) continue;
            String elementName = t.toString().toLowerCase();
            String typeName = Utils.capitalize(elementName);
            if (t.equals((Object)VmodlDecl.TypeId.ANY)) {
                elementName = elementName + "Type";
                typeName = typeName + "Type";
            } else if (t.equals((Object)VmodlDecl.TypeId.BINARY)) {
                typeName = "Base64Binary";
                elementName = "base64Binary";
            }
            this.emitBuiltinArrayType(out, "ArrayOf" + typeName, elementName, this.primitiveSchemaName(t));
        }
    }

    private void emitThisElementDecl(PrintWriter out) {
        if (this._mapManagedObjectsToXsdString) {
            this.emitIndentedLine(out, "<element name=\"_this\" type=\"xsd:string\" />", new Object[0]);
        } else {
            this.emitIndentedLine(out, "<element name=\"_this\" type=\"%s:ManagedObjectReference\" />", this.schemaArrayPrefix());
        }
    }

    private String schemaArrayTypeReference(VmodlDecl decl, String vmodlName, String currentNSPrefix) {
        StringBuilder b = new StringBuilder(currentNSPrefix);
        if (decl.isManaged() || decl.isData() || decl.isEnum()) {
            switch (decl.getTypeId()) {
                case ANY: {
                    return this.schemaArrayPrefix() + ":ArrayOfAnyType";
                }
                case MANAGED: {
                    return this.schemaArrayPrefix() + ":ArrayOfManagedObjectReference";
                }
                case DATETIME: {
                    return this.schemaArrayPrefix() + ":ArrayOfDateTime";
                }
                case URI: {
                    return this.schemaArrayPrefix() + ":ArrayOfAnyURI";
                }
                case BINARY: {
                    return this.schemaArrayPrefix() + ":ArrayOfBase64Binary";
                }
                case METHODNAME: 
                case STRING: 
                case TYPENAME: 
                case PROPPATH: {
                    return this.schemaArrayPrefix() + ":ArrayOfString";
                }
            }
            b.append(vmodlName);
        }
        int n = currentNSPrefix.length();
        b.setCharAt(n, Character.toUpperCase(b.charAt(n)));
        b.insert(0, "ArrayOf");
        return b.toString();
    }

    private String schemaTypeOrLocalizedMethodFaultReference(VmodlDecl decl, VmodlObject obj, VmodlObject container) {
        String schemaTypeName = this.schemaTypeReference(obj, decl);
        if (decl.isData() && this._needMethodFaultType && obj.isFault()) {
            String typeName = "LocalizedMethodFault";
            if (container != null && this.vmodlObjectIs(container, LocalizedMethodFault.class.getName())) {
                typeName = "MethodFault";
            }
            schemaTypeName = this.schemaArrayPrefix() + ':' + typeName;
        }
        return schemaTypeName;
    }

    private void emitParameterElementDecl(PrintWriter out, Parameter param, String NSPrefix) {
        int minOccurs = BaseWSDLEmitter.minOccurs(param.getDecl());
        int maxOccurs = BaseWSDLEmitter.maxOccurs(param.getDecl());
        if (maxOccurs == -1 && this._wrapArrayTypeParameters) {
            this.emitIndentedLine(out, "<element name=\"%s\" type=\"%s\" />", param.getName(), this.schemaArrayTypeReference(param.getDecl(), param.getName(), NSPrefix));
        } else {
            String typeName = this.schemaTypeOrLocalizedMethodFaultReference(param.getDecl(), param.getDecl().getObject(), null);
            this.emitIndentation(out);
            BaseWSDLEmitter.emitFormattedString(out, "<element name=\"%s\" type=\"%s\"", param.getName(), typeName);
            if (minOccurs != 1) {
                BaseWSDLEmitter.emitFormattedString(out, " minOccurs=\"%d\"", minOccurs);
            }
            if (maxOccurs == -1) {
                BaseWSDLEmitter.emitString(out, " maxOccurs=\"unbounded\"");
            } else if (maxOccurs != 1) {
                BaseWSDLEmitter.emitFormattedString(out, " maxOccurs=\"%d\"", maxOccurs);
            }
            BaseWSDLEmitter.emitString(out, " />");
            BaseWSDLEmitter.emitNewline(out);
        }
    }

    private void emitMethodRequestType(PrintWriter out, Method md, String NSPRefix) {
        if (out == null) {
            return;
        }
        String name = BaseWSDLEmitter.getNonTaskWsdlName(md.getWsdlName());
        List<Parameter> params = md.getParameterList();
        if (params.isEmpty() && !this._addThisParameterToOperations) {
            this.emitIndentedLine(out, "<complexType name=\"%sRequestType\" />", name);
        } else {
            this.emitIndentedLine(out, "<complexType name=\"%sRequestType\">", name);
            this.indent();
            this.emitIndentedLine(out, "<sequence>", new Object[0]);
            this.indent();
            if (this._addThisParameterToOperations) {
                this.emitThisElementDecl(out);
            }
            for (Parameter param : params) {
                if (!this.shouldGenerateFor(param)) continue;
                this.emitParameterElementDecl(out, param, NSPRefix);
            }
            this.unindent();
            this.emitIndentedLine(out, "</sequence>", new Object[0]);
            this.unindent();
            this.emitIndentedLine(out, "</complexType>", new Object[0]);
        }
    }

    private void emitMethodRequestAndResponse(PrintWriter out, ManagedObject mobj, Method method, boolean forTaskOperation, String NSPrefix) {
        if (this._xsdFilename == null) {
            this.indent();
            this.indent();
        }
        String name = method.getWsdlName();
        if (!forTaskOperation) {
            name = BaseWSDLEmitter.getNonTaskWsdlName(name);
        }
        this.emitIndentedLine(out, "<element name=\"%s\"  type=\"%s:%sRequestType\" />", name, this.schemaId(mobj), BaseWSDLEmitter.getNonTaskWsdlName(name));
        this.emitIndentedLine(out, "<element name=\"%sResponse\">", name);
        this.indent();
        VmodlDecl returnType = method.getReturnDecl();
        if (method.isTask() && forTaskOperation) {
            this.emitIndentedLine(out, "<complexType>", new Object[0]);
            this.indent();
            this.emitIndentedLine(out, "<sequence>", new Object[0]);
            this.indent();
            this.emitIndentedLine(out, "<element name=\"returnval\" type=\"%s:ManagedObjectReference\" />", this.schemaArrayPrefix());
            this.unindent();
            this.emitIndentedLine(out, "</sequence>", new Object[0]);
            this.unindent();
            this.emitIndentedLine(out, "</complexType>", new Object[0]);
        } else if (returnType.getTypeId().equals((Object)VmodlDecl.TypeId.VOID)) {
            this.emitIndentedLine(out, "<complexType />", new Object[0]);
        } else {
            this.emitIndentedLine(out, "<complexType>", new Object[0]);
            this.indent();
            this.emitIndentedLine(out, "<sequence>", new Object[0]);
            this.indent();
            int minOccurs = BaseWSDLEmitter.minOccurs(returnType);
            int maxOccurs = BaseWSDLEmitter.maxOccurs(returnType);
            if (maxOccurs == -1 && this._wrapArrayTypeParameters) {
                String wsdlName2 = "<UNREACHED>";
                if (returnType.getObject() != null) {
                    wsdlName2 = returnType.getObject().getWsdlName();
                }
                this.emitIndentedLine(out, "<element name=\"returnval\" type=\"%s\" />", this.schemaArrayTypeReference(returnType, wsdlName2, NSPrefix));
            } else {
                String typeName = this.schemaTypeOrLocalizedMethodFaultReference(returnType, returnType.getObject(), mobj);
                this.emitIndentation(out);
                BaseWSDLEmitter.emitFormattedString(out, "<element name=\"returnval\" type=\"%s\"", typeName);
                if (minOccurs != 1) {
                    BaseWSDLEmitter.emitFormattedString(out, " minOccurs=\"%d\"", minOccurs);
                }
                if (maxOccurs == -1) {
                    BaseWSDLEmitter.emitString(out, " maxOccurs=\"unbounded\"");
                } else if (maxOccurs != 1) {
                    BaseWSDLEmitter.emitFormattedString(out, " maxOccurs=\"%d\"", maxOccurs);
                }
                BaseWSDLEmitter.emitString(out, " />");
                BaseWSDLEmitter.emitNewline(out);
            }
            this.unindent();
            this.emitIndentedLine(out, "</sequence>", new Object[0]);
            this.unindent();
            this.emitIndentedLine(out, "</complexType>", new Object[0]);
        }
        this.unindent();
        this.emitIndentedLine(out, "</element>", new Object[0]);
        if (this._xsdFilename == null) {
            this.unindent();
            this.unindent();
        }
    }

    private void generateForMo(PrintWriter messageOut, PrintWriter elementOut, ManagedObject mobj, String NSPrefix) {
        if (!this.shouldGenerateMo(mobj)) {
            return;
        }
        ScopedSourcedOrderComparator comp = new ScopedSourcedOrderComparator(mobj);
        for (Method method : BaseWSDLEmitter.sortedLocatables(mobj.getMethodList(), comp)) {
            if (!this.shouldGenerateFor((VmodlObject)mobj, method)) continue;
            this.emitMethodRequestType(messageOut, method, NSPrefix);
            if (this._twoOpsForTaskMethod) {
                this.emitMethodRequestAndResponse(elementOut, mobj, method, false, NSPrefix);
                if (!method.isTask()) continue;
                this.emitMethodRequestAndResponse(elementOut, mobj, method, true, NSPrefix);
                continue;
            }
            this.emitMethodRequestAndResponse(elementOut, mobj, method, method.isTask(), NSPrefix);
        }
    }

    private void emitPropertyElementDecl(Property prop, VmodlObject dobj, PrintWriter out) {
        int maxOccurs;
        String typeName = this.schemaTypeOrLocalizedMethodFaultReference(prop.getDecl(), prop.getDecl().getObject(), dobj);
        this.emitIndentation(out);
        BaseWSDLEmitter.emitFormattedString(out, "<element name=\"%s\" type=\"%s\"", prop.getName(), typeName);
        int minOccurs = BaseWSDLEmitter.minOccurs(prop.getDecl());
        Version version = prop.getVersion();
        if (version != dobj.getVersion() && Versions.haveLegacyVersions() && !Versions.hasLegacyChild(version)) {
            minOccurs = 0;
        }
        if (minOccurs != 1) {
            BaseWSDLEmitter.emitFormattedString(out, " minOccurs=\"%d\"", minOccurs);
        }
        if ((maxOccurs = BaseWSDLEmitter.maxOccurs(prop.getDecl())) == -1) {
            BaseWSDLEmitter.emitString(out, " maxOccurs=\"unbounded\"");
        } else if (maxOccurs != 1) {
            BaseWSDLEmitter.emitFormattedString(out, " maxOccurs=\"%d\"", maxOccurs);
        }
        BaseWSDLEmitter.emitString(out, " />");
        BaseWSDLEmitter.emitNewline(out);
    }

    private void emitFaultTypeElementDecl(DataObject dobj, PrintWriter out) {
        if (this._xsdFilename == null) {
            this.indent();
            this.indent();
        }
        if (this._singleFault) {
            this.emitIndentedLine(out, "<element name=\"%s\" type=\"%s:%s\"/>", dobj.getWsdlName(), this.schemaId(dobj), dobj.getWsdlName());
        } else {
            this.emitIndentedLine(out, "<element name=\"%sFault\" type=\"%s:%s\"/>", dobj.getWsdlName(), this.schemaId(dobj), dobj.getWsdlName());
        }
        if (this._xsdFilename == null) {
            this.unindent();
            this.unindent();
        }
    }

    private boolean vmodlObjectIs(VmodlObject obj, String name) {
        return obj.getQualifiedVmodlType().equals(name);
    }

    private void generateForDo(PrintWriter out, PrintWriter elementOut, DataObject dobj) {
        boolean needsExtension;
        if (dobj.isFault() && (this.vmodlObjectIs(dobj, Utils.MethodFaultClassName) && !this._needMethodFaultType || this.vmodlObjectIs(dobj, Utils.RuntimeFaultClassName) && !this._needRuntimeFaultType) || this.vmodlObjectIs(dobj, Utils.DataObjectClassName)) {
            return;
        }
        if (dobj.getQualifiedVmodlType().equals(Utils.DynamicDataClassName) && !this._emitDynamicDataType) {
            return;
        }
        this.emitIndentedLine(out, "<complexType name=\"%s\">", dobj.getWsdlName());
        this.indent();
        VmodlObject base = dobj.getBaseObject();
        boolean bl = needsExtension = !dobj.getQualifiedVmodlType().equals(Utils.DynamicArrayClassName) && !dobj.getQualifiedVmodlType().equals(Utils.DynamicPropertyClassName);
        if (dobj.getQualifiedVmodlType().equals(Utils.DynamicDataClassName)) {
            needsExtension = false;
            this._emitDynamicDataType = false;
        } else if (dobj.getQualifiedVmodlType().equals(Utils.MethodFaultClassName)) {
            needsExtension = false;
        }
        if (needsExtension && this._extendDynamicDataType) {
            this.emitIndentedLine(out, "<complexContent>", new Object[0]);
            this.indent();
            String baseName = base == null || dobj.isFault() && this._singleFault ? this.schemaArrayPrefix() + ":DynamicData" : (dobj.getQualifiedVmodlType().equals(Utils.RuntimeFaultClassName) ? this.schemaArrayPrefix() + ":MethodFault" : this.schemaTypeReferenceDo(base));
            this.emitIndentedLine(out, "<extension base=\"%s\">", baseName);
            this.indent();
        }
        this.emitIndentedLine(out, "<sequence>", new Object[0]);
        this.indent();
        for (Property prop : dobj.getPropertyList()) {
            if (!this.shouldGenerateFor((VmodlObject)dobj, prop) || dobj.hasDynamicProperties() && prop.getWsdlName().equals("dynamicProperty")) continue;
            this.emitPropertyElementDecl(prop, dobj, out);
        }
        this.unindent();
        this.emitIndentedLine(out, "</sequence>", new Object[0]);
        if (needsExtension && this._extendDynamicDataType) {
            this.unindent();
            this.emitIndentedLine(out, "</extension>", new Object[0]);
            this.unindent();
            this.emitIndentedLine(out, "</complexContent>", new Object[0]);
        }
        this.unindent();
        this.emitIndentedLine(out, "</complexType>", new Object[0]);
        this.emitArrayType(out, dobj);
        if (dobj.isFault()) {
            this.emitFaultTypeElementDecl(dobj, elementOut);
        }
    }

    protected void generateTypes(PrintWriter out, PrintWriter elementOut, PrintWriter messageOut, String service2, String NSPrefix) {
        block5: for (VmodlObject obj : this._vmodlObjects) {
            if (!this.shouldGenerateFor(obj, service2)) continue;
            switch (obj.getKind()) {
                case Enum: {
                    this.generateForEnum(out, (Enum)obj);
                    continue block5;
                }
                case ManagedObject: {
                    this.generateForMo(messageOut, elementOut, (ManagedObject)obj, NSPrefix);
                    continue block5;
                }
                case DataObject: {
                    if (obj == this._managedObjectReference) continue block5;
                    this.generateForDo(out, elementOut, (DataObject)obj);
                    continue block5;
                }
            }
            throw new RuntimeException("Internal error: Invalid object kind");
        }
    }

    @Override
    String schemaDefaultNS() {
        return "xsd:";
    }

    public static boolean isDevRequested(Map<String, String> options) {
        return options.containsKey(wsdlUnstableDir);
    }

    abstract void emitTargetSchema(PrintWriter var1, String var2, String var3);

    abstract boolean shouldGenerateFor(VmodlObject var1, String var2);

    abstract boolean shouldGenerateMo(ManagedObject var1);

    static enum GenerateElementType {
        GENERATE_OPERATION_ELEMENT,
        GENERATE_PORT_ELEMENT;

    }
}

